/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureZaProdajuRobe;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Taksafaktura;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.db.entity.Uplata;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.ZatvoriFakturuKupcaAvansomIzmena;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.custom.PzTablePorez;
import rs.pezar.swing.event.PzTableCheckboxListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzSwingUtility;

public class ZatvoriFakturuKupcaAvansom
extends PzDialog {
    private Faktura faktura;
    private JScrollPane jScrollPane1;
    private PzButton btnPotvrdi;
    private PzDoubleField dfUkupno;
    private PzDoubleField dfIznosFakture;
    private JLabel lblIznosFakture;
    private JPanel pnlFaktura;
    private JLabel lblUkupnoZatvaranje;
    private JPanel pnlSummary;
    private PzTable tblZatvaranje;
    private JPanel content;
    private Komitent komitent;
    private Date datum;
    private JLabel lblElementiZatvaranja;
    private JLabel lblDostupniAvansi;
    private PzDoubleField dfPreostaloZaPlacanje;
    private JLabel lblPreostaloZaPlacanje;
    private PzDoubleField dfOsnovicaPoFakturi;
    private JLabel lblOsnovicaPoFakturi;
    private PzDoubleField dfOsnovicaNaZatvaranje;
    private JLabel lblOsnovicaNaZatvaranje;
    private JScrollPane jScrollPane3;
    private PzTablePorez tblZatvaranjePDV;
    private JScrollPane jScrollPane2;
    private PzTablePorez tblFakturaPDV;
    private PzDoubleField dfPdvNaZatvaranje;
    private JLabel lblPdvNaZatvaranje;
    private PzDoubleField dfPdvPoFakturi;
    private JLabel lblPdvPoFakturi;
    private BigDecimal dugPoFakturi;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                ZatvoriFakturuKupcaAvansom inst = new ZatvoriFakturuKupcaAvansom(frame);
                inst.setVisible(true);
            }
        });
    }

    public ZatvoriFakturuKupcaAvansom(JFrame parent) {
        super(parent);
        this.initGUI();
    }

    public ZatvoriFakturuKupcaAvansom(PzDialog parent) {
        super(parent);
        this.setTitle("Zatvaranje fakture avansom");
        if (this.getSession().getParameter("dokument") instanceof Faktura) {
            this.faktura = (Faktura)this.getSession().getParameter("dokument");
        }
        this.komitent = (Komitent)this.getSession().getParameter("komitent");
        this.datum = (Date)this.getSession().getParameter("datumDokumenta");
        this.dugPoFakturi = (BigDecimal)this.getSession().getParameter("dugPoFakturi");
        this.initGUI();
        this.populateGUI();
    }

    private void initGUI() {
        try {
            this.content = new JPanel();
            GridBagLayout contentLayout = new GridBagLayout();
            contentLayout.columnWidths = new int[]{7};
            contentLayout.rowHeights = new int[]{20, 95, 20, 7, 20, 95, 20};
            contentLayout.columnWeights = new double[]{0.1};
            contentLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0};
            this.getContentPane().add((Component)this.content, "Center");
            this.content.setLayout(contentLayout);
            this.content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.jScrollPane1 = new JScrollPane();
            this.content.add((Component)this.jScrollPane1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.tblZatvaranje = new PzTable();
            this.jScrollPane1.setViewportView((Component)this.tblZatvaranje);
            this.tblZatvaranje.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Uplata dok = (Uplata)entity;
                    return new Object[]{dok.getOznDokumentaUpl(), dok.getOstatak().subtract(dok.getStornoIznos()), dok.getDatum(), dok.getIznos()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Broj av. racuna", "Preostali iznos", "Datum av. racuna", "Iznos zatvaranja"};
                }
            });
            this.tblZatvaranje.setSortable(false);
            this.tblZatvaranje.getTableHeader().setFocusable(false);
            this.tblZatvaranje.setCheckboxColumn(0);
            this.tblZatvaranje.addCheckboxListener(new PzTableCheckboxListener(){

                public void valueChanged(int rowIndex, PzEntity entity, boolean checked) {
                    Uplata zatvaranje = (Uplata)entity;
                    if (checked) {
                        ZatvoriFakturuKupcaAvansom.this.getSession().putParameter("zatvaranje", (Object)zatvaranje);
                        ZatvoriFakturuKupcaAvansom.this.showDialog(ZatvoriFakturuKupcaAvansomIzmena.class);
                        zatvaranje = (Uplata)ZatvoriFakturuKupcaAvansom.this.getSession().getParameter("zatvaranje");
                        if (zatvaranje != null) {
                            ZatvoriFakturuKupcaAvansom.this.tblZatvaranje.updateSelectedEntity((PzEntity)zatvaranje, false);
                            ZatvoriFakturuKupcaAvansom.this.sumirajPredlogZatvaranja();
                        }
                    } else {
                        zatvaranje.setIznos(BigDecimal.ZERO);
                        ZatvoriFakturuKupcaAvansom.this.tblZatvaranje.updateSelectedEntity((PzEntity)zatvaranje, false);
                        ZatvoriFakturuKupcaAvansom.this.sumirajPredlogZatvaranja();
                    }
                }
            });
            this.pnlSummary = new JPanel();
            GridBagLayout pnlSummaryLayout = new GridBagLayout();
            pnlSummaryLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1};
            pnlSummaryLayout.rowHeights = new int[]{7, 7, 20, 20, 20};
            pnlSummaryLayout.columnWeights = new double[]{0.1, 0.1};
            pnlSummaryLayout.columnWidths = new int[]{7, 7};
            this.pnlSummary.setLayout(pnlSummaryLayout);
            this.content.add((Component)this.pnlSummary, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblUkupnoZatvaranje = new JLabel("Ukupno zatvaranje: ");
            this.pnlSummary.add((Component)this.lblUkupnoZatvaranje, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblUkupnoZatvaranje.setName("lblUkupnoZatvaranje");
            this.dfUkupno = new PzDoubleField();
            this.pnlSummary.add((Component)this.dfUkupno, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.dfUkupno.setName("dfUkupno");
            this.btnPotvrdi = new PzButton("Potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pnlSummary.add((Component)this.btnPotvrdi, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setName("btnPotvrdi");
            this.lblPdvNaZatvaranje = new JLabel("PDV kod zatvaranja: ");
            this.pnlSummary.add((Component)this.lblPdvNaZatvaranje, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.dfPdvNaZatvaranje = new PzDoubleField();
            this.pnlSummary.add((Component)this.dfPdvNaZatvaranje, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.dfPdvNaZatvaranje.setName("dfPdvNaZatvaranje");
            this.lblOsnovicaNaZatvaranje = new JLabel("Osnovica kod zatvaranja: ");
            this.pnlSummary.add((Component)this.lblOsnovicaNaZatvaranje, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.dfOsnovicaNaZatvaranje = new PzDoubleField();
            this.pnlSummary.add((Component)this.dfOsnovicaNaZatvaranje, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.dfOsnovicaNaZatvaranje.setName("dfOsnovicaNaZatvaranje");
            this.lblPreostaloZaPlacanje = new JLabel("Preostalo za placanje: ");
            this.pnlSummary.add((Component)this.lblPreostaloZaPlacanje, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPreostaloZaPlacanje.setName("lblPreostaloZaPlacanje");
            this.dfPreostaloZaPlacanje = new PzDoubleField();
            this.pnlSummary.add((Component)this.dfPreostaloZaPlacanje, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.dfPreostaloZaPlacanje.setName("dfPreostaloZaPlacanje");
            this.pnlFaktura = new JPanel();
            GridBagLayout pnlFakturaLayout = new GridBagLayout();
            this.content.add((Component)this.pnlFaktura, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFakturaLayout.rowWeights = new double[]{0.0, 0.1, 0.1};
            pnlFakturaLayout.rowHeights = new int[]{7, 20, 20};
            pnlFakturaLayout.columnWeights = new double[]{0.1, 0.1};
            pnlFakturaLayout.columnWidths = new int[]{7, 7};
            this.pnlFaktura.setLayout(pnlFakturaLayout);
            this.lblIznosFakture = new JLabel("Iznos fakture: ");
            this.pnlFaktura.add((Component)this.lblIznosFakture, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblIznosFakture.setName("lblIznosFakture");
            this.dfIznosFakture = new PzDoubleField();
            this.pnlFaktura.add((Component)this.dfIznosFakture, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.dfIznosFakture.setName("dfIznosFakture");
            this.lblPdvPoFakturi = new JLabel("PDV po fakturi: ");
            this.pnlFaktura.add((Component)this.lblPdvPoFakturi, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.dfPdvPoFakturi = new PzDoubleField();
            this.pnlFaktura.add((Component)this.dfPdvPoFakturi, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfPdvPoFakturi.setName("dfPdvPoFakturi");
            this.lblOsnovicaPoFakturi = new JLabel("Osnovica po fakturi: ");
            this.pnlFaktura.add((Component)this.lblOsnovicaPoFakturi, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.dfOsnovicaPoFakturi = new PzDoubleField();
            this.pnlFaktura.add((Component)this.dfOsnovicaPoFakturi, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.dfOsnovicaPoFakturi.setName("dfOsnovicaPoFakturi");
            this.jScrollPane2 = new JScrollPane();
            this.content.add((Component)this.jScrollPane2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.tblFakturaPDV = new PzTablePorez(Taksafaktura.class, null, false);
            this.jScrollPane2.setViewportView((Component)this.tblFakturaPDV);
            this.jScrollPane3 = new JScrollPane();
            this.content.add((Component)this.jScrollPane3, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.tblZatvaranjePDV = new PzTablePorez(Taksaopstidokument.class, null, false);
            this.jScrollPane3.setViewportView((Component)this.tblZatvaranjePDV);
            this.lblDostupniAvansi = new JLabel("Dostupni avansi: ");
            this.content.add((Component)this.lblDostupniAvansi, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
            this.lblDostupniAvansi.setName("lblDostupniAvansi");
            this.lblElementiZatvaranja = new JLabel("Elementi zatvaranja: ");
            this.content.add((Component)this.lblElementiZatvaranja, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
            this.lblElementiZatvaranja.setName("lblElementiZatvaranja");
            this.setSize(587, 660);
            this.setRestorable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dfIznosFakture.getBigDecimal().compareTo(this.dfUkupno.getBigDecimal()) < 0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Iznos ukupnog zatvaranja ne moze biti veci od iznosa fakture");
        } else if (this.dfIznosFakture.getBigDecimal().compareTo(this.dfUkupno.getBigDecimal()) > 0) {
            int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)("Faktura nije u potpunosti zatvorena avansom.\r\nPreostalo je jos " + this.dfPreostaloZaPlacanje.getBigDecimal() + " za placanje.\r\n" + "Da li je to u redu?"), (String)"Preostalo za placanje", null, (boolean)true);
            if (rez == 0) {
                this.snimiUplate();
            }
        } else {
            this.snimiUplate();
        }
    }

    private void snimiUplate() {
        Vector<Uplata> uplataList = new Vector<Uplata>();
        BigDecimal uplataSum = BigDecimal.ZERO;
        try {
            for (Object o : this.tblZatvaranje.getCheckedEntities()) {
                Uplata u = (Uplata)o;
                if (u.getIznos().compareTo(BigDecimal.ZERO) == 0) continue;
                uplataSum = uplataSum.add(u.getIznos());
                u.setDatum(this.faktura.getDatPrometa());
                uplataList.add(u);
            }
            this.faktura.setUplata(uplataSum);
            String nameSession = String.valueOf(this.faktura.getIdDok()) + "avansi";
            this.getSession().putParameter(nameSession, uplataList);
            this.dispose();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void setUplataFakture(Faktura faktura, BigDecimal iznos, EntityManager emFakture) {
        Faktura nova = (Faktura)emFakture.find(Faktura.class, (Object)faktura.getIdDok());
        nova.setUplata(iznos);
    }

    private void populateGUI() {
        try {
            this.dfIznosFakture.setVal((Object)(this.faktura.getTip().equals("FAKTURA_USLUGA") ? this.faktura.getIznos() : this.faktura.getIznosDokumenta()));
            this.dfPdvPoFakturi.setVal(this.sumirajPdvSaFakture());
            this.dfOsnovicaPoFakturi.setVal(this.sumirajOsnovicuSaFakture());
            this.tblFakturaPDV.setPorezi(this.faktura.getTaksafakturas(), true);
            this.tblZatvaranje.setData(this.getPreostaliAvansi(this.faktura), Uplata.class);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    private Object sumirajPdvSaFakture() {
        BigDecimal suma = BigDecimal.ZERO;
        for (Taksafaktura taksa : this.faktura.getTaksafakturas()) {
            suma = suma.add(taksa.getIznos());
        }
        return suma;
    }

    private Object sumirajOsnovicuSaFakture() {
        BigDecimal suma = BigDecimal.ZERO;
        for (Taksafaktura taksa : this.faktura.getTaksafakturas()) {
            suma = suma.add(taksa.getOsnovica());
        }
        return suma;
    }

    private List<Uplata> getPreostaliAvansi(Faktura f) throws Exception {
        String tipPDV = "SA_PDV";
        if (f.getSaPorezom() == 0) {
            tipPDV = f.getSaPravomNaOdbitak() == 1 ? "SA_PRAVOM" : "BEZ_PRAVA";
        }
        Vector list = PzEntityManager.select((String)("SELECT u FROM Uplata u WHERE u.tip='" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS + "' " + "AND u.arhiviran = 1 and u.komitent.sfrKomitent='" + this.komitent.getSfrKomitent() + "' and u.porez='" + tipPDV + "'"));
        ArrayList<Uplata> uplate = new ArrayList<Uplata>();
        for (PzEntity e : list) {
            Uplata uplata = (Uplata)e;
            List<Uplata> prethodnaZatvaranja = this.getPrethodnaZatvaranja(uplata);
            Uplata zatvaranje = new Uplata();
            zatvaranje.setOznDokumenta(this.faktura.getOznDokumenta());
            zatvaranje.setRadnajedinica(this.faktura.getRadnajedinica());
            zatvaranje.setPoDokumentu(this.faktura.getIdDok());
            zatvaranje.setOznDokumentaUpl(uplata.getOznDokumenta());
            zatvaranje.setOriginal((Opstidokument)uplata);
            zatvaranje.setOstatak(this.izracunajIznosPreostalogAvansa(uplata.getIznos(), prethodnaZatvaranja));
            zatvaranje.setTip(TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC);
            zatvaranje.setKomitent(this.komitent);
            zatvaranje.setDatum(uplata.getDatum());
            zatvaranje.setPorez(tipPDV);
            zatvaranje.setTaksadokuments(this.izracunajPreostalePoreze(uplata, prethodnaZatvaranja));
            if (zatvaranje.getOstatak().compareTo(BigDecimal.ZERO) == 0) continue;
            uplate.add(zatvaranje);
        }
        return uplate;
    }

    private List<Uplata> getPrethodnaZatvaranja(Uplata uplata) throws Exception {
        Vector list = PzEntityManager.select((String)("SELECT u FROM Uplata u WHERE u.original.idDok=" + uplata.getIdDok()));
        ArrayList<Uplata> uplate = new ArrayList<Uplata>();
        for (PzEntity e : list) {
            uplate.add((Uplata)e);
        }
        return uplate;
    }

    private BigDecimal izracunajIznosPreostalogAvansa(BigDecimal iznos, List<Uplata> reference) {
        BigDecimal total = iznos;
        for (Uplata uplata : reference) {
            total = total.subtract(uplata.getIznos());
        }
        return total;
    }

    private Taksaopstidokument klonirajPorez(Taksaopstidokument p) {
        Taksaopstidokument porez = new Taksaopstidokument(0, p.getTarifnagrupa().getOznTarGr(), p.getTip());
        porez.setOsnovica(p.getOsnovica());
        porez.setIznos(p.getIznos());
        porez.setTarifnagrupa(p.getTarifnagrupa());
        porez.setVrsta(p.getVrsta());
        return porez;
    }

    private List<Taksaopstidokument> izracunajPreostalePoreze(Uplata uplata, List<Uplata> prethodnaZatvaranja) throws Exception {
        ArrayList<Taksaopstidokument> sviPorezi = new ArrayList<Taksaopstidokument>();
        List poreziSaUplate = uplata.getTaksaopstidokuments();
        for (Taksaopstidokument porezSaUplate : poreziSaUplate) {
            Taksaopstidokument porez = this.klonirajPorez(porezSaUplate);
            sviPorezi.add(porez);
        }
        for (Uplata zatvaranje : prethodnaZatvaranja) {
            List poreziSaZatvaranja = zatvaranje.getTaksaopstidokuments();
            for (Taksaopstidokument porezSaZatvaranja : poreziSaZatvaranja) {
                for (Taksaopstidokument porez : sviPorezi) {
                    if (!porez.getTarifnagrupa().getOznTarGr().equals(porezSaZatvaranja.getTarifnagrupa().getOznTarGr())) continue;
                    porez.setOsnovica(porez.getOsnovica().subtract(porezSaZatvaranja.getOsnovica()));
                    porez.setIznos(porez.getIznos().subtract(porezSaZatvaranja.getIznos()));
                }
            }
        }
        return sviPorezi;
    }

    private List<Taksaopstidokument> sumirajPDVSaZatvaranja() {
        ArrayList poreziSaZatvaranja = new ArrayList();
        List zatvaranja = this.tblZatvaranje.getCheckedEntities();
        for (Uplata uplata : zatvaranja) {
            poreziSaZatvaranja.addAll(uplata.getTaksaopstidokuments());
        }
        ArrayList<Taksaopstidokument> poreziSumarno = new ArrayList<Taksaopstidokument>();
        for (Taksaopstidokument porezSaZatvaranja : poreziSaZatvaranja) {
            Taksaopstidokument found = null;
            Iterator iterator = poreziSumarno.iterator();
            while (iterator.hasNext() && found == null) {
                Taksaopstidokument porezSumarno = (Taksaopstidokument)iterator.next();
                if (!porezSumarno.getId().getOznTarGr().equals(porezSaZatvaranja.getId().getOznTarGr())) continue;
                found = porezSumarno;
            }
            if (found == null) {
                Taksaopstidokument porez = this.klonirajPorez(porezSaZatvaranja);
                poreziSumarno.add(porez);
                continue;
            }
            found.setOsnovica(found.getOsnovica().add(porezSaZatvaranja.getOsnovica()));
            found.setIznos(found.getIznos().add(porezSaZatvaranja.getIznos()));
        }
        return poreziSumarno;
    }

    private void sumirajPredlogZatvaranja() {
        List zatvaranja = this.tblZatvaranje.getCheckedEntities();
        BigDecimal sumaZatvaranja = BigDecimal.ZERO;
        BigDecimal sumaPoreza = BigDecimal.ZERO;
        BigDecimal sumaOsnovice = BigDecimal.ZERO;
        List<Taksaopstidokument> predlogZatvaranjaPDV = this.sumirajPDVSaZatvaranja();
        for (Uplata zatvaranje : zatvaranja) {
            sumaZatvaranja = sumaZatvaranja.add(zatvaranje.getIznos());
        }
        for (Taksaopstidokument porez : predlogZatvaranjaPDV) {
            sumaPoreza = sumaPoreza.add(porez.getIznos());
            sumaOsnovice = sumaOsnovice.add(porez.getOsnovica());
        }
        this.dfUkupno.setVal((Object)sumaZatvaranja);
        this.dfPdvNaZatvaranje.setVal((Object)sumaPoreza);
        this.dfOsnovicaNaZatvaranje.setVal((Object)sumaOsnovice);
        this.tblZatvaranjePDV.clear();
        this.tblZatvaranjePDV.setPorezi(predlogZatvaranjaPDV, true);
        this.dfPreostaloZaPlacanje.setVal((Object)this.dfIznosFakture.getBigDecimal().subtract(this.dfUkupno.getBigDecimal()));
        Color foreground = Color.BLUE;
        if (this.dfPreostaloZaPlacanje.getBigDecimal().compareTo(BigDecimal.ZERO) == 0) {
            foreground = Color.GREEN;
        } else if (this.dfPreostaloZaPlacanje.getBigDecimal().compareTo(BigDecimal.ZERO) < 0) {
            foreground = Color.RED;
        }
        this.dfPreostaloZaPlacanje.setForeground(foreground);
    }
}

