/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.liste.ListaUtil;
import rs.pezar.liste.PzExtensionLoader;
import rs.pezar.sifarnici.gui.PzDialogUsera;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;

public class PosaljiDrugomUSERu
extends PzDialog {
    private static final long serialVersionUID = 3790142934778235952L;
    private PzButton btnPotvrdi;
    private PzTextField tfOznakaUser;
    private JLabel lblOznakaUsera;
    private PzPanel plGlavni;
    private PzTextField userOpis;
    private Pzuser user;
    private String parameter;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PosaljiDrugomUSERu inst = new PosaljiDrugomUSERu(frame);
                inst.setVisible(true);
            }
        });
    }

    public PosaljiDrugomUSERu(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PosaljiDrugomUSERu(PzDialog dialog) {
        super(dialog);
        this.parameter = (String)this.getSession().getParameter("parameter");
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Po\u0161alji drugom USER-u");
            this.plGlavni = new PzPanel();
            this.plGlavni.setPaintGradient(true);
            GridBagLayout plGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.plGlavni, "Center");
            plGlavniLayout.rowWeights = new double[]{0.1, 0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{20, 25, 7};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            plGlavniLayout.columnWidths = new int[]{120, 181, 20};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.lblOznakaUsera = new JLabel();
            this.plGlavni.add((Component)this.lblOznakaUsera, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
            this.lblOznakaUsera.setText("Oznaka USER-a");
            this.lblOznakaUsera.setFont(new Font("Tahoma", 0, 14));
            this.tfOznakaUser = new PzTextField();
            this.plGlavni.add((Component)this.tfOznakaUser, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 1, 0), 0, 0));
            this.tfOznakaUser.setFont(new Font("Tahoma", 0, 14));
            this.tfOznakaUser.setPreferredSize(new Dimension(69, 24));
            this.tfOznakaUser.setFKField(Pzuser.class, PzDialogUsera.class, true, null);
            this.btnPotvrdi = new PzButton();
            this.plGlavni.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 230, 10, 230), 0, 0));
            this.plGlavni.add((Component)this.getUserOpis(), (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 1, 5), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setPreferredSize(new Dimension(140, 31));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/check.png")));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.setSize(615, 135);
            this.setResizable(false);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.user == null) {
            return;
        }
        String username = this.tfOznakaUser.getVal();
        EntityManager em = PzEntityManager.getEm();
        if (username.equals(PzExtensionLoader.getLoggedUser().getPzusername())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Ne mo\u017eete poslati samom sebi. Odaberite drugog korisnika.", "Gre\u0161ka", 0);
            this.tfOznakaUser.requestFocus();
        } else {
            try {
                try {
                    PzTable table = (PzTable)this.getSession().getParameter("table");
                    Lista lista = (Lista)table.getSelectedEntity();
                    em.getTransaction().begin();
                    this.user = (Pzuser)em.find(Pzuser.class, (Object)this.tfOznakaUser.getVal());
                    lista.setPzuser(this.user);
                    em.merge((Object)lista);
                    em.getTransaction().commit();
                    System.out.println("Korisnik " + PzExtensionLoader.getLoggedUser().getFullName() + " vam je prosledio " + (this.parameter.equals("lista") ? "listu" : "narud\u017ebenicu ") + " u pripremi za komitenta " + lista.getKomitent().getPunNaziv());
                    System.out.println(this.parameter.equals("lista") ? "Pristigla je nova lista u pripremi." : "Pristigla je nova narud\u017ebenica u pripremi");
                    ListaUtil.sendMessage(this.user, "Korisnik " + PzExtensionLoader.getLoggedUser().getFullName() + " vam je prosledio " + (this.parameter.equals("lista") ? "listu" : "narud\u017ebenicu ") + " u pripremi za komitenta " + lista.getKomitent().getPunNaziv());
                    ListaUtil.sendNotification(this.user, this.parameter.equals("lista") ? "Pristigla je nova lista" : "Pristigla je nova narud\u017ebenica u pripremi");
                    table.removeSelectedEntity(false, false);
                    this.dispose();
                }
                catch (Exception ex) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Pzuser) {
            this.user = (Pzuser)entity;
            this.tfOznakaUser.setText(this.user.getPzusername());
            this.userOpis.setText(this.user.getFullName());
        }
    }

    private PzTextField getUserOpis() {
        if (this.userOpis == null) {
            this.userOpis = new PzTextField();
            this.userOpis.setFocusable(false);
        }
        return this.userOpis;
    }
}

