/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import rs.pezar.core.transformation.DokumentTransformer;
import rs.pezar.core.transformation.TransformationBreakException;
import rs.pezar.core.transformation.TransformationException;
import rs.pezar.core.transformation.TransformationExecuter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.Lista;
import rs.pezar.liste.DBManager;
import rs.pezar.liste.DokumentTransformerCollector;
import rs.pezar.liste.ListaUtil;
import rs.pezar.liste.PzExtensionLoader;
import rs.pezar.liste.gui.PosaljiDrugomUSERu;
import rs.pezar.liste.gui.PzDialogIzradaListe;
import rs.pezar.liste.gui.PzDialogNovaLista;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogListe
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnListaToDokument;
    private PzToolBarIcon icnSpajanje;
    private PzToolBarIcon icnOtvori;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnArhiviraj;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel mainPanel;
    private PzToolBarIcon icnPosaljiKorisniku;
    private EntityManager em;
    private PzToolBarIcon icnDokumentToLista;
    private JPanel pnlSelect;
    private PzButton icnSelektuj;
    private PzButton icnInverznaSelekcija;
    private PzButton icnSelektujSve;
    private PzButton icnDeselektujSve;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogListe inst = new PzDialogListe(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogListe(JFrame frame) {
        super(frame);
    }

    public boolean shouldBeShown() {
        this.em = PzExtensionLoader.getInstance().getApplication().getEmf().createEm();
        this.getSession().putParameter("em", (Object)this.em);
        this.initGUI();
        this.instantiateTable();
        return true;
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        this.em.close();
    }

    public PzDialogListe(JFrame frame, String parameter) {
        super(frame);
        this.setTitle("Liste korisnika " + PzExtensionLoader.getInstance().getApplication().getSession().getLoggedUser().getFullName());
        this.initGUI();
        this.instantiateTable();
    }

    private void initGUI() {
        try {
            this.setTitle("Liste za korisnika " + PzExtensionLoader.getLoggedUser().getFullName());
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{125, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(10, 7, 7, 7), 0, 0));
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.toolbar.setOpaque(false);
            this.icnOtvori = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnOtvori);
            this.icnOtvori.setText("Otvori|listu (enter)");
            this.icnOtvori.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/scroll_run.png")));
            this.icnOtvori.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogListe.this.icnOtvoriActionPerformed(evt);
                }
            });
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Nova|lista (ins)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/scroll_add.png")));
            this.icnDodavanje.setShortcut("insert");
            this.icnDodavanje.setPreferredSize(new Dimension(77, 80));
            this.icnDodavanje.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogListe.this.icnDodavanjeActionPerformed(evt);
                }
            });
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena na|listi(f3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/scroll_edit.png")));
            this.icnIzmena.setShortcut("f3");
            this.icnIzmena.setPreferredSize(new Dimension(78, 80));
            this.icnIzmena.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogListe.this.icnIzmenaActionPerformed(evt);
                }
            });
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|liste(del)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/scroll_delete.png")));
            this.icnBrisanje.setShortcut("delete");
            this.icnBrisanje.setPreferredSize(new Dimension(73, 80));
            this.icnBrisanje.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogListe.this.icnBrisanjeActionPerformed(evt);
                }
            });
            this.icnPosaljiKorisniku = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPosaljiKorisniku);
            this.icnPosaljiKorisniku.setText("Po\u0161alji|korisniku (alt+f6)");
            this.icnPosaljiKorisniku.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/scroll_user.png")));
            this.icnPosaljiKorisniku.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogListe.this.icnPosaljiKorisnikuActionPerformed(evt);
                }
            });
            this.icnPosaljiKorisniku.setShortcut("alt+f6");
            this.icnSpajanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSpajanje);
            this.icnSpajanje.setText("Spoji liste|(f4)");
            this.icnSpajanje.addActionListener((ActionListener)((Object)this));
            this.icnSpajanje.setShortcut("F4");
            this.icnSpajanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/spojiListe.png")));
            this.icnListaToDokument = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnListaToDokument);
            this.icnListaToDokument.setText("Transformacija|lista->dok. (f5)");
            this.icnListaToDokument.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 6277254823259045431L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogListe.this.icnListaToDokumentAction(evt);
                }
            });
            this.icnListaToDokument.setShortcut("f5");
            this.icnListaToDokument.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/listaToDoc.png")));
            this.icnDokumentToLista = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDokumentToLista);
            this.icnDokumentToLista.setText("Transformacija|dok.->lista (f6)");
            this.icnDokumentToLista.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 6277254823259045431L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogListe.this.icnDokumentToListaAction(evt);
                }
            });
            this.icnDokumentToLista.setShortcut("f6");
            this.icnDokumentToLista.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/docToLista.png")));
            this.pnlSelect = new JPanel();
            FlowLayout pnlSelectLayout = new FlowLayout();
            pnlSelectLayout.setAlignment(0);
            pnlSelectLayout.setVgap(2);
            this.pnlSelect.setLayout(pnlSelectLayout);
            this.toolbar.add(this.pnlSelect);
            this.pnlSelect.setPreferredSize(new Dimension(221, 113));
            this.pnlSelect.setOpaque(false);
            this.icnSelektuj = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektuj);
            this.icnSelektuj.setText("Selektuj trenutni (f2)");
            this.icnSelektuj.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektuj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/selektuj.png")));
            this.icnSelektuj.setPreferredSize(new Dimension(207, 24));
            this.icnSelektuj.setHorizontalAlignment(10);
            this.icnSelektuj.setFocusable(false);
            this.icnSelektuj.setOpaque(false);
            this.icnSelektuj.addActionListener((ActionListener)((Object)this));
            this.icnSelektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektujSve);
            this.icnSelektujSve.setText("Selektuj sve (alt+f2)");
            this.icnSelektujSve.setOpaque(false);
            this.icnSelektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/selection_sve.png")));
            this.icnSelektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnSelektujSve.setHorizontalAlignment(10);
            this.icnSelektujSve.setFocusable(false);
            this.icnSelektujSve.addActionListener((ActionListener)((Object)this));
            this.icnDeselektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnDeselektujSve);
            this.icnDeselektujSve.setText("Deselektuj sve (ctrl+f2)");
            this.icnDeselektujSve.setOpaque(false);
            this.icnDeselektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnDeselektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/deselektuj_sve.png")));
            this.icnDeselektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnDeselektujSve.setHorizontalAlignment(10);
            this.icnDeselektujSve.setFocusable(false);
            this.icnDeselektujSve.addActionListener((ActionListener)((Object)this));
            this.icnInverznaSelekcija = new PzButton();
            this.pnlSelect.add((Component)this.icnInverznaSelekcija);
            this.icnInverznaSelekcija.setText("Inverzna selekcija (ctrl+alt+f2)");
            this.icnInverznaSelekcija.setOpaque(false);
            this.icnInverznaSelekcija.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnInverznaSelekcija.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/selektuj inverzno.png")));
            this.icnInverznaSelekcija.setPreferredSize(new Dimension(208, 24));
            this.icnInverznaSelekcija.setHorizontalAlignment(10);
            this.icnInverznaSelekcija.setFocusable(false);
            this.icnInverznaSelekcija.addActionListener((ActionListener)((Object)this));
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(903, 647);
            this.setMinimumSize(new Dimension(903, 647));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void instantiateTable() {
        this.table = new PzTable(DBManager.getListe(this.em), Lista.class);
        this.getSession().putParameter("table", (Object)this.table);
        this.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 6277254823259045431L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PzDialogListe.this.showDialog(PzDialogIzradaListe.class);
                }
                catch (Exception ex) {
                    PzMysqlExceptionHandler.handle((Component)((Object)PzDialogListe.this), (Throwable)ex);
                }
            }
        });
        this.table.setCheckboxColumn(0, KeyStroke.getKeyStroke(113, 0), KeyStroke.getKeyStroke(113, 512), KeyStroke.getKeyStroke(113, 128), KeyStroke.getKeyStroke(113, 640));
        this.table.unCheckAll();
        try {
            this.table.getColumn((Object)"Tip").setCellRenderer(new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
                    Component renderer = null;
                    Properties props = new Properties();
                    try {
                        props.load(this.getClass().getClassLoader().getResourceAsStream("rs/pezar/liste/resource/tip.properties"));
                    }
                    catch (IOException e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogListe.this), (Throwable)e);
                    }
                    Object[] tipovi = props.keySet().toArray();
                    int i = 0;
                    while (i < tipovi.length) {
                        if (arg1.toString().equals(props.get(tipovi[i]).toString())) {
                            renderer = new PzTextField((String)tipovi[i]);
                            break;
                        }
                        ++i;
                    }
                    if (arg2) {
                        renderer.setBackground(Color.GRAY);
                        renderer.setForeground(Color.white);
                    }
                    ((PzFieldImpl)renderer).setHorizontalAlignment(2);
                    ((PzFieldImpl)renderer).setBorder((Border)new EmptyBorder(new Insets(0, 2, 0, 2)));
                    renderer.setFocusable(false);
                    renderer.setFont(new Font("SansSerif", 1, 13));
                    return renderer;
                }
            });
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.scrollPane.setViewportView((Component)this.table);
        this.brDok.setText(Integer.toString(this.table.getRowCount()));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.icnSelektujSve) {
            this.table.checkAll();
        } else if (e.getSource() == this.icnDeselektujSve) {
            this.table.unCheckAll();
        } else if (e.getSource() == this.icnInverznaSelekcija) {
            this.table.inverseCheck();
        } else if (e.getSource() == this.icnSelektuj) {
            this.table.switchIt();
        } else if (e.getSource() == this.icnSelektuj) {
            this.table.switchIt();
        } else if (e.getSource() == this.icnSpajanje && this.table.getCheckedEntities().size() > 0) {
            PzWorkerDialog.showStatus((String)"Spajanje listi je u toku. Molim, sa\u010dekajte.", (PzDialog)this);
            DBManager.spojiListe(this.table.getCheckedEntities(), this.em, this.table, this);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogListe(Boolean.FALSE);
    }

    public PzDialogListe(Boolean initGUI) {
    }

    private void icnOtvoriActionPerformed(ActionEvent evt) {
        if (this.table.getSelectedEntity() == null) {
            return;
        }
        this.showDialog(PzDialogIzradaListe.class);
    }

    private void icnDodavanjeActionPerformed(ActionEvent evt) {
        this.getSession().putParameter("update", (Object)false);
        this.showDialog(PzDialogNovaLista.class);
    }

    private void icnPosaljiKorisnikuActionPerformed(ActionEvent evt) {
        this.getSession().putParameter("parameter", (Object)"lista");
        this.showDialog(PosaljiDrugomUSERu.class);
    }

    private void icnIzmenaActionPerformed(ActionEvent evt) {
        this.getSession().putParameter("update", (Object)true);
        this.showDialog(PzDialogNovaLista.class);
        this.getSession().putParameter("update", (Object)false);
    }

    private void icnBrisanjeActionPerformed(ActionEvent evt) {
        boolean rez;
        if (this.table.getCheckedEntities().size() == 0) {
            return;
        }
        boolean bl = rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Da li ste sigurni?!", "Brisanje", 0) == 0;
        if (!rez) {
            return;
        }
        PzWorkerDialog.showStatus((String)"Brisanje je u toku. Molim, sa\u010dekajte", (PzDialog)this);
        DBManager.brisiListe(this.table.getCheckedEntities(), this.em, this.table, this);
    }

    private void icnListaToDokumentAction(ActionEvent evt) {
        try {
            List<DokumentTransformer> transformers = DokumentTransformerCollector.getInstance().getTransformers();
            if (this.table.getCheckedEntities().size() == 0) {
                return;
            }
            if (this.table.getCheckedEntities().size() > 1) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Trenutno nije mogu\u0107e transformisati vise listi istovremeno. Morate izabrati samo jednu.");
                return;
            }
            if (transformers == null || transformers.size() == 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Ni jedan transformator nije registrovan.");
                return;
            }
            Vector<String> tNames = new Vector<String>();
            for (DokumentTransformer t : transformers) {
                tNames.addElement(t.getName());
            }
            String userChoice = PzDialogChoice.showPzDialogChoice((PzDialog)this, tNames);
            if (userChoice == null) {
                return;
            }
            DokumentTransformer choosenOne = null;
            for (DokumentTransformer t : transformers) {
                if (!t.getName().equals(userChoice)) continue;
                choosenOne = t;
                break;
            }
            if (choosenOne == null) {
                return;
            }
            final DokumentTransformer ref = choosenOne;
            Lista l1 = (Lista)this.table.getCheckedEntities().get(0);
            Query q = this.em.createNativeQuery("SELECT COUNT(*) FROM Artikallista al WHERE al.idLista=" + l1.getIdLista() + " AND NOT EXISTS(SELECT a.sfrProizvod FROM Artikal a WHERE a.sfrProizvod=al.sfrProizvod)");
            if ((Long)q.getSingleResult() > 0L && !ref.acceptsNonExistent()) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Gre\u0161ka! Lista sadr\u017ei jedan ili vi\u0161e artikala sa \u0161iframa koje ne postoje u bazi!");
                return;
            }
            if ((Long)q.getSingleResult() > 0L && ref.acceptsNonExistent()) {
                List nepostojeci = this.em.createQuery("SELECT al FROM Artikallista al WHERE al.id.idLista=" + l1.getIdLista() + " AND NOT EXISTS(SELECT a.sfrProizvod FROM Artikal a WHERE a.sfrProizvod=al.sfrProizvod)").getResultList();
                ref.handleNonExistent((PzDialog)this, nepostojeci, this.em);
            }
            final PzDialogListe dlg = this;
            final HashMap parameters = choosenOne.getDokumentParameters((PzDialog)this, null);
            if (parameters == null) {
                return;
            }
            PzWorkerDialog.showStatus((String)"Transformacija u toku. Molim sa\u010dekajte.", (PzDialog)this);
            SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

                @Override
                protected Object doInBackground() throws Exception {
                    try {
                        PzDialogListe.this.em.getTransaction().begin();
                        List liste = PzDialogListe.this.table.getCheckedEntities();
                        for (Lista entity : liste) {
                            PzDokument dok = TransformationExecuter.execute((DokumentTransformer)ref, (Lista)entity, (EntityManager)PzDialogListe.this.em, (HashMap)parameters);
                            if (dok == null || dok.getIdDok() != 0) continue;
                            PzDokumentManager.getInstance().snimiDokument(dok, true, null, PzDialogListe.this.em);
                        }
                        PzDialogListe.this.em.getTransaction().commit();
                    }
                    catch (Exception e1) {
                        if (PzDialogListe.this.em.getTransaction().isActive()) {
                            PzDialogListe.this.em.getTransaction().rollback();
                        }
                        throw e1;
                    }
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            this.get();
                        }
                        catch (InterruptedException e) {
                            PzMysqlExceptionHandler.handle((Component)dlg, (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                        catch (ExecutionException e) {
                            block9: {
                                boolean cfr_ignored_0 = e.getCause() instanceof TransformationBreakException;
                                if (e.getCause() instanceof TransformationException) {
                                    PzSwingUtility.showErrorMessage((Component)((Object)PzDialogListe.this), (String)e.getMessage());
                                    break block9;
                                }
                                PzMysqlExceptionHandler.handle((Component)((Object)PzDialogListe.this), (Throwable)e);
                            }
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        PzWorkerDialog.hideStatus();
                    }
                }
            };
            sw.execute();
        }
        catch (Exception e) {
            if (e instanceof TransformationException) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)e.getMessage());
            }
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void icnDokumentToListaAction(ActionEvent evt) {
        List<DokumentTransformer> transformers = DokumentTransformerCollector.getInstance().getTransformers();
        Vector<String> tNames = new Vector<String>();
        for (DokumentTransformer t : transformers) {
            tNames.addElement(t.getName());
        }
        String userChoice = PzDialogChoice.showPzDialogChoice((PzDialog)this, tNames);
        if (userChoice == null) {
            return;
        }
        DokumentTransformer choosenOne = null;
        for (DokumentTransformer t : transformers) {
            if (!t.getName().equals(userChoice)) continue;
            choosenOne = t;
            break;
        }
        if (choosenOne == null) {
            return;
        }
        final DokumentTransformer ref = choosenOne;
        final PzDokument d = choosenOne.getDokumentToTransform((PzDialog)this);
        if (d == null) {
            return;
        }
        final String tip = ListaUtil.getTipListe(this);
        if (tip == null) {
            return;
        }
        PzWorkerDialog.showStatus((String)"Transformacija u toku. Molim sa\u010dekajte.", (PzDialog)this);
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    PzDialogListe.this.em.getTransaction().begin();
                    Lista l = TransformationExecuter.execute((DokumentTransformer)ref, (PzDokument)d, (EntityManager)PzDialogListe.this.em, null);
                    List list = l.getArtikallistas();
                    l.setArtikallistas(null);
                    l.setTip(tip);
                    PzDialogListe.this.table.insert((PzEntity)l, PzDialogListe.this.em);
                    PzDialogListe.this.em.flush();
                    for (Artikallista al : list) {
                        al.getId().setIdLista(l.getIdLista());
                    }
                    l.setArtikallistas(list);
                    PzDialogListe.this.em.getTransaction().commit();
                    PzDialogListe.this.table.commitInsert();
                }
                catch (Exception e1) {
                    if (PzDialogListe.this.em.getTransaction().isActive()) {
                        PzDialogListe.this.em.getTransaction().rollback();
                    }
                    return e1;
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    try {
                        this.get();
                    }
                    catch (InterruptedException e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogListe.this), (Throwable)e);
                        PzWorkerDialog.hideStatus();
                    }
                    catch (ExecutionException e) {
                        block9: {
                            boolean cfr_ignored_0 = e.getCause() instanceof TransformationBreakException;
                            if (e.getCause() instanceof TransformationException) {
                                PzSwingUtility.showErrorMessage((Component)((Object)PzDialogListe.this), (String)e.getMessage());
                                break block9;
                            }
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogListe.this), (Throwable)e);
                        }
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        sw.execute();
    }

    public void ukloniListu() {
        this.table.removeSelectedEntity(false, false);
    }
}

