/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.transformation.DokumentTransformer;
import rs.pezar.core.transformation.TransformationBreakException;
import rs.pezar.core.transformation.TransformationException;
import rs.pezar.core.transformation.TransformationExecuter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzIdGen;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StanjeartikalPK;
import rs.pezar.liste.DokumentTransformerCollector;
import rs.pezar.liste.ListaUtil;
import rs.pezar.liste.PzExtensionLoader;
import rs.pezar.liste.gui.PosaljiDrugomUSERu;
import rs.pezar.liste.gui.narudzbenice.DodavanjeNarudzbenice;
import rs.pezar.liste.gui.narudzbenice.IzradaNarudzbenice;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogNarudzbeniceUPripremi
extends PzDialog {
    private PzPanel pnlGlavni;
    private JToolBar toolbar;
    private PzToolBarIcon icnUlaz;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnPreuzimanjePropusteneProdaje;
    private PzTable table;
    private JScrollPane scrollPane;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private String tipDokumenta = ListaUtil.getTipListe("NARUDZBENICA");
    private String tableID;
    private PzToolBarIcon icnPosaljiDrugomUseru;
    private PzToolBarIcon icnListaToDokument;

    public PzDialogNarudzbeniceUPripremi(JFrame frame, String parameter) {
        super(frame);
        if (parameter.equals("ponuda")) {
            this.tipDokumenta = ListaUtil.getTipListe("PONUDA");
        }
        this.tableID = "TABLE_NARUDZBENICA";
        this.setId("NARUDZBENICA");
        if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
            this.tableID = "TABLE_PONUDA";
            this.setId("PONUDA");
        }
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        Vector data = (Vector)em.createQuery("Select l from Lista l Where l.arhiviran = 0 and l.pzuser.pzusername='" + PzExtensionLoader.getLoggedUser().getPzusername() + "' and l.tip='" + this.tipDokumenta + "' order by l.idLista asc").getResultList();
        this.table.setData(data, Lista.class);
        this.brDok.setText(Integer.toString(data.size()));
        em.close();
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Narud\u017ebenice u pripremi");
            if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
                this.setTitle("Ponude u pripremi");
            }
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout1 = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout1.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            pnlGlavniLayout1.rowHeights = new int[]{85, 7, 7, 7};
            pnlGlavniLayout1.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout1.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout1);
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnUlaz = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUlaz);
            this.icnUlaz.setText("Ulaz u|narud\u017ebenicu|(Enter)");
            if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
                this.icnUlaz.setText("Ulaz u|ponudu|(Enter)");
            }
            this.icnUlaz.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/document_out.png")));
            this.icnUlaz.setActionCommand("ulaz");
            this.icnUlaz.addActionListener((ActionListener)((Object)this));
            this.icnUlaz.setShortcut("Enter");
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Nova|narud\u017ebenica|(Insert)");
            if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
                this.icnDodavanje.setText("Nova|ponuda|(Insert)");
            }
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/document_add.png")));
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setActionCommand("dodavanje");
            this.icnDodavanje.setShortcut("Insert");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|narud\u017ebenice|(F3)");
            if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
                this.icnIzmena.setText("Izmena|ponude|(F3)");
            }
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/document_edit.png")));
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setActionCommand("izmena");
            this.icnIzmena.setShortcut("F3");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|narud\u017ebenice|(Delete)");
            if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
                this.icnBrisanje.setText("Brisanje|ponude|(Delete)");
            }
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/document_delete.png")));
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setActionCommand("brisi");
            this.icnBrisanje.setShortcut("Delete");
            if (this.tipDokumenta.equals(ListaUtil.getTipListe("NARUDZBENICA"))) {
                this.icnListaToDokument = new PzToolBarIcon();
                this.toolbar.add((Component)this.icnListaToDokument);
                this.icnListaToDokument.setText("Transformacija|lista->dokument|(f5)");
                this.icnListaToDokument.addActionListener((ActionListener)new AbstractAction(){
                    private static final long serialVersionUID = 6277254823259045431L;

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PzDialogNarudzbeniceUPripremi.this.icnListaToDokumentAction(evt);
                    }
                });
                this.icnListaToDokument.setShortcut("f5");
                this.icnListaToDokument.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/listaToDoc.png")));
                this.icnPreuzimanjePropusteneProdaje = new PzToolBarIcon();
                this.toolbar.add((Component)this.icnPreuzimanjePropusteneProdaje);
                this.icnPreuzimanjePropusteneProdaje.setText("Preuzimanje|propu\u0161tene|prodaje (F10)");
                this.icnPreuzimanjePropusteneProdaje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/preuzmi_propustenu_prodaju.png")));
                this.icnPreuzimanjePropusteneProdaje.addActionListener((ActionListener)((Object)this));
                this.icnPreuzimanjePropusteneProdaje.setActionCommand("preuzmi");
                this.icnPreuzimanjePropusteneProdaje.setShortcut("F10");
                this.icnPosaljiDrugomUseru = new PzToolBarIcon();
                this.toolbar.add((Component)this.icnPosaljiDrugomUseru);
                this.icnPosaljiDrugomUseru.setText("Slanje|drugom korisniku|(Alt+F6)");
                this.icnPosaljiDrugomUseru.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/user_send.png")));
                this.icnPosaljiDrugomUseru.setActionCommand("PosaljiDrugomUseru");
                this.icnPosaljiDrugomUseru.addActionListener((ActionListener)((Object)this));
                this.icnPosaljiDrugomUseru.setShortcut("ALT+F6");
            }
            this.scrollPane = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            this.table = new PzTable();
            this.table.setId(this.tableID);
            this.scrollPane.setViewportView((Component)this.table);
            this.table.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogNarudzbeniceUPripremi.this.icnUlaz.doClick();
                }
            });
            this.table.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Lista dok = (Lista)entity;
                    Integer idLista = dok.getIdLista();
                    Date datum = dok.getDatum();
                    String komitent = dok.getKomitent() == null ? "" : String.valueOf(dok.getKomitent().getSfrKomitent()) + ", " + dok.getKomitent().getNaziv();
                    return new Object[]{idLista, datum, komitent};
                }

                public String[] getColumnNames() {
                    if (PzDialogNarudzbeniceUPripremi.this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
                        return new String[]{"Broj ponude", "Datum", "Komitent"};
                    }
                    return new String[]{"Broj narud\u017ebenice", "Datum", "Komitent"};
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj narud\u017ebenica");
            if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
                this.jlStatusBar.setText("Broj ponuda");
            }
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(800, 515);
            this.setMinimumSize(new Dimension(800, 515));
            this.pack();
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        try {
            int rez;
            if (actionCommand.equals("preuzmi")) {
                int rez2 = PzSwingUtility.daNeDijalog((Component)this.scrollPane, (Object)"Da li ste sigurni?", (String)"Preuzimanje iz propu\u0161tene prodaje", null, (boolean)false);
                if (rez2 == 0) {
                    PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
                    SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                PzDialogNarudzbeniceUPripremi.this.preuzimanjeIzPropusteneProdaje();
                                PzWorkerDialog.hideStatus();
                            }
                            catch (Exception e) {
                                PzMysqlExceptionHandler.handle((Component)((Object)PzDialogNarudzbeniceUPripremi.this), (Throwable)e);
                            }
                        }
                    };
                    worker.execute();
                }
            } else if (actionCommand.equals("ulaz")) {
                if (this.table.getSelectedRow() != -1) {
                    PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
                    SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                                PzDialogNarudzbeniceUPripremi.this.getSession().putParameter("lista", (Object)PzDialogNarudzbeniceUPripremi.this.table.getSelectedEntity());
                                PzDialogNarudzbeniceUPripremi.this.showDialog(IzradaNarudzbenice.class);
                                PzWorkerDialog.hideStatus();
                            }
                            catch (Exception e) {
                                PzMysqlExceptionHandler.handle((Component)((Object)PzDialogNarudzbeniceUPripremi.this), (Throwable)e);
                            }
                        }
                    };
                    worker.execute();
                }
            } else if (actionCommand.equals("dodavanje")) {
                this.getSession().putParameter("update", (Object)false);
                this.getSession().putParameter("tabela", (Object)this.table);
                this.getSession().putParameter("tipDokumenta", (Object)this.tipDokumenta);
                this.showDialog(DodavanjeNarudzbenice.class);
                this.refresh();
            } else if (actionCommand.equalsIgnoreCase("PosaljiDrugomUseru")) {
                if (this.table.getSelectedRow() != -1) {
                    this.getSession().putParameter("table", (Object)this.table);
                    this.getSession().putParameter("parameter", (Object)"narudzbenica");
                    this.showDialog(PosaljiDrugomUSERu.class);
                }
            } else if (actionCommand.equals("izmena")) {
                if (this.table.getSelectedRow() != -1) {
                    this.getSession().putParameter("update", (Object)true);
                    this.getSession().putParameter("tabela", (Object)this.table);
                    this.showDialog(DodavanjeNarudzbenice.class);
                    this.refresh();
                }
            } else if (actionCommand.equals("brisi") && this.table.getSelectedRow() != -1 && (rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)false)) == 0) {
                PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                            PzDialogNarudzbeniceUPripremi.this.table.removeSelectedEntity(false, true);
                            PzDialogNarudzbeniceUPripremi.this.table.commitRemove();
                            PzDialogNarudzbeniceUPripremi.this.refresh();
                            PzWorkerDialog.hideStatus();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogNarudzbeniceUPripremi.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                };
                worker.execute();
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void icnListaToDokumentAction(ActionEvent evt) {
        block13: {
            final EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            try {
                List<DokumentTransformer> transformers = DokumentTransformerCollector.getInstance().getTransformers();
                if (this.table.getRowCount() == 0) {
                    return;
                }
                if (transformers == null || transformers.size() == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Ni jedan transformator nije registrovan.");
                    return;
                }
                Vector<String> tNames = new Vector<String>();
                for (DokumentTransformer t : transformers) {
                    tNames.addElement(t.getName());
                }
                String userChoice = PzDialogChoice.showPzDialogChoice((PzDialog)this, tNames);
                if (userChoice == null) {
                    return;
                }
                DokumentTransformer choosenOne = null;
                for (DokumentTransformer t : transformers) {
                    if (!t.getName().equals(userChoice)) continue;
                    choosenOne = t;
                    break;
                }
                if (choosenOne == null) {
                    return;
                }
                final DokumentTransformer ref = choosenOne;
                final Lista l1 = (Lista)this.table.getSelectedEntity();
                Query q = em.createNativeQuery("SELECT COUNT(*) FROM Artikallista al WHERE al.idLista=" + l1.getIdLista() + " AND NOT EXISTS(SELECT a.sfrProizvod FROM Artikal a WHERE a.sfrProizvod=al.sfrProizvod)");
                if ((Long)q.getSingleResult() > 0L && !ref.acceptsNonExistent()) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Gre\u0161ka! Lista sadr\u017ei jedan ili vi\u0161e artikala sa \u0161iframa koje ne postoje u bazi!");
                    return;
                }
                if ((Long)q.getSingleResult() > 0L && ref.acceptsNonExistent()) {
                    List nepostojeci = em.createQuery("SELECT al FROM Artikallista al WHERE al.id.idLista=" + l1.getIdLista() + " AND NOT EXISTS(SELECT a.sfrProizvod FROM Artikal a WHERE a.sfrProizvod=al.sfrProizvod)").getResultList();
                    ref.handleNonExistent((PzDialog)this, nepostojeci, em);
                }
                final PzDialogNarudzbeniceUPripremi dlg = this;
                final HashMap parameters = choosenOne.getDokumentParameters((PzDialog)this, null);
                if (parameters == null) {
                    return;
                }
                PzWorkerDialog.showStatus((String)"Transformacija u toku. Molim sa\u010dekajte.", (PzDialog)this);
                SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        try {
                            em.getTransaction().begin();
                            PzDokument dok = TransformationExecuter.execute((DokumentTransformer)ref, (Lista)l1, (EntityManager)em, (HashMap)parameters);
                            if (dok != null && dok.getIdDok() == 0) {
                                PzDokumentManager.getInstance().snimiDokument(dok, true, null, em);
                            }
                            em.getTransaction().commit();
                        }
                        catch (Exception e1) {
                            if (em.getTransaction().isActive()) {
                                em.getTransaction().rollback();
                            }
                            throw e1;
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            try {
                                this.get();
                            }
                            catch (InterruptedException e) {
                                PzMysqlExceptionHandler.handle((Component)dlg, (Throwable)e);
                                PzWorkerDialog.hideStatus();
                                em.close();
                            }
                            catch (ExecutionException e) {
                                block9: {
                                    boolean cfr_ignored_0 = e.getCause() instanceof TransformationBreakException;
                                    if (e.getCause() instanceof TransformationException) {
                                        PzSwingUtility.showErrorMessage((Component)((Object)PzDialogNarudzbeniceUPripremi.this), (String)e.getMessage());
                                        break block9;
                                    }
                                    PzMysqlExceptionHandler.handle((Component)((Object)PzDialogNarudzbeniceUPripremi.this), (Throwable)e);
                                }
                                PzWorkerDialog.hideStatus();
                                em.close();
                            }
                        }
                        finally {
                            PzWorkerDialog.hideStatus();
                            em.close();
                        }
                    }
                };
                sw.execute();
            }
            catch (Exception e) {
                if (e instanceof TransformationException) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)e.getMessage());
                } else {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
                if (em == null || !em.isOpen()) break block13;
                em.close();
            }
        }
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogNarudzbeniceUPripremi.this.brDok.setText(Integer.toString(PzDialogNarudzbeniceUPripremi.this.table.getRowCount()));
            }
        });
    }

    public void ukloniListu() {
        this.table.removeSelectedEntity(false, false);
    }

    private Lista initNarudzbenica(Komitent kom, EntityManager em) {
        Lista narudzbenica = new Lista();
        narudzbenica.setIdLista(Integer.valueOf(PzIdGen.getNextId((String)"LISTA_ID", (int)1, (EntityManager)em).getIdVal()));
        narudzbenica.setArhiviran(Integer.valueOf(0));
        narudzbenica.setKomitent(kom);
        narudzbenica.setTip(this.tipDokumenta);
        narudzbenica.setDatum(PzDateUtility.getCurrentDate());
        narudzbenica.setNaslov("");
        narudzbenica.setPzuser((Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername()));
        narudzbenica.setArtikallistas(new Vector());
        return narudzbenica;
    }

    private void preuzimanjeIzPropusteneProdaje() {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                for (Komitent komitent : em.createQuery("select k from Komitent k where k.sfrKomitent in (select af.artikal.dobavljac.sfrKomitent from Artikalfaktura af where af.faktura.tip ='PROPUSTENA_PRODAJA')").getResultList()) {
                    Lista narudzbenica = this.initNarudzbenica(komitent, em);
                    this.table.insert((PzEntity)narudzbenica, em);
                    for (Artikalfaktura af : em.createQuery("select af from Artikalfaktura af where af.faktura.tip ='PROPUSTENA_PRODAJA' and af.artikal.dobavljac.sfrKomitent='" + komitent.getSfrKomitent() + "'").getResultList()) {
                        Artikallista al = new Artikallista();
                        al.init(af, narudzbenica);
                        al.setKolicina(af.getKolicina());
                        al.setCena(BDConverter.getIznos((double)af.getCena()));
                        Stanjeartikal stanjeArt = (Stanjeartikal)em.find(Stanjeartikal.class, (Object)new StanjeartikalPK(af.getId().getSfrProizvod(), af.getFaktura().getRadnajedinica()));
                        al.setPomKolicina(stanjeArt.getRaspKolicina().doubleValue());
                        al.setOznModel(stanjeArt.getOznModel());
                        al.setLista(narudzbenica);
                        narudzbenica.getArtikallistas().add(al);
                        em.persist((Object)al);
                    }
                }
                Lista narudzbenicaBezKomitenta = this.initNarudzbenica(null, em);
                this.table.insert((PzEntity)narudzbenicaBezKomitenta, em);
                for (Artikalfaktura af : em.createQuery("select af from Artikalfaktura af where af.faktura.tip ='PROPUSTENA_PRODAJA' and af.artikal.dobavljac is null").getResultList()) {
                    Artikallista al = new Artikallista();
                    al.init(af, narudzbenicaBezKomitenta);
                    al.setKolicina(af.getKolicina());
                    al.setCena(BDConverter.getIznos((double)af.getCena()));
                    Stanjeartikal stanjeArt = (Stanjeartikal)em.find(Stanjeartikal.class, (Object)new StanjeartikalPK(af.getId().getSfrProizvod(), af.getFaktura().getRadnajedinica()));
                    al.setPomKolicina(stanjeArt.getRaspKolicina().doubleValue());
                    al.setOznModel(stanjeArt.getOznModel());
                    al.setLista(narudzbenicaBezKomitenta);
                    narudzbenicaBezKomitenta.getArtikallistas().add(al);
                    em.persist((Object)al);
                }
                int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li \u017eelite da obri\u0161ete podatke u propu\u0161tenoj prodaji?", (String)"Brisanje propu\u0161tene prodaje", null, (boolean)false);
                if (rez == 0) {
                    for (Faktura prProd : em.createQuery("select f from Faktura f where f.tip ='PROPUSTENA_PRODAJA'").getResultList()) {
                        em.remove((Object)prProd);
                    }
                }
                em.getTransaction().commit();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PzDialogNarudzbeniceUPripremi.this.postInit();
                    }
                });
            }
            catch (Exception ex) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }
}

