/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui.narudzbenice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.ArtikallistaPK;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Model;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.liste.ListaUtil;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextField;

public class DopunaPoProdaji
extends PzDialog {
    private PzPanelHeader header;
    private PzPanel panel;
    private PzPanel mainPanel;
    private PzTextField tfTip;
    private JLabel jlTarifa;
    private PzTextField tfTarifa;
    private PzDateField pocetniDatum;
    private PzDateField krajnjiDatum;
    private PzPanel panelButtons;
    private PzButton btnOk;
    private PzRadioGroup radioGroup;
    private final Lista narudzbenica = (Lista)this.getSession().getParameter("lista");
    private final PzTable table;
    private JLabel jlTip;
    private final Radnajedinica rj = (Radnajedinica)this.getSession().getParameter("rj");
    private Model model;
    private EntityManager em;

    public DopunaPoProdaji(PzDialog dialog) {
        super(dialog);
        this.table = (PzTable)this.getSession().getParameter("tabela");
        this.initGUI();
    }

    protected void initGUI() {
        BorderLayout blayout = new BorderLayout();
        this.setLayout(blayout);
        this.mainPanel = new PzPanel();
        this.mainPanel.setPaintGradient(true);
        BorderLayout mainPanelLayout = new BorderLayout();
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.setTitle("Prema prodaji izabranom komitentu");
        this.panel = new PzPanel();
        this.mainPanel.add((Component)this.panel, (Object)"Center");
        GridBagLayout panelLayout = new GridBagLayout();
        panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        int[] nArray = new int[5];
        nArray[0] = 25;
        nArray[1] = 24;
        nArray[2] = 25;
        nArray[4] = 27;
        panelLayout.rowHeights = nArray;
        panelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelLayout.columnWidths = new int[]{31, 159, 85, 100, 20};
        this.panel.setLayout((LayoutManager)panelLayout);
        this.radioGroup = DopunaPoProdaji.createRadioGroup();
        this.radioGroup.setSelectedIndex(0);
        this.radioGroup.setOpaque(false);
        GridBagConstraints gbc_pzRadioGroupIntervalKonta = new GridBagConstraints();
        gbc_pzRadioGroupIntervalKonta.gridheight = 4;
        gbc_pzRadioGroupIntervalKonta.insets = new Insets(0, 5, 5, 5);
        gbc_pzRadioGroupIntervalKonta.fill = 1;
        gbc_pzRadioGroupIntervalKonta.gridx = 1;
        gbc_pzRadioGroupIntervalKonta.gridy = 0;
        this.panel.add((Component)this.radioGroup, (Object)new GridBagConstraints(1, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        GridBagConstraints gbc_lblP = new GridBagConstraints();
        gbc_lblP.anchor = 13;
        gbc_lblP.insets = new Insets(0, 0, 5, 5);
        gbc_lblP.gridx = 3;
        gbc_lblP.gridy = 1;
        this.jlTip = new JLabel();
        this.jlTip.setText("Po\u010detni datum:");
        this.panel.add((Component)this.jlTip, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.pocetniDatum = new PzDateField();
        this.panel.add((Component)this.pocetniDatum, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.pocetniDatum.setVal((Object)new Date(new java.util.Date().getTime()));
        this.jlTarifa = new JLabel();
        this.panel.add((Component)this.jlTarifa, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.jlTarifa.setText("Krajnji datum:");
        this.krajnjiDatum = new PzDateField();
        this.panel.add((Component)this.krajnjiDatum, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.krajnjiDatum.setVal((Object)new Date(new java.util.Date().getTime()));
        this.panelButtons = new PzPanel();
        this.panel.add((Component)this.panelButtons, (Object)new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.btnOk = new PzButton();
        this.panelButtons.add((Component)this.btnOk);
        this.btnOk.setText("Potvrdi");
        this.btnOk.setActionCommand("potvrdi");
        this.btnOk.setPreferredSize(new Dimension(70, 25));
        this.btnOk.addActionListener((ActionListener)((Object)this));
        this.header = new PzPanelHeader();
        this.mainPanel.add((Component)this.header, (Object)"North");
        this.header.setTitle("Dopuna po prodaji");
        this.pack();
        this.setSize(541, 317);
        Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            this.em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molimo sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> sw = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    DopunaPoProdaji.this.em.getTransaction().begin();
                    DopunaPoProdaji.this.dopuniti(DopunaPoProdaji.this.em);
                    DopunaPoProdaji.this.em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            this.get();
                            DopunaPoProdaji.this.table.commitInsert();
                            DopunaPoProdaji.this.dispose();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Throwable)e);
                            PzWorkerDialog.hideStatus();
                            DopunaPoProdaji.this.em.close();
                        }
                    }
                    finally {
                        DopunaPoProdaji.this.em.close();
                    }
                }
            };
            sw.execute();
        }
    }

    private void dopuniti(EntityManager em) {
        String upit;
        Query q = null;
        if (this.radioGroup.getSelectedIndex() == 0) {
            upit = "SELECT s.sfrProizvod, artikal.dobSifra, artikal.naziv, artikal.bliziOpis, artikal.jedMere, s.prodCena, s.kolicina-s.alocKolicina, af.kolicina, f.storno, m.oznModel, m.naziv FROM Stanje s, Artikalfaktura af, Faktura f, Artikal artikal LEFT JOIN Model m ON artikal.oznModel = m.oznModel WHERE s.sfrProizvod = af.sfrProizvod and s.sfrProizvod = artikal.sfrProizvod and s.oznRj='%rj%' and af.iddok = f.iddok and f.datPrometa >='%dat1%' and f.datPrometa <='%dat2%' AND f.tip IN (%tip%) AND f.arhiviran=1 AND artikal.proizvodjac='%dob%'";
            upit = upit.replaceAll("%rj%", this.rj.getId().getOznRj()).replaceAll("%dat1%", this.pocetniDatum.getVal().toString()).replaceAll("%dat2%", this.krajnjiDatum.getVal().toString()).replaceAll("%tip%", "'" + TipDokumentConfig.get().FAKTURA + "', '" + TipDokumentConfig.get().FAKTURA_USLUGA + "', '" + TipDokumentConfig.get().FAKTURA_SERVISA + "'").replaceAll("%dob%", this.narudzbenica.getKomitent().getSfrKomitent());
            q = em.createNativeQuery(upit);
        } else if (this.radioGroup.getSelectedIndex() == 1) {
            upit = "SELECT s.sfrProizvod, artikal.dobSifra, artikal.naziv, artikal.bliziOpis, artikal.jedMere, s.prodCena, s.kolicina-s.alocKolicina, af.kolicina, f.storno, m.oznModel, m.naziv FROM Stanje s, Artikalfaktura af, Faktura f, Artikal artikal LEFT JOIN Model m ON artikal.oznModel = m.oznModel WHERE s.sfrProizvod = af.sfrProizvod and s.sfrProizvod = artikal.sfrProizvod and s.oznRj='%rj%' and af.iddok = f.iddok and f.datPrometa >='%dat1%' and f.datPrometa <='%dat2%' AND f.tip IN (%tip%) AND f.arhiviran=1 AND artikal.dobavljac='%dob%'";
            upit = upit.replaceAll("%rj%", this.rj.getId().getOznRj()).replaceAll("%dat1%", this.pocetniDatum.getVal().toString()).replaceAll("%dat2%", this.krajnjiDatum.getVal().toString()).replaceAll("%tip%", "'" + TipDokumentConfig.get().FAKTURA + "', '" + TipDokumentConfig.get().FAKTURA_USLUGA + "', '" + TipDokumentConfig.get().FAKTURA_SERVISA + "'").replaceAll("%dob%", this.narudzbenica.getKomitent().getSfrKomitent());
            q = em.createNativeQuery(upit);
        }
        Vector stavke = (Vector)q.getResultList();
        for (Object[] obj : stavke) {
            String sifra = (String)obj[0];
            String sifraDob = (String)obj[1];
            String naziv = (String)obj[2];
            String bliziOpis = (String)obj[3];
            String jm = (String)obj[4];
            BigDecimal cena = (BigDecimal)obj[5];
            double kolicina = (Double)obj[6];
            double kolicinaNaFakturi = (Double)obj[7];
            int storno = (Integer)obj[8];
            String model = (String)obj[9];
            String nazivModela = (String)obj[10];
            this.narudzbenica.setCounter(this.narudzbenica.getNextRBrojArtikli());
            Artikallista al = this.narudzbenica.getArtikal(sifra);
            if (al != null) {
                if (storno == 1) {
                    al.setKolicina(al.getKolicina() - kolicinaNaFakturi);
                    continue;
                }
                al.setKolicina(al.getKolicina() + kolicinaNaFakturi);
                continue;
            }
            Artikallista artLista = new Artikallista();
            ArtikallistaPK artPK = new ArtikallistaPK(this.narudzbenica.getIdLista(), Integer.valueOf(this.narudzbenica.getCounter()));
            artLista.setId(artPK);
            artLista.setSfrProizvod(sifra);
            artLista.setDobSifra(sifraDob);
            artLista.setNaziv(naziv);
            artLista.setBliziOpis(bliziOpis);
            artLista.setJm(jm);
            artLista.setCena(BDConverter.getProdCena((double)cena.doubleValue()));
            artLista.setKolicina(kolicinaNaFakturi);
            artLista.setPomKolicina(kolicina);
            artLista.setOznModel(model);
            artLista.setNazivModel(nazivModela);
            if (this.narudzbenica.getTip().equals(ListaUtil.getTipListe("PONUDA"))) {
                artLista.setPomKolicina(0.0);
                artLista.setTip("1");
            }
            artLista.setLista(this.narudzbenica);
            this.narudzbenica.getArtikallistas().add(artLista);
            this.table.insert((PzEntity)artLista, em);
        }
        em.merge((Object)this.narudzbenica);
    }

    public static PzRadioGroup createRadioGroup() {
        PzRadioGroup radiogroup = PzRadioGroup.create((Object[])new String[]{"Proizvo\u0111a\u010d", "Dobavlja\u010d"});
        radiogroup.setLayoutAxis(1);
        return radiogroup;
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
        super.thisWindowClosing(evt);
    }
}

