/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.display;

import java.io.IOException;
import java.io.PipedOutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Locale;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.kasa.display.DisplayProperties;
import rs.pezar.kasa.display.SerialStream;

public class Display {
    private static final DecimalFormat AMOUNT_FORMAT = Display.getDecimalFormat("###,###.00");
    private static final DecimalFormat QTY_FORMAT = Display.getDecimalFormat(null);
    private static final int CLR = 12;
    private static final int HOM = 11;
    private static final int CR = 13;
    private static final int LF = 10;
    private static Display _instance;
    private DisplayProperties props;

    private Display(DisplayProperties props) {
        this.props = props;
    }

    public static Display instance() {
        if (_instance == null) {
            Display.initialize();
        }
        return _instance;
    }

    public static void initialize() {
        _instance = new Display(DisplayProperties.load());
    }

    public boolean isConfigured() {
        return this.props != null && this.props.getPort() != null && this.props.getPort().length() > 0;
    }

    public synchronized void displayText(String ... text) {
        block16: {
            if (text == null || !this.isConfigured()) {
                return;
            }
            PipedOutputStream stream = null;
            try {
                try {
                    stream = new SerialStream(this.props.getPort(), this.props.getBaud());
                    stream.write(12);
                    stream.write(11);
                    int i = 0;
                    while (i < text.length) {
                        String line = text[i];
                        if (line == null) {
                            stream.write(13);
                            stream.write(10);
                        }
                        stream.write(line.getBytes("IBM852"));
                        if (line.length() < this.props.getColumns()) {
                            stream.write(13);
                            stream.write(10);
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    PzLogger.getInstance().logException((Throwable)e);
                    if (stream == null) break block16;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        PzLogger.getInstance().logException((Throwable)e2);
                    }
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        PzLogger.getInstance().logException((Throwable)e);
                    }
                }
            }
        }
    }

    public String left(String inputString, int length, char chr) {
        if (inputString.length() >= length) {
            return inputString;
        }
        StringBuilder sb = new StringBuilder();
        while (sb.length() < length - inputString.length()) {
            sb.append(chr);
        }
        sb.append(inputString);
        return sb.toString();
    }

    private String layout(String a, String b, int length) {
        String left = null;
        left = a.length() + b.length() >= length ? a.substring(0, length - b.length() - 1) : a;
        return String.valueOf(left) + this.left(b, length - left.length(), ' ');
    }

    private static DecimalFormat getDecimalFormat(String pattern) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(new Locale("sr"));
        if (pattern != null) {
            df.applyPattern("###,###.00");
        }
        return df;
    }

    private String amount(BigDecimal value) {
        return AMOUNT_FORMAT.format(value.setScale(2, RoundingMode.HALF_UP));
    }

    public void displayLine(String name, BigDecimal qty, BigDecimal price, BigDecimal total) {
        if (!this.isConfigured()) {
            return;
        }
        String qtyStr = QTY_FORMAT.format(qty.setScale(3, RoundingMode.HALF_UP));
        String priceStr = this.amount(price);
        String totalStr = this.amount(total);
        String qtyXpriceStr = String.valueOf(qtyStr) + "x" + priceStr;
        this.displayText(this.layout(name, qtyXpriceStr, (this.props.getRows() - 1) * this.props.getColumns()), this.layout("Suma: ", totalStr, this.props.getColumns()));
    }

    public void displayLine(PzArtikalDokument ad, BigDecimal total) {
        if (ad != null && total != null) {
            this.displayLine(ad.getNaziv(), new BigDecimal(ad.getKolicina()), new BigDecimal(ad.getCena()), total);
        }
    }

    public void displayTotal(BigDecimal total) {
        this.displayText(this.layout("Ukupno za uplatu:", "", this.props.getColumns()), this.layout("", String.valueOf(this.amount(total)) + " din", this.props.getColumns()));
    }

    public static void main(String[] args) throws InterruptedException {
        Display d = Display.instance();
        d.layout("Suma: ", "2000000", 20);
    }
}

