/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Aftaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Komitentparameter;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Pfrtaksa;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.kasa.gui.PzDialogIzradaMaloprodajnogRacunaNew;
import rs.pezar.kasa.gui.util.PzKasaUtil;
import rs.pezar.kasa.lpfr.LPFRException;
import rs.pezar.kasa.lpfr.model.BuyerIdentification;
import rs.pezar.kasa.lpfr.model.InvoiceResponse;
import rs.pezar.kasa.lpfr.model.InvoiceTaxItem;
import rs.pezar.kasa.lpfr.model.InvoiceTransaction;
import rs.pezar.kasa.lpfr.model.RequestParams;
import rs.pezar.kasa.lpfr.rest.LPFRClient;
import rs.pezar.reports.PzDialogJournal;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzTableCheckboxListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.util.PzCacheUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogKonacniRacun
extends PzDialog {
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private JLabel lblUkupno;
    private PzButton btnIzdajRacun;
    private PzTable tblTabela;
    private JScrollPane scrollPane;
    private PzDoubleField dblUkupno;
    private PzToolBarIcon btnSlika;
    private final Komitent kupac;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private Fiskalniracun racun;
    private Boolean updateKolicine;
    private PzBusyPainterUI layerUI;
    private JXLayer<Component> layer;
    private Fiskalniracun poslednjiAvans;

    public PzDialogKonacniRacun(PzDialog dialog) {
        super(dialog);
        this.kupac = (Komitent)this.getSession().getParameter("komitent");
        this.racun = (Fiskalniracun)this.getSession().getParameter("racun");
        this.updateKolicine = (Boolean)this.getSession().getParameter("updateKolicine");
        this.initGUI();
        this.paintPanel();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Izaberite avanse za zatvaranje konacnog racuna");
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.layerUI = new PzBusyPainterUI();
            this.layer = new JXLayer((Component)this.mainPanel, (LayerUI)this.layerUI);
            this.getContentPane().add((Component)this.layer, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1, 0.0};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7, 20};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.btnSlika = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnSlika);
            this.btnSlika.setText("Slika|dokumenta|(F2)");
            this.btnSlika.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/presentation_chart.png")));
            this.btnSlika.setActionCommand("slika");
            this.btnSlika.addActionListener((ActionListener)((Object)this));
            this.btnSlika.setShortcut("F2");
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(7, 7, 7, 7), 0, 0));
            this.tblTabela = new PzTable();
            this.tblTabela.setSortable(false);
            this.scrollPane.setViewportView((Component)this.tblTabela);
            this.tblTabela.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Fiskalniracun dok = (Fiskalniracun)entity;
                    return new Object[]{dok.getLpfrBroj(), dok.getIznos().subtract(dok.getStornoIznos()), dok.getDatum()};
                }

                public String[] getColumnNames() {
                    return new String[]{"PFR broj", "Iznos avansa", "Datum dokumenta"};
                }
            });
            this.tblTabela.addCheckboxListener(new PzTableCheckboxListener(){

                public void valueChanged(int rowIndex, PzEntity entity, boolean newValue) {
                    List checked = PzDialogKonacniRacun.this.tblTabela.getCheckedEntities();
                    BigDecimal total = BigDecimal.ZERO;
                    for (Fiskalniracun fiskalniracun : checked) {
                        total = total.add(fiskalniracun.getIznos());
                    }
                    PzDialogKonacniRacun.this.dblUkupno.setVal((Object)total);
                    if (total.equals(PzDialogKonacniRacun.this.racun.getIznosRacuna())) {
                        PzDialogKonacniRacun.this.dblUkupno.setForeground(Color.GREEN);
                        PzDialogKonacniRacun.this.btnIzdajRacun.setEnabled(true);
                    } else {
                        PzDialogKonacniRacun.this.dblUkupno.setForeground(Color.RED);
                        PzDialogKonacniRacun.this.btnIzdajRacun.setEnabled(false);
                    }
                }
            });
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            System.out.println("Komitent je: " + this.kupac);
            q = em.createQuery("SELECT f FROM Fiskalniracun f where f.podTip='Advance-Sale' and f.komitent.sfrKomitent=:sifra and f.arhiviran = 1 and f.iznos - f.stornoIznos > 0 ORDER BY f.lpfrVreme");
            q.setParameter("sifra", (Object)this.kupac.getSfrKomitent());
            Vector data = (Vector)q.getResultList();
            System.out.println("Nasao je racuna: " + data.size());
            this.tblTabela.setData(data, Fiskalniracun.class);
            this.tblTabela.setCheckboxColumn(0);
            em.close();
            this.tblTabela.getTableHeader().setFocusable(false);
            this.tblTabela.requestFocusInWindow();
            if (this.tblTabela.getDataSize() > 0) {
                this.tblTabela.setRowSelectionInterval(0, 0);
            }
            this.btnIzdajRacun = new PzButton("Izdaj ra\u010dun");
            this.mainPanel.add((Component)this.btnIzdajRacun, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 7), 0, 0));
            this.btnIzdajRacun.setActionCommand("preuzmi");
            this.btnIzdajRacun.addActionListener((ActionListener)((Object)this));
            this.btnIzdajRacun.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/check.png")));
            this.btnIzdajRacun.setEnabled(false);
            this.lblUkupno = new JLabel("Ukupno:");
            this.lblUkupno.setFont(new Font("SansSerif", 1, 14));
            this.mainPanel.add((Component)this.lblUkupno, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 10), 0, 0));
            this.lblUkupno.setName("lblUkupno");
            this.dblUkupno = new PzDoubleField();
            this.dblUkupno.setFont(new Font("SansSerif", 1, 18));
            this.dblUkupno.setForeground(Color.RED);
            this.dblUkupno.setFocusable(false);
            this.dblUkupno.setEditable(false);
            this.dblUkupno.setOpaque(false);
            this.mainPanel.add((Component)this.dblUkupno, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText(" Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(800, 450);
            this.setMinimumSize(new Dimension(800, 450));
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(null, (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("slika")) {
            this.showReport();
        } else if (actionCommand.equals("preuzmi")) {
            this.izdajRacun();
        }
    }

    private void izdajRacun() {
        if (this.kupac == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate izabrati kupca", "Greska", 0);
            return;
        }
        if (this.kupac.getTip() != 2 && (this.kupac.getPib() == null || this.kupac.getPib().trim().equals("") || this.kupac.getMatBroj() == null || this.kupac.getMatBroj().equals(""))) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Faktura se ne mo\u017ee izdati jer kupac nema unet PIB ili mati\u010dni broj", "Greska", 0);
            return;
        }
        if (this.tblTabela.getCheckedEntities().size() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate selektovati avanse koji ce se koristiti za zatvaranje konacnog racuna", "Greska", 0);
            return;
        }
        this.layerUI.setLocked(true);
        SwingWorker<InvoiceResponse, Object> worker = new SwingWorker<InvoiceResponse, Object>(){

            @Override
            protected InvoiceResponse doInBackground() throws Exception {
                InvoiceResponse storno = PzDialogKonacniRacun.this.stornirajAvanse();
                BigDecimal advance = storno.getTotalAmount();
                BigDecimal advanceTax = BigDecimal.ZERO;
                for (InvoiceTaxItem tax : storno.getTaxItems()) {
                    advanceTax = advanceTax.add(tax.getAmount());
                }
                LPFRClient client = new LPFRClient();
                client.attention();
                Boolean bezKase = (Boolean)PzDialogKonacniRacun.this.getSession().getParameter("bez_kase");
                if (bezKase == null) {
                    bezKase = Boolean.FALSE;
                }
                InvoiceTransaction it = InvoiceTransaction.NORMAL_SALE;
                if (!PzDialogKonacniRacun.this.pripremiRacunZaStampu(false, true)) {
                    return null;
                }
                String buyerId = null;
                if (PzDialogKonacniRacun.this.kupac.getTip() == 0) {
                    Komitentparameter jbkjs = PzDialogKonacniRacun.this.kupac.getKomitentparameter("JBKJS");
                    buyerId = jbkjs == null || "".equals(jbkjs.getValue()) ? BuyerIdentification.PIB_KUPCA.value(PzDialogKonacniRacun.this.kupac.getPib()) : BuyerIdentification.PIB_JBKJS.value(String.valueOf(PzDialogKonacniRacun.this.kupac.getPib()) + ":" + jbkjs.getValue());
                } else if (PzDialogKonacniRacun.this.kupac.getTip() == 2 && PzDialogKonacniRacun.this.kupac.getPib().length() == 13) {
                    buyerId = BuyerIdentification.JMBG.value(PzDialogKonacniRacun.this.kupac.getPib());
                }
                PzDialogKonacniRacun.this.racun.setKomitent(PzDialogKonacniRacun.this.kupac);
                RequestParams.Builder builder = RequestParams.getBuilder().withInvoiceType(it.getInvoiceType()).withTransactionType(it.getTransactionType()).withPayment("Cash", BigDecimal.ZERO).withReferentDocumentNumber(storno.getInvoiceNumber()).withReferentDocumentDT(storno.getSdcDateTime()).withAdvance(advance).withAdvanceTax(advanceTax).withBuyerId(buyerId).withMessage(PzDialogKonacniRacun.this.poslednjiAvans != null && PzDialogKonacniRacun.this.poslednjiAvans.getVreme() != null ? "Poslednji avansni ra\u010dun: " + PzDialogKonacniRacun.this.poslednjiAvans.getLpfrBroj() + " " + new SimpleDateFormat("dd.MM.yyyy.").format(PzDialogKonacniRacun.this.poslednjiAvans.getVreme()) + "\r\n" : "");
                client.setTaxMap(PzEntityManager.getList((String)"SELECT t FROM TaxMap t"));
                return client.createInvoice(PzDialogKonacniRacun.this.racun, builder.build());
            }

            @Override
            protected void done() {
                block9: {
                    Boolean bezKase = PzDialogKonacniRacun.this.getSession() != null && PzDialogKonacniRacun.this.getSession().getParameter("bez_kase") != null ? (Boolean)PzDialogKonacniRacun.this.getSession().getParameter("bez_kase") : Boolean.FALSE;
                    try {
                        InvoiceResponse odstampan = (InvoiceResponse)this.get();
                        if (odstampan == null) {
                            return;
                        }
                        try {
                            PzDialogKonacniRacun.this.racun.setLpfrBroj(odstampan.getInvoiceNumber());
                            PzDialogKonacniRacun.this.racun.setLpfrVreme(odstampan.getSdcDateTime());
                            PzDialogKonacniRacun.this.arhivirajRacun(bezKase);
                            PzKasaUtil.napraviFakturu(PzDialogKonacniRacun.this.racun, PzDialogKonacniRacun.this.kupac, PzDialogKonacniRacun.this.racun.getDatum());
                            PzDialogKonacniRacun.this.napraviPrazanRacun();
                            PzDialogKonacniRacun.this.dispose();
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof LPFRException) {
                                JOptionPane.showMessageDialog((Component)((Object)PzDialogKonacniRacun.this), ((LPFRException)e.getCause()).getFullMessage(), "L-PFR greska", 0);
                                break block9;
                            }
                            if (!(e instanceof OptimisticLockException) && !(e instanceof OptimisticLockException)) {
                                PzMysqlExceptionHandler.handle((Throwable)e);
                                break block9;
                            }
                            e.printStackTrace();
                        }
                    }
                    finally {
                        PzDialogKonacniRacun.this.layerUI.setLocked(false);
                    }
                }
            }
        };
        worker.execute();
    }

    private boolean pripremiRacunZaStampu(boolean arhiviraj, boolean saNivelacijom) throws Exception {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        boolean nivSuccess = !saNivelacijom;
        try {
            em.getTransaction().begin();
            InvoiceTransaction it = InvoiceTransaction.NORMAL_SALE;
            if (it.equals(InvoiceTransaction.NORMAL_SALE) && !PzKasaUtil.proveriStanje(this.racun, em)) {
                return false;
            }
            if (this.racun.getIdDok() != 0) {
                this.racun = (Fiskalniracun)em.createQuery("SELECT f FROM Fiskalniracun F JOIN FETCH f.proizvodfiskalniracuns JOIN FETCH f.dokument WHERE f.idDok=" + this.racun.getIdDok()).getSingleResult();
            }
            this.racun.setTip(it.getInvoiceType().equals("Normal") ? "FISKALNI_RACUN" : "ISECAK");
            this.racun.setPodTip(it.getValue());
            this.racun.setStorno(it.getTransactionType().equals("Refund") ? 1 : 0);
            this.racun.sumirajPopust();
            this.racun.setVirman(this.racun.getIznosRacuna());
            String idKupca = this.kupac.getTip() != 2 ? BuyerIdentification.PIB_KUPCA.value(this.kupac.getPib()) : null;
            this.racun.setIdKupca(idKupca != null ? idKupca : null);
            this.racun.setKomitent((Komitent)em.find(Komitent.class, (Object)this.kupac.getSfrKomitent()));
            Timestamp datum = PzDateUtility.getServerTime((EntityManager)em);
            this.racun.setVreme(datum);
            Nivelacija nivelacija = null;
            if (saNivelacijom) {
                Faktura f = this.getFaktura(this.racun, em);
                nivelacija = PzEntityUtil.createNivelacija((PzDokument)f, (boolean)false, (boolean)true, (EntityManager)em);
                this.arhiviraj(nivelacija, em);
                nivSuccess = true;
            }
            if (this.kupac != null && this.kupac.getTip() != 2) {
                this.racun.setPib(this.kupac.getPib());
                this.racun.setMbr(this.kupac.getMatBroj());
                this.racun.setNazivKupca(this.kupac.getNaziv());
                this.racun.setAdresa(this.kupac.getAdresa());
                this.racun.setGrad(this.kupac.getGrad());
                this.racun.setKomitent((Komitent)em.find(Komitent.class, (Object)this.kupac.getSfrKomitent()));
            }
            PzKasaUtil.pripremiZaStampu(this.racun, em, arhiviraj);
            em.getTransaction().commit();
            return true;
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (e instanceof OptimisticLockException || e instanceof OptimisticLockException) {
                boolean bl = this.pripremiRacunZaStampu(arhiviraj, !nivSuccess);
                return bl;
            }
            throw e;
        }
        finally {
            em.close();
        }
    }

    private void arhivirajRacun(boolean bezKase) throws Exception {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            em.getTransaction().begin();
            PzKasaUtil.arhivirajRacun(this.racun, em, this.updateKolicine, bezKase);
            em.getTransaction().commit();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            Throwable cause = e.getCause();
            if (e instanceof OptimisticLockException || cause != null && cause instanceof OptimisticLockException) {
                e.printStackTrace();
                this.arhivirajRacun(bezKase);
            }
            throw e;
        }
    }

    public Faktura getFaktura(Fiskalniracun racun, EntityManager em) {
        Faktura f = null;
        f = new Faktura();
        f.setTip("FAKTURA");
        f.setArtikalfakturas((List)new IndirectList());
        f.setRadnajedinica(racun.getRadnajedinica());
        f.setDatum(PzDateUtility.getServerDate((EntityManager)em));
        for (Proizvodfiskalniracun proizvod : racun.getProizvodfiskalniracuns()) {
            if (proizvod.getId().getSfrProizvod().endsWith("U")) continue;
            Artikalfaktura af = new Artikalfaktura();
            Artikal a = (Artikal)em.find(Artikal.class, (Object)proizvod.getId().getSfrProizvod());
            af.setArtikal(a);
            af.setId(1, proizvod.getId().getSfrProizvod(), 1);
            af.setKolicina(proizvod.getKolicina());
            af.setCena(proizvod.getCena());
            af.setNaziv(proizvod.getNaziv());
            af.setJm(proizvod.getJm());
            af.setAftaksas(new Vector());
            if (proizvod.getTaksas() != null || proizvod.getTaksas().size() != 0) {
                for (PzADTaksa t : proizvod.getTaksas()) {
                    af.getAftaksas().add(new Aftaksa(f.getIdDok(), proizvod.getId().getSfrProizvod(), t.getOznTarGr(), 0, t.getStopa(), t.getOznVrstaTG(), ""));
                }
            }
            f.getArtikalfakturas().add(af);
        }
        return f;
    }

    private void arhiviraj(Nivelacija nivel, EntityManager em) throws Exception {
        if (nivel == null) {
            return;
        }
        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivel, true, null, em);
    }

    private void napraviPrazanRacun() {
        if (this.getSession().getParameter("izArhiveObrisanih") != null) {
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                if (!((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).getFiskalniRacun().booleanValue()) {
                    ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).createFiskalniRacun(em);
                }
                ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).refreshDataTable();
                ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).refreshIznos();
                ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).resetDialogData();
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                if (e instanceof OptimisticLockException || e.getCause() instanceof OptimisticLockException) {
                    this.napraviPrazanRacun();
                } else {
                    PzMysqlExceptionHandler.handle((Throwable)e);
                }
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private InvoiceResponse stornirajAvanse() throws Exception {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            em.getTransaction().begin();
            InvoiceTransaction it = InvoiceTransaction.ADVANCE_REFUND;
            List avansi = this.tblTabela.getCheckedEntities();
            Fiskalniracun s = new Fiskalniracun();
            s.setPzuser(PzApplication.getApplication().getSession().getLoggedUser());
            s.setTip("ISECAK");
            s.setPodTip(it.getValue());
            s.setStorno(1);
            s.setKomitent(this.kupac);
            if (this.kupac.getTip() == 0) {
                s.setIdKupca(BuyerIdentification.PIB_KUPCA.value(this.kupac.getPib()));
            } else if (this.kupac.getTip() == 2 && this.kupac.getPib().length() == 13) {
                s.setIdKupca(BuyerIdentification.JMBG.value(this.kupac.getPib()));
            }
            s.setVreme(PzDateUtility.getServerTime((EntityManager)em));
            ArrayList<Proizvodfiskalniracun> stavke = new ArrayList<Proizvodfiskalniracun>();
            this.poslednjiAvans = null;
            for (Fiskalniracun a : avansi) {
                for (Proizvodfiskalniracun p : a.getProizvodfiskalniracuns()) {
                    Proizvodfiskalniracun p1 = this.getStavka(p, stavke);
                    p1.setFiskalniracun(s);
                }
                s.setKartice(BigDecimal.ZERO);
                s.setGotovina(BigDecimal.ZERO);
                s.setCekovi(BigDecimal.ZERO);
                s.setVirman(BigDecimal.ZERO);
                s.setVaucer(BigDecimal.ZERO);
                s.setOstalo(BigDecimal.ZERO);
                s.setIps(BigDecimal.ZERO);
                em.createQuery("UPDATE Fiskalniracun f set f.stornoIznos = " + a.getIznos() + " WHERE f.idDok = " + a.getIdDok()).executeUpdate();
                em.createQuery("UPDATE Dokument f set f.stornoIznos = " + a.getIznos() + " WHERE f.idDok = " + a.getIdDok()).executeUpdate();
                this.poslednjiAvans = a;
            }
            s.setRadnajedinica(this.poslednjiAvans.getRadnajedinica());
            s.setProizvodfiskalniracuns(stavke);
            s.setRefBroj(this.poslednjiAvans.getLpfrBroj());
            s.setRefVreme(this.poslednjiAvans.getLpfrVreme());
            RequestParams.Builder builder = RequestParams.getBuilder().withInvoiceType(it.getInvoiceType()).withTransactionType(it.getTransactionType()).withPayment("Cash", BigDecimal.ZERO).withBuyerId(s.getIdKupca()).withReferentDocumentNumber(s.getRefBroj()).withReferentDocumentDT(s.getRefVreme());
            LPFRClient client = new LPFRClient();
            client.attention();
            client.setTaxMap(PzEntityManager.getList((String)"SELECT t FROM TaxMap t"));
            s.adjust();
            InvoiceResponse r = client.createInvoice(s, builder.build());
            s.setLpfrBroj(r.getInvoiceNumber());
            s.setLpfrVreme(r.getSdcDateTime());
            PzDokumentManager.getInstance().arhivirajStorno((PzDokument)s, PzEntityManager.KOLICINE_NEPROMENJENE, PzEntityManager.KOLICINA_UKUPNA, true, null, em);
            em.getTransaction().commit();
            InvoiceResponse invoiceResponse = r;
            return invoiceResponse;
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            throw e;
        }
        finally {
            em.close();
        }
    }

    private Proizvodfiskalniracun getStavka(Proizvodfiskalniracun s, List<Proizvodfiskalniracun> stavke) {
        Proizvodfiskalniracun found = null;
        for (Proizvodfiskalniracun p : stavke) {
            if (!s.getId().getSfrProizvod().equals(p.getId().getSfrProizvod())) continue;
            found = p;
            found.setCena(found.getCena() + BDConverter.getIznos((double)(s.getKolicina() * s.getCena())).doubleValue());
            found.setKolicina(1.0);
            break;
        }
        if (found == null) {
            found = new Proizvodfiskalniracun(0, s.getSifra(), stavke.size(), s.getBliziOpis(), Double.valueOf(BDConverter.getIznos((double)(s.getKolicina() * s.getCena())).doubleValue()), "", 1.0, s.getNaziv(), s.getProcRabata(), s.getDobSifra());
            found.setArtikal(s.getArtikal());
            found.setProizvod(s.getProizvod());
            found.setPfrtaksas(new ArrayList());
            found.getPfrtaksas().add(new Pfrtaksa(s.getTaksa("PDV")));
            stavke.add(found);
        }
        return found;
    }

    private BigDecimal saberi(BigDecimal d1, BigDecimal d2) {
        BigDecimal dd1 = d1 == null ? BigDecimal.ZERO : d1;
        BigDecimal dd2 = d2 == null ? BigDecimal.ZERO : d2;
        return dd1.add(dd2);
    }

    private void showReport() {
        try {
            if (this.tblTabela.getSelectedEntity() != null) {
                Fiskalniracun racun = (Fiskalniracun)this.tblTabela.getSelectedEntity();
                String pfrBroj = racun.getLpfrBroj();
                if (pfrBroj == null) {
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)racun);
                } else {
                    File dir = PzCacheUtility.getJournalDir((String)racun.getLpfrVreme().split("T")[0]);
                    File file = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + pfrBroj + ".png");
                    if (!file.exists()) {
                        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)racun);
                    } else {
                        BufferedImage receipt = ImageIO.read(file);
                        this.getSession().putParameter("RECEIPT", (Object)receipt);
                        this.getSession().putParameter("PFR-BROJ", (Object)pfrBroj);
                        this.showDialog(PzDialogJournal.class);
                    }
                }
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }
}

