/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.utility;

import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentFinalizer;
import rs.pezar.db.entity.Artikaldokument;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.globals.TipDokumentConfig;

public class PzKasaFinalizer
implements PzDokumentFinalizer {
    List<String> tipovi = new Vector<String>();

    public PzKasaFinalizer() {
        this.tipovi.add(TipDokumentConfig.get().FISKALNI_RACUN);
        this.tipovi.add(TipDokumentConfig.get().FISKALNI_IZVESTAJ);
    }

    public boolean appliesTo(PzDokument d) {
        return this.tipovi.contains(d.getTip());
    }

    public void finalize(PzDokument d, EntityManager em) {
        if (d.getDokument().getArtikaldokuments() != null) {
            for (Artikaldokument ad : d.getDokument().getArtikaldokuments()) {
                Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(ad.getId().getSfrProizvod(), d.getRadnajedinica()));
                if (s == null) {
                    return;
                }
                if (d.getDokument().getStorno() == 0) {
                    ad.setVrstaPromene("P");
                    s.setKumProdaje(s.getKumProdaje() + ad.getKolicina());
                    continue;
                }
                ad.setVrstaPromene("PS");
                s.setKumProdaje(s.getKumProdaje() - ad.getKolicina());
            }
        }
    }
}

