/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.utility;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGenericService;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Komitentparameter;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.kasa.gui.PzDialogPIN;
import rs.pezar.kasa.gui.PzDialogTaxMap;
import rs.pezar.kasa.lpfr.LPFRException;
import rs.pezar.kasa.lpfr.model.BuyerIdentification;
import rs.pezar.kasa.lpfr.model.InvoiceResponse;
import rs.pezar.kasa.lpfr.model.InvoiceTransaction;
import rs.pezar.kasa.lpfr.model.RequestParams;
import rs.pezar.kasa.lpfr.rest.LPFRClient;
import rs.pezar.swing.PzDialog;

public class PzKasaService
implements PzGenericService {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object run(Map<Object, Object> parameters) throws Exception {
        Object response;
        Faktura f = (Faktura)parameters.get("DOKUMENT");
        EntityManager em = (EntityManager)parameters.get("EntityManager");
        PzDialog parent = (PzDialog)parameters.get("DIALOG_PARENT");
        if (f.getStorno() == 1 && f.getFakturaParameterValue("LPFR_BROJ") == null) {
            throw new PzInfoException("Ne mozete stornirati fakturu koja je uradjena pre uvodjenja sistema za e-fiskalizaciju");
        }
        Fiskalniracun r = this.napraviRacun(f);
        if (f.getStorno() == 1) {
            List racuni = em.createQuery("SELECT r FROM Fiskalniracun r WHERE r.idFakture = " + f.getOriginal().getIdDok()).getResultList();
            if (racuni.size() == 0) {
                throw new PzInfoException("Ne mozete stornirati fakturu jer ne postoji fiskalni racun izdat po ovoj fakturi.");
            }
            Fiskalniracun original = (Fiskalniracun)racuni.get(0);
            r.setRefBroj(original.getLpfrBroj());
            r.setRefVreme(original.getLpfrVreme());
        }
        LPFRClient client = new LPFRClient();
        if (parent != null) {
            String attention = client.attention();
            if (!"".equals(attention)) {
                if (!"1500".equals(attention)) throw new PzInfoException(LPFRClient.getMessage(attention));
                String pin = PzDialogPIN.getPIN(parent);
                if (pin == null) {
                    throw new PzInfoException("Nastavak rada nije moguc bez unosa PIN koda");
                }
                response = client.verifyPIN(pin);
                if (!"0100".equals(response)) {
                    throw new PzInfoException((String)response);
                }
                PzApplication.getApplication().getLocalMachineUserSettings().setProperty("LPFR_PIN", (Object)pin);
            }
        } else {
            try {
                client.attentionWithError();
            }
            catch (LPFRException e) {
                throw new PzInfoException(e.getMessage());
            }
        }
        PzDialogTaxMap.checkRates(parent);
        client.setTaxMap(PzEntityManager.getList((String)"SELECT t FROM TaxMap t"));
        InvoiceTransaction it = InvoiceTransaction.of(r.getPodTip());
        RequestParams params = RequestParams.getBuilder().withBuyerId(r.getIdKupca()).withInvoiceType(it.getInvoiceType()).withTransactionType(it.getTransactionType()).withValidTo(f.getDatValute()).withPayment("WireTransfer", r.getIznosRacuna()).withReferentDocumentNumber(r.getRefBroj()).withReferentDocumentDT(r.getRefVreme()).build();
        r.adjust();
        response = client.createInvoice(r, params);
        r.setLpfrBroj(((InvoiceResponse)response).getInvoiceNumber());
        r.setLpfrVreme(((InvoiceResponse)response).getSdcDateTime());
        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)r, true, null, em);
        Fakturaparameter pfrBroj = f.getFakturaparameter(f.getIdDok(), "LPFR_BROJ");
        if (pfrBroj != null) {
            f.getFakturaparameters().remove(pfrBroj);
        }
        pfrBroj = new Fakturaparameter(f.getIdDok(), "LPFR_BROJ", ((InvoiceResponse)response).getInvoiceNumber(), "PFR Broj racuna");
        em.persist((Object)pfrBroj);
        f.addFakturaparameter(pfrBroj);
        return null;
    }

    private Fiskalniracun napraviRacun(Faktura f) {
        Fiskalniracun r = new Fiskalniracun();
        r.setIdFakture(Integer.valueOf(f.getIdDok()));
        r.setProizvodfiskalniracuns(new ArrayList());
        r.setTaksafiskalniracuns(new ArrayList());
        r.setTip("FISKALNI_RACUN");
        r.setPodTip(f.getStorno() == 0 ? InvoiceTransaction.NORMAL_SALE.getValue() : InvoiceTransaction.NORMAL_REFUND.getValue());
        r.setStorno(f.getStorno());
        r.setKomitent(f.getKomitent());
        r.setVirman(f.getIznos());
        r.setGotovina(BigDecimal.ZERO);
        r.setKartice(BigDecimal.ZERO);
        r.setCekovi(BigDecimal.ZERO);
        r.setVaucer(BigDecimal.ZERO);
        r.setIps(BigDecimal.ZERO);
        r.setOstalo(BigDecimal.ZERO);
        r.setVreme(new Timestamp(new Date().getTime()));
        r.setAdresa(f.getKomitent().getAdresa());
        r.setGrad(f.getKomitent().getGrad());
        if (f.getKomitent().getTip() != 2) {
            Komitentparameter jbkjs = r.getKomitent().getKomitentparameter("JBKJS");
            if (jbkjs == null || "".equals(jbkjs.getValue().trim())) {
                r.setIdKupca(BuyerIdentification.PIB_KUPCA.value(r.getKomitent().getPib()));
            } else {
                r.setIdKupca(BuyerIdentification.PIB_JBKJS.value(String.valueOf(r.getKomitent().getPib()) + ":" + jbkjs.getValue()));
            }
        } else if (f.getKomitent().getPib().length() == 13) {
            r.setIdKupca(BuyerIdentification.JMBG.value(r.getKomitent().getPib()));
        } else if (f.getKomitent().getMatBroj().length() == 13) {
            r.setIdKupca(BuyerIdentification.JMBG.value(r.getKomitent().getMatBroj()));
        }
        r.setIznos(f.getIznos());
        r.setMbr(f.getKomitent().getMatBroj());
        r.setNazivKupca(f.getKomitent().getNaziv());
        r.setPib(f.getKomitent().getPib());
        r.setPzuser(f.getUserKraj());
        r.setRadnajedinica(f.getRadnajedinica());
        r.kopirajArtikleSaFakture(f);
        r.getProizvodfiskalniracuns();
        return r;
    }
}

