/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.service.msg.chat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import rs.pezar.core.PzApplication;
import rs.pezar.msg.chat.interfaces.QueueWindowInterface;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.service.msg.chat.textComponent.PzChatTextComponent;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzPanel;
import rs.pezar.util.AudioUtility;

public class QueueWindow
extends JFrame
implements QueueWindowInterface,
ActionListener {
    private PzChatTextComponent pzChatText;
    private JTextField textWrite;
    public static String CHAT_SOUND_ENABLED = "CHAT_SOUND_ENABLED";
    public static String CHAT_POPUP_ENABLED = "CHAT_POPUP_ENABLED";
    private MsgProtocol msgProt;
    private String queueName;
    private String writeToUser;
    private String localUser;
    private String localUserQueue;
    private JScrollPane jScrollPane1;
    private static final Object mutex = new Object();
    private PzPanel pzPanel;
    private PzPanel pzPanel_1;
    private JLabel lblNewLabel;
    private KeyListener l = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 && !QueueWindow.this.textWrite.getText().equals("")) {
                QueueWindow.this.sendNewMessage(QueueWindow.this.msgProt.getUser(), QueueWindow.this.textWrite.getText());
                QueueWindow.this.textWrite.setText("");
            }
        }
    };
    private PzPanel pzPanel_2;
    private PzButton btnUp;
    private PzButton btnDown;
    private JLabel label;

    public QueueWindow(MsgProtocol msgProtocol, String toUser) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(QueueWindow.class.getResource("/rs/pezar/service/msg/chat/resource/img/Chat_bubble_small.png")));
        this.msgProt = msgProtocol;
        this.queueName = String.valueOf("queue.") + toUser;
        this.writeToUser = toUser;
        this.localUser = msgProtocol.getUser();
        this.localUserQueue = String.valueOf("queue.") + this.localUser;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.pzPanel = new PzPanel();
            this.pzPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 55));
            this.pzPanel.setPreferredSize(new Dimension(10, 50));
            this.pzPanel.setSize(new Dimension(0, 55));
            this.pzPanel.setGradient((Color)SystemColor.activeCaption, UIManager.getColor("InternalFrame.inactiveTitleGradient"), PzPanel.GRADIENT_NORTH_SOUTH);
            this.pzPanel.setPaintGradient(true);
            this.getContentPane().add((Component)this.pzPanel);
            GridBagLayout gbl_pzPanel = new GridBagLayout();
            int[] nArray = new int[4];
            nArray[0] = 534;
            nArray[1] = 30;
            nArray[2] = 27;
            gbl_pzPanel.columnWidths = nArray;
            int[] nArray2 = new int[2];
            nArray2[0] = 48;
            gbl_pzPanel.rowHeights = nArray2;
            gbl_pzPanel.columnWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
            gbl_pzPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.pzPanel.setLayout((LayoutManager)gbl_pzPanel);
            this.lblNewLabel = new JLabel(this.writeToUser);
            this.lblNewLabel.setIcon(new ImageIcon(QueueWindow.class.getResource("/rs/pezar/service/msg/chat/resource/img/Chat_bubble_big.png")));
            this.lblNewLabel.setBackground(SystemColor.textText);
            this.lblNewLabel.setFont(new Font("Tahoma", 1, 13));
            GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
            gbc_lblNewLabel.insets = new Insets(0, 0, 0, 5);
            gbc_lblNewLabel.anchor = 18;
            gbc_lblNewLabel.gridx = 0;
            gbc_lblNewLabel.gridy = 0;
            this.pzPanel.add((Component)this.lblNewLabel, (Object)gbc_lblNewLabel);
            this.label = new JLabel("");
            this.label.setIcon(new ImageIcon(QueueWindow.class.getResource("/rs/pezar/service/msg/chat/resource/img/font.png")));
            GridBagConstraints gbc_label = new GridBagConstraints();
            gbc_label.insets = new Insets(0, 0, 0, 5);
            gbc_label.gridx = 1;
            gbc_label.gridy = 0;
            this.pzPanel.add((Component)this.label, (Object)gbc_label);
            this.pzPanel_2 = new PzPanel();
            GridBagConstraints gbc_pzPanel_2 = new GridBagConstraints();
            gbc_pzPanel_2.gridx = 2;
            gbc_pzPanel_2.gridy = 0;
            this.pzPanel.add((Component)this.pzPanel_2, (Object)gbc_pzPanel_2);
            this.pzPanel_2.setLayout((LayoutManager)new BoxLayout((Container)this.pzPanel_2, 1));
            this.btnUp = new PzButton();
            this.btnUp.setBorderPainted(false);
            this.btnUp.setBorder((Border)new LineBorder(new Color(0, 0, 0)));
            this.btnUp.setIcon((Icon)new ImageIcon(QueueWindow.class.getResource("/rs/pezar/service/msg/chat/resource/img/navigate_up.png")));
            this.pzPanel_2.add((Component)this.btnUp);
            this.btnUp.addActionListener((ActionListener)this);
            this.btnDown = new PzButton();
            this.btnDown.setBorderPainted(false);
            this.btnDown.setIcon((Icon)new ImageIcon(QueueWindow.class.getResource("/rs/pezar/service/msg/chat/resource/img/navigate_down.png")));
            this.btnDown.setBorder((Border)new LineBorder(new Color(0, 0, 0)));
            this.pzPanel_2.add((Component)this.btnDown);
            this.btnDown.addActionListener((ActionListener)this);
            this.jScrollPane1 = new JScrollPane();
            this.getContentPane().add(this.jScrollPane1);
            this.jScrollPane1.setPreferredSize(new Dimension(629, 253));
            this.pzChatText = new PzChatTextComponent();
            this.pzChatText.setEditable(false);
            this.pzChatText.setCursor(Cursor.getPredefinedCursor(2));
            this.pzChatText.setMaximumSize(new Dimension(500, Integer.MAX_VALUE));
            this.jScrollPane1.setViewportView(this.pzChatText);
            this.pzChatText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.pzChatText.setMargin(new Insets(0, 0, 0, 0));
            this.pzPanel_1 = new PzPanel();
            this.pzPanel_1.setBackground(UIManager.getColor("InternalFrame.inactiveTitleGradient"));
            this.pzPanel_1.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
            this.pzPanel_1.setPreferredSize(new Dimension(10, 40));
            this.pzPanel_1.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
            this.getContentPane().add((Component)this.pzPanel_1);
            this.pzPanel_1.setLayout((LayoutManager)new BorderLayout(0, 0));
            this.textWrite = new JTextField();
            this.textWrite.setCaretColor(SystemColor.textText);
            this.textWrite.setAlignmentX(3.0f);
            this.textWrite.setAlignmentY(3.0f);
            this.pzPanel_1.add((Component)this.textWrite);
            this.textWrite.setPreferredSize(new Dimension(629, 44));
            this.textWrite.setBorder(new LineBorder(new Color(212, 208, 200)));
            this.textWrite.setMargin(new Insets(3, 3, 3, 3));
            this.textWrite.addKeyListener(this.l);
            this.setTitle(this.writeToUser);
            this.setPreferredSize(new Dimension(637, 311));
            this.pack();
            this.setSize(637, 311);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDefaultCloseOperation(1);
        this.textWrite.requestFocus();
    }

    public String getLocalUser() {
        return this.localUser;
    }

    public void setLocalUser(String localUser) {
        this.localUser = localUser;
    }

    public String getLocalUserQueue() {
        return this.localUserQueue;
    }

    public void setLocalUserQueue(String localUserQueue) {
        this.localUserQueue = localUserQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNewMessage(String user, String text) {
        try {
            MsgProtocol.getInstance().sendChatTextMessageToQueue(this.queueName, text);
            Object object = mutex;
            synchronized (object) {
                this.pzChatText.addText(user, text);
                this.pzChatText.scrollRectToVisible(new Rectangle(1, this.pzChatText.getHeight(), 1, 1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getWriteToUser() {
        return this.writeToUser;
    }

    public void setWriteToUser(String writeToUser) {
        this.writeToUser = writeToUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewMessage(String fromUser, String message, boolean popup) {
        String sChatSound = (String)PzApplication.getApplication().getLocalMachineUserSettings().getProperty(CHAT_SOUND_ENABLED);
        String sPopup = (String)PzApplication.getApplication().getLocalMachineUserSettings().getProperty(CHAT_POPUP_ENABLED);
        if (sChatSound == null) {
            PzApplication.getApplication().getLocalMachineUserSettings().setProperty(CHAT_SOUND_ENABLED, (Object)"true");
            sChatSound = "true";
        }
        if (sPopup == null) {
            PzApplication.getApplication().getLocalMachineUserSettings().setProperty(CHAT_POPUP_ENABLED, (Object)"true");
            sPopup = "true";
        }
        Object object = mutex;
        synchronized (object) {
            try {
                this.pzChatText.addText(fromUser, message);
                this.pzChatText.scrollRectToVisible(new Rectangle(1, this.pzChatText.getHeight(), 1, 1));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        if (sChatSound.equals("true")) {
            this.playSound();
        }
        if (popup && sPopup.equals("true")) {
            this.setVisible(true);
            this.setExtendedState(0);
        }
        this.textWrite.requestFocusInWindow();
    }

    public String getQueueName() {
        return this.queueName;
    }

    private synchronized void playSound() {
        try {
            AudioInputStream as = AudioSystem.getAudioInputStream(this.getClass().getClassLoader().getResource("rs/pezar/service/msg/chat/resource/wav/sound.wav"));
            AudioUtility.playAudioStream((AudioInputStream)as);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btnUp)) {
            this.pzChatText.increaseFontSize();
        } else if (e.getSource().equals(this.btnDown)) {
            this.pzChatText.decreaseFontSize();
        }
    }
}

