/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.msg;

import java.io.StringReader;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import rs.pezar.msg.action.ActionManager;
import rs.pezar.msg.device.DeviceManager;
import rs.pezar.msg.device.NetDataWrapper;
import rs.pezar.msg.device.cashregister.data.DeviceData;
import rs.pezar.msg.msg.MsgInfoSender;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.msg.msg.Settings;
import rs.pezar.msg.msg.control.ControlMessageDecoder;
import rs.pezar.msg.msg.control.MsgControl;
import rs.pezar.msg.msg.control.OnlineUserData;

public class MsgArbiter
implements MessageListener {
    Object mutex;
    MsgProtocol msgProtocol;
    MsgControl control;

    public MsgArbiter(Object syncMutex, MsgProtocol prot) {
        this.mutex = syncMutex;
        this.msgProtocol = prot;
        this.control = new MsgControl();
        new MsgInfoSender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        String type = null;
        String text = null;
        String fromUser = null;
        String fromDestination = null;
        Destination replyDestination = null;
        String stringData = null;
        String deviceType = null;
        String deviceId = null;
        String className = null;
        Object object = this.mutex;
        synchronized (object) {
            try {
                fromUser = message.getJMSCorrelationID();
                type = message.getJMSType();
                fromDestination = message.getStringProperty("DESTINATION");
                replyDestination = message.getJMSReplyTo();
                stringData = message.getStringProperty("DATA");
                deviceType = message.getStringProperty("DEVICETYPE");
                deviceId = message.getStringProperty("DEVICEID");
                className = message.getStringProperty("CLASSNAME");
                if (message instanceof TextMessage) {
                    text = ((TextMessage)message).getText();
                } else if (message instanceof MapMessage) {
                    text = "";
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            if (type.equals("DISCOVERY")) {
                this.invokeMsgDiscovery(replyDestination, fromDestination);
            } else if (type.equals("TEXT")) {
                this.invokeMessageReceiverDialog(type, fromUser, fromDestination, text);
            } else if (type.equals("DEVICE_DATA")) {
                this.invokeDeviceWorker(stringData, className, deviceType, deviceId, replyDestination);
            } else if (type.equals("CONTROL")) {
                this.invokeControl(fromDestination, fromUser, text);
            } else if (type.equals("ACTION")) {
                this.invokeAction(fromDestination, fromUser, text);
            }
        }
    }

    private void invokeControl(String topicName, String user, String text) {
        if (this.control == null) {
            this.control = new MsgControl();
        }
        this.control.put(topicName, user, text);
        this.control.printInfoAll();
    }

    private void invokeAction(String fromDestination, String user, String text) {
        ActionManager actionManager = (ActionManager)this.msgProtocol.getActionManager();
        HashMap<String, String> params = this.formHashMap(text);
        if (actionManager != null) {
            actionManager.runAction(params);
        }
    }

    private HashMap<String, String> formHashMap(String text) {
        HashMap<String, String> params = new HashMap<String, String>();
        String[] paramsSplit = text.split(";");
        int i = 0;
        while (i < paramsSplit.length) {
            String[] quant = paramsSplit[i].split(":");
            params.put(quant[0], quant[1]);
            ++i;
        }
        return params;
    }

    private void invokeDeviceWorker(String receivedData, String className, String deviceType, String deviceId, Destination replyTo) {
        HashMap<String, String> returnFromDevice = null;
        HashMap<String, String> returnInfo = null;
        NetDataWrapper data = new NetDataWrapper();
        data.setReplyTo(replyTo);
        DeviceData d = new DeviceData();
        d.setDeviceId(deviceId);
        d.setDeviceType(deviceType);
        d.setData(this.returnFromXmlToObject(receivedData, className));
        data.setData(d);
        if (this.msgProtocol.getDeviceManager() != null && this.msgProtocol.getDeviceManager().isSharedDevices()) {
            returnFromDevice = this.msgProtocol.getDeviceManager().pushDeviceData(data);
        }
        if (!this.msgProtocol.getDeviceManager().isSharedDevices()) {
            returnInfo = new HashMap<String, String>();
            returnInfo.put("MESSAGE", "Korisnik je zabranio mreznu upotrebu uredjaja");
            returnInfo.put("CODE", Settings.ERROR01);
            try {
                this.msgProtocol.sendReply(replyTo, returnInfo);
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            return;
        }
        if (returnFromDevice == null) {
            returnInfo = new HashMap();
            returnInfo.put("MESSAGE", "Uredjaj nije dobro podesen na radnoj stanici na koju je povezan");
            returnInfo.put("CODE", Settings.ERROR01);
            try {
                this.msgProtocol.sendReply(replyTo, returnInfo);
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    private void invokeMsgDiscovery(Destination replyDest, String option) {
        DeviceManager deviceManager = this.msgProtocol.getDeviceManager();
        try {
            OnlineUserData userData = new OnlineUserData();
            String queue = this.msgProtocol.getQueueReceptorName();
            userData.setQueue(queue);
            userData.setState(this.msgProtocol.getStatusManager().getActiveLocalState());
            userData.setCompany(this.msgProtocol.getCompany());
            userData.setRank("");
            userData.setPosition(this.msgProtocol.getPosition() == null ? "nepoznato" : this.msgProtocol.getPosition());
            ActionManager am = (ActionManager)this.msgProtocol.getActionManager();
            int i = 0;
            while (i < am.getNumerOfRegisteredActions()) {
                userData.addAction(am.getGetActionAt(i).getActionId());
                ++i;
            }
            DeviceManager devManager = this.msgProtocol.getDeviceManager();
            if (devManager != null) {
                int size = devManager.getNumerOfControledDevices();
                int i2 = 0;
                while (i2 < size) {
                    String deviceId;
                    try {
                        deviceId = deviceManager.getDeviceAt(i2).getDrvr().getDeviceId();
                    }
                    catch (Exception exception) {
                        deviceId = "NEAKTIVAN";
                    }
                    if (deviceId != null && !deviceId.equals("NEAKTIVAN")) {
                        userData.addDevice(String.valueOf(this.msgProtocol.getQueueReceptorName()) + ":" + deviceId + ":" + deviceManager.getDeviceAt(i2).getDrvr().getDeviceType() + ":" + deviceManager.getDeviceAt(i2).getDrvr().getDeviceName());
                    }
                    ++i2;
                }
            }
            String temp = ControlMessageDecoder.codeData(userData);
            this.msgProtocol.getConn().publishTextMessage(replyDest, null, "CONTROL", temp, option);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    private void invokeMessageReceiverDialog(String type, String fromUser, String fromDestination, String text) {
        if (this.msgProtocol != null && this.msgProtocol.getMessageReceiver() != null) {
            this.msgProtocol.getMessageReceiver().setNewMessageReceived(type, fromUser, fromDestination, text);
        }
    }

    public MsgControl getControl() {
        return this.control;
    }

    private Object returnFromXmlToObject(String xmlString, String className) {
        Object obj = null;
        JAXBContext jaxbContext = null;
        String cn = className.substring(className.lastIndexOf(" ") + 1);
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Class.forName(cn)});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            obj = unmarshaller.unmarshal((Source)new StreamSource(new StringReader(xmlString)));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return obj;
    }
}

