/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.msg;

import java.util.Timer;
import java.util.TimerTask;
import javax.jms.JMSException;
import rs.pezar.msg.PzExtensionLoader;
import rs.pezar.msg.action.ActionManager;
import rs.pezar.msg.device.DeviceManager;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.msg.msg.control.ControlMessageDecoder;
import rs.pezar.msg.msg.control.OnlineUserData;
import rs.pezar.msg.remote.RemoteStarter;

public class MsgInfoSender {
    public static final Integer REPETITION_DELAY = 15000;
    Timer timer;
    TimerTask infoSenderTask;
    Integer repetitionDelay = REPETITION_DELAY;

    public MsgInfoSender() {
        this.timer = new Timer();
        this.infoSenderTask = new TimerTask(){

            @Override
            public void run() {
                MsgInfoSender.this.sendInfo();
            }
        };
        this.timer.scheduleAtFixedRate(this.infoSenderTask, 0L, (long)this.repetitionDelay.intValue());
    }

    public void setRepetitionDelay(Integer repDelay) {
        this.repetitionDelay = repDelay;
    }

    public void stop() {
        this.infoSenderTask.cancel();
    }

    private void sendInfo() {
        MsgProtocol msgProtocol = PzExtensionLoader.getInstance().getMsgProtocol();
        if (msgProtocol == null) {
            return;
        }
        try {
            DeviceManager deviceManager;
            OnlineUserData userData = new OnlineUserData();
            String queue = msgProtocol.getQueueReceptorName();
            userData.setQueue(queue);
            userData.setState(msgProtocol.getStatusManager().getActiveLocalState());
            userData.setCompany(msgProtocol.getCompany());
            userData.setRank("");
            userData.setPosition(msgProtocol.getPosition() == null ? "nepoznato" : msgProtocol.getPosition());
            if (RemoteStarter.getInstance() != null) {
                try {
                    String id = RemoteStarter.getInstance().getSessionId(false);
                    userData.setRemoteId(id == null ? "" : id);
                }
                catch (InterruptedException e) {
                    userData.setRemoteId("");
                    e.printStackTrace();
                }
            } else {
                userData.setRemoteId("");
            }
            ActionManager am = (ActionManager)msgProtocol.getActionManager();
            if (am != null) {
                int i = 0;
                while (i < am.getNumerOfRegisteredActions()) {
                    userData.addAction(am.getGetActionAt(i).getActionId());
                    ++i;
                }
            }
            if ((deviceManager = msgProtocol.getDeviceManager()) != null) {
                int size = deviceManager.getNumerOfControledDevices();
                int i = 0;
                while (i < size) {
                    String deviceId;
                    try {
                        deviceId = deviceManager.getDeviceAt(i).getDrvr().getDeviceId();
                    }
                    catch (Exception exception) {
                        deviceId = "NEAKTIVAN";
                    }
                    if (deviceId != null && !deviceId.equals("NEAKTIVAN")) {
                        userData.addDevice(String.valueOf(msgProtocol.getQueueReceptorName()) + ":" + deviceId + ":" + deviceManager.getDeviceAt(i).getDrvr().getDeviceType() + ":" + deviceManager.getDeviceAt(i).getDrvr().getDeviceName());
                    }
                    ++i;
                }
            }
            String temp = ControlMessageDecoder.codeData(userData);
            msgProtocol.getConn().publishTextMessageTopic("topic.users", null, "CONTROL", temp, "topic.users");
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

