/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.remote;

import java.awt.Component;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import remote.appWrapper.core.WrapperStarterConnect;
import remote.appWrapper.implementations.ultravnc.WinVncParams;
import remote.appWrapper.implementations.ultravnc.gui.AppCloseInterface;
import remote.appWrapper.implementations.ultravnc.gui.WrapperMainWin;
import remote.appWrapper.parameterTools.interfaces.AppParameters;
import rs.pezar.core.PzApplication;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.msg.widget.panel.PnlSettings;
import rs.pezar.swing.PzPanel;

public class RemoteStarter {
    public static final String REMOTE_PASS = "MSG_REMOTE_PASS";
    public static final String REMOTE_PASS_VIEW_ONLY = "MSG_REMOTE_PASS_V";
    public static final String REMOTE_PROXY_ADDRESS = "MSG_PROXY_ADDRESS";
    public static final String REMOTE_PROXY_PORT = "MSG_PROXY_PORT";
    private WinVncParams vncParams;
    private String remotePass;
    private String remotePassViewOnly;
    private String remoteProxyAddress;
    private String remoteProxyPort;
    private WrapperMainWin mainWindow;
    private String id;
    private WrapperStarterConnect wsConnect;
    private static RemoteStarter instance;

    public RemoteStarter() throws Exception {
        instance = this;
        String workingFolder = PzApplication.getApplication().getDataFolder().getPath();
        workingFolder = String.valueOf(workingFolder) + "\\remote\\";
        workingFolder = workingFolder.replace("\\", "\\\\");
        this.remotePass = (String)PzApplication.getApplication().getLocalMachineUserSettings().getProperty(REMOTE_PASS);
        this.remotePassViewOnly = (String)PzApplication.getApplication().getLocalMachineUserSettings().getProperty(REMOTE_PASS_VIEW_ONLY);
        this.remoteProxyAddress = PzParameter.getParameterValue((String)REMOTE_PROXY_ADDRESS);
        this.remoteProxyPort = PzParameter.getParameterValue((String)REMOTE_PROXY_PORT);
        if (this.remotePass == null || this.remotePass.length() == 0) {
            PzParameter.setParameter((String)REMOTE_PASS, (String)"default");
        }
        if (this.remotePassViewOnly == null || this.remotePassViewOnly.length() == 0) {
            PzParameter.setParameter((String)REMOTE_PASS_VIEW_ONLY, (String)"defaultV");
        }
        if (this.remoteProxyAddress == null || this.remoteProxyAddress.length() == 0) {
            PzParameter.setParameter((String)REMOTE_PROXY_ADDRESS, (String)"dev.tetrabyte.rs");
        }
        if (this.remoteProxyPort == null || this.remoteProxyPort.length() == 0) {
            PzParameter.setParameter((String)REMOTE_PROXY_PORT, (String)"65123");
        }
        this.vncParams = new WinVncParams(workingFolder);
    }

    public boolean newServerConnection(AppCloseInterface appCloseAction, PzPanel parent) throws IOException {
        if (this.mainWindow != null) {
            this.mainWindow.setVisible(true);
            return false;
        }
        this.remotePass = (String)PzApplication.getApplication().getLocalMachineUserSettings().getProperty(REMOTE_PASS);
        this.remotePassViewOnly = (String)PzApplication.getApplication().getLocalMachineUserSettings().getProperty(REMOTE_PASS_VIEW_ONLY);
        this.remoteProxyAddress = PzParameter.getParameterValue((String)REMOTE_PROXY_ADDRESS);
        this.remoteProxyPort = PzParameter.getParameterValue((String)REMOTE_PROXY_PORT);
        if (this.remotePass == null || this.remotePass.length() == 0 || this.remotePass.equals("default") || this.remotePassViewOnly == null || this.remotePassViewOnly.length() == 0 || this.remotePassViewOnly.equals("defaultV")) {
            JOptionPane.showConfirmDialog((Component)parent, "Prvi put pokre\u0107ete opciju za daljinski pristup,\nmorate podesiti lozinke za pristup ovom ra\u010dunaru. \nUkoliko su lozinke ve\u0107 pode\u0161ene, morate ih promeniti.", "Prvo pokretanje", -1, 1, new ImageIcon(RemoteStarter.class.getResource("/rs/pezar/msg/widget/resource/Vnc_logo_24.png")));
            PnlSettings.showChatSettings();
            return false;
        }
        if (this.remotePass == null || this.remotePass.length() == 0) {
            this.remotePass = "default";
        }
        if (this.remotePassViewOnly == null || this.remotePassViewOnly.length() == 0) {
            this.remotePassViewOnly = "defaultV";
        }
        if (this.remoteProxyAddress == null || this.remoteProxyAddress.length() == 0) {
            this.remoteProxyAddress = "pezar.dyndns.org";
        }
        if (this.remoteProxyPort == null || this.remoteProxyPort.length() == 0) {
            this.remoteProxyPort = "65123";
        }
        this.vncParams.setPassword(this.remotePass);
        this.vncParams.setViewPassword(this.remotePassViewOnly);
        this.vncParams.setProxyAddress(this.remoteProxyAddress);
        this.vncParams.setProxyPort(Integer.valueOf(Integer.parseInt(this.remoteProxyPort)));
        this.vncParams.setParameters();
        this.mainWindow = new WrapperMainWin(this.vncParams);
        this.mainWindow.setCloseAction(appCloseAction);
        try {
            if (this.mainWindow != null) {
                this.id = this.mainWindow.getActiveId();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.mainWindow.setVisible(true);
        return true;
    }

    public synchronized String getSessionId(boolean reset) throws InterruptedException {
        if (reset) {
            this.id = null;
        }
        return this.id;
    }

    public void startClient(String remoteId) throws InterruptedException, IOException {
        this.wsConnect = new WrapperStarterConnect((AppParameters)this.vncParams, remoteId.replace(" ", ""));
    }

    public static RemoteStarter getInstance() {
        return instance;
    }

    public void disposeGarbage() {
        this.mainWindow = null;
    }
}

