/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class PzDialogGlavnaKnjiga
extends PzDialog {
    private static final String PO_DATUMU_PROMENE = "Po datumu promene";
    private static final String PO_DATUMU_NALOGA = "Po datumu naloga";
    private static final String PO_BROJU_NALOGA = "Po broju naloga";
    private static final String DETALJNO = "Detaljna";
    private static final String ZBIRNO = "Zbirna";
    private static final long serialVersionUID = 2428741436762301943L;
    private PzPanel pnlGlavni;
    private PzRadioGroup<String> panelRBs1;
    private PzDateField dfDatumOd;
    private PzTextField tfBrojNalogaOd;
    private PzTextField tfBrojNalogaDo;
    private JPanel pnlButton;
    private PzDateField dfDatumDo;
    private PzPanel pnlPolja;
    private PzRadioGroup<String> panelRBs2;
    private PzButton btnPotvrdi;
    private ScrollableCursor cursor = null;

    public PzDialogGlavnaKnjiga(JFrame frame) {
        super(frame);
        this.initGUI();
        this.setFieldValue();
        this.enabledAndFocusableBrojNaloga(true);
        this.enabledAndFocusableDatum(false);
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Glavna knjiga");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{5, 77, 6, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{10, 123, 99, 219, 20};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlGlavni.setPreferredSize(new Dimension(548, 213));
            this.panelRBs1 = new PzRadioGroup((Object[])new String[]{PO_DATUMU_PROMENE, PO_BROJU_NALOGA, PO_DATUMU_NALOGA});
            BoxLayout panelRBs1Layout = new BoxLayout((Container)this.panelRBs1, 1);
            this.panelRBs1.setLayout((LayoutManager)panelRBs1Layout);
            this.pnlGlavni.add(this.panelRBs1, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs1.setBorder((Border)BorderFactory.createTitledBorder("Parametri"));
            this.panelRBs1.setSelectedValue((Object)PO_BROJU_NALOGA);
            this.panelRBs1.setOpaque(false);
            this.panelRBs1.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getValue().equals(PzDialogGlavnaKnjiga.PO_DATUMU_NALOGA) || evt.getValue().equals(PzDialogGlavnaKnjiga.PO_DATUMU_PROMENE)) {
                        PzDialogGlavnaKnjiga.this.enabledAndFocusableDatum(true);
                        PzDialogGlavnaKnjiga.this.enabledAndFocusableBrojNaloga(false);
                    }
                    if (evt.getValue().equals(PzDialogGlavnaKnjiga.PO_BROJU_NALOGA)) {
                        PzDialogGlavnaKnjiga.this.enabledAndFocusableDatum(false);
                        PzDialogGlavnaKnjiga.this.enabledAndFocusableBrojNaloga(true);
                    }
                }
            });
            this.panelRBs2 = new PzRadioGroup((Object[])new String[]{DETALJNO, ZBIRNO});
            BoxLayout panelRBs2Layout = new BoxLayout((Container)this.panelRBs2, 1);
            this.panelRBs2.setLayout((LayoutManager)panelRBs2Layout);
            this.pnlGlavni.add(this.panelRBs2, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs2.setBorder((Border)BorderFactory.createTitledBorder("\u0160tampa"));
            this.panelRBs2.setSelectedValue((Object)DETALJNO);
            this.panelRBs2.setOpaque(false);
            this.pnlPolja = new PzPanel();
            GridBagLayout pnlPoljaLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlPolja, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlPolja.setBorder((Border)BorderFactory.createTitledBorder("Od-Do"));
            pnlPoljaLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            pnlPoljaLayout.rowHeights = new int[]{5, 26, 26, 10};
            pnlPoljaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlPoljaLayout.columnWidths = new int[]{7, 90, 14, 90, 7};
            this.pnlPolja.setLayout((LayoutManager)pnlPoljaLayout);
            this.pnlPolja.setOpaque(false);
            this.dfDatumOd = new PzDateField();
            this.pnlPolja.add((Component)this.dfDatumOd, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfDatumDo = new PzDateField();
            this.pnlPolja.add((Component)this.dfDatumDo, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfBrojNalogaOd = new PzTextField();
            this.pnlPolja.add((Component)this.tfBrojNalogaOd, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 0, 0, 0), 0, 0));
            this.tfBrojNalogaDo = new PzTextField();
            this.pnlPolja.add((Component)this.tfBrojNalogaDo, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 0, 0, 0), 0, 0));
            this.pnlButton = new JPanel();
            this.pnlGlavni.add((Component)this.pnlButton, (Object)new GridBagConstraints(0, 3, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlButton.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.pnlButton.add((Component)this.btnPotvrdi, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 25, 0, 25), 0, 0));
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(144, 36));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setResizable(false);
            this.setRestorable(false);
            this.setSize(470, 197);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        final EntityManager em = PzEntityManager.getEm();
        if (actionCommand.equals("potvrdi")) {
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogGlavnaKnjiga.this.cursor != null) {
                        PzDialogGlavnaKnjiga.this.cursor.close();
                    }
                    Query q = null;
                    String upit = ((String)PzDialogGlavnaKnjiga.this.panelRBs2.getSelectedValue()).equals(PzDialogGlavnaKnjiga.DETALJNO) ? "SELECT stavka.oznKonto, stavka.nazivKonta, stavka.analitika, stavka.nazivAnalitike, nzk.idNalog, stavka.datKnjizenja, stavka.opis, stavka.duguje, stavka.potrazuje, stavka.saldo FROM Stavkanzk stavka, Nzk nzk Where nzk.idNalog=stavka.idNalog and nzk.arhiviran = 1" : "SELECT stavka.oznKonto, stavka.nazivKonta, SUM(stavka.duguje), SUM(stavka.potrazuje), SUM(stavka.saldo) FROM Stavkanzk stavka, Nzk nzk Where nzk.idNalog=stavka.idNalog and nzk.arhiviran = 1";
                    if (((String)PzDialogGlavnaKnjiga.this.panelRBs1.getSelectedValue()).equals(PzDialogGlavnaKnjiga.PO_DATUMU_PROMENE)) {
                        upit = String.valueOf(upit) + " and stavka.datKnjizenja>=':datumOD' and stavka.datKnjizenja<=':datumDO'";
                        upit = upit.replace(":datumOD", PzDialogGlavnaKnjiga.this.dfDatumOd.getVal().toString());
                        upit = upit.replace(":datumDO", PzDialogGlavnaKnjiga.this.dfDatumDo.getVal().toString());
                    } else if (((String)PzDialogGlavnaKnjiga.this.panelRBs1.getSelectedValue()).equals(PzDialogGlavnaKnjiga.PO_DATUMU_NALOGA)) {
                        upit = String.valueOf(upit) + " and nzk.datum>=':datumOD' and nzk.datum<=':datumDO'";
                        upit = upit.replace(":datumOD", PzDialogGlavnaKnjiga.this.dfDatumOd.getVal().toString());
                        upit = upit.replace(":datumDO", PzDialogGlavnaKnjiga.this.dfDatumDo.getVal().toString());
                    } else if (((String)PzDialogGlavnaKnjiga.this.panelRBs1.getSelectedValue()).equals(PzDialogGlavnaKnjiga.PO_BROJU_NALOGA)) {
                        upit = String.valueOf(upit) + " and nzk.idNalog>=':brojOd' and nzk.idNalog<=':brojDo'";
                        upit = upit.replace(":brojOd", PzDialogGlavnaKnjiga.this.tfBrojNalogaOd.getVal().toString());
                        upit = upit.replace(":brojDo", PzDialogGlavnaKnjiga.this.tfBrojNalogaDo.getVal().toString());
                    }
                    upit = ((String)PzDialogGlavnaKnjiga.this.panelRBs2.getSelectedValue()).equals(PzDialogGlavnaKnjiga.DETALJNO) ? String.valueOf(upit) + " ORDER BY stavka.oznKonto, stavka.analitika" : String.valueOf(upit) + "GROUP BY stavka.oznKonto, stavka.nazivKonta ORDER BY stavka.oznKonto";
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogGlavnaKnjiga.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogGlavnaKnjiga.this.cursor.size());
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        if (PzDialogGlavnaKnjiga.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogGlavnaKnjiga.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogGlavnaKnjiga.this.showReport();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogGlavnaKnjiga.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReport() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "GLAVNA KNJIGA ZA " + PzDateUtility.getCurrentYear() + " GODINU";
        String subtitle = "";
        if (((String)this.panelRBs1.getSelectedValue()).equals("Po datumu")) {
            subtitle = "po datumu promene od " + this.dfDatumOd.getVal().toString() + " do " + this.dfDatumDo.getVal().toString();
        } else if (((String)this.panelRBs1.getSelectedValue()).equals(PO_DATUMU_NALOGA)) {
            subtitle = "po datumu naloga od " + this.dfDatumOd.getVal().toString() + " do " + this.dfDatumDo.getVal().toString();
        } else if (((String)this.panelRBs1.getSelectedValue()).equals(PO_BROJU_NALOGA)) {
            subtitle = "po broju naloga od " + this.tfBrojNalogaOd.getVal() + " do " + this.tfBrojNalogaDo.getVal();
        }
        String fname = "";
        fname = ((String)this.panelRBs2.getSelectedValue()).equals(DETALJNO) ? "rs/pezar/finansije/resource/reports/compiled/glavna.knjiga.jasper" : "rs/pezar/finansije/resource/reports/compiled/glavna.knjiga.zbirno.jasper";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("datum", today);
        params.put("subtitle", subtitle);
        params.put("reklama", "");
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, null);
    }

    private void enabledAndFocusableDatum(Boolean enableFocusable) {
        this.dfDatumDo.setEnabled(enableFocusable.booleanValue());
        this.dfDatumOd.setEnabled(enableFocusable.booleanValue());
        this.dfDatumDo.setFocusable(enableFocusable.booleanValue());
        this.dfDatumOd.setFocusable(enableFocusable.booleanValue());
    }

    private void enabledAndFocusableBrojNaloga(Boolean enableFocusable) {
        this.tfBrojNalogaOd.setEnabled(enableFocusable.booleanValue());
        this.tfBrojNalogaDo.setEnabled(enableFocusable.booleanValue());
        this.tfBrojNalogaDo.setFocusable(enableFocusable.booleanValue());
        this.tfBrojNalogaOd.setFocusable(enableFocusable.booleanValue());
    }

    private void setFieldValue() {
        this.dfDatumOd.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
        this.tfBrojNalogaOd.setVal((Object)"1");
        this.tfBrojNalogaDo.setVal((Object)"9999");
    }
}

