/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.izvod;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jdesktop.swingx.VerticalLayout;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.finansije.engine.izvod.IzvodBanke;
import rs.pezar.finansije.engine.izvod.IzvodDbManager;
import rs.pezar.finansije.engine.izvod.IzvodLoader;
import rs.pezar.finansije.engine.izvod.IzvodLoaderManager;
import rs.pezar.finansije.engine.izvod.IzvodManager;
import rs.pezar.finansije.engine.izvod.TransakcijaIzvodaBanke;
import rs.pezar.finansije.gui.izvod.PzPanelIzvodInfo;
import rs.pezar.finansije.gui.izvod.PzPanelTransakcija;
import rs.pezar.finansije.gui.nalogZaKnjizenje.PzDialogIzradaNaloga;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzFileUtility;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogIzvodImport
extends PzDialog {
    private static final long serialVersionUID = -6881633320550496934L;
    private PzPanel pnContent;
    private JScrollPane scp;
    private JButton btnOdustajanje;
    private JButton btnDalje;
    private JPanel pnlButtons;
    private PzPanel pnlTransakcije;
    private PzPanelIzvodInfo pnlIzvodInfo;
    private ArrayList<PzPanelTransakcija> lpt;
    private PzPanelTransakcija current;
    private EntityManager em;
    private Iterator<IzvodBanke> iterator;
    private IzvodManager izvodManager;
    private boolean postojiIzvod;
    private PzDialogIzradaNaloga parentDlg;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogIzvodImport inst = new PzDialogIzvodImport(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogIzvodImport(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogIzvodImport() {
        this.initGUI();
    }

    public PzDialogIzvodImport(PzDialog parent) {
        super(parent);
        this.parentDlg = (PzDialogIzradaNaloga)parent;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Uvoz izvoda banke");
            this.pnContent = new PzPanel();
            GridBagLayout pnContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnContent, "Center");
            pnContentLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
            pnContentLayout.rowHeights = new int[]{7, 7, 7};
            pnContentLayout.columnWeights = new double[]{0.1};
            pnContentLayout.columnWidths = new int[]{7};
            this.pnContent.setLayout((LayoutManager)pnContentLayout);
            this.pnContent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pnlIzvodInfo = new PzPanelIzvodInfo();
            this.pnContent.add((Component)this.pnlIzvodInfo, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.scp = new JScrollPane();
            this.pnContent.add((Component)this.scp, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlTransakcije = new PzPanel();
            this.pnlTransakcije.setLayout((LayoutManager)new VerticalLayout(5));
            this.scp.setViewportView((Component)this.pnlTransakcije);
            this.pnlTransakcije.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pnlButtons = new JPanel();
            FlowLayout pnlButtonsLayout = new FlowLayout();
            pnlButtonsLayout.setAlignment(2);
            pnlButtonsLayout.setVgap(2);
            pnlButtonsLayout.setHgap(2);
            this.pnlButtons.setLayout(pnlButtonsLayout);
            this.pnContent.add((Component)this.pnlButtons, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOdustajanje = new JButton();
            this.pnlButtons.add(this.btnOdustajanje);
            this.btnOdustajanje.setText("Odustajanje");
            this.btnOdustajanje.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/forbidden.png")));
            this.btnOdustajanje.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogIzvodImport.this.dispose();
                }
            });
            this.btnDalje = new JButton();
            this.pnlButtons.add(this.btnDalje);
            this.btnDalje.setText("Dalje          ");
            this.btnDalje.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/nav_right_green.png")));
            this.btnDalje.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogIzvodImport.this.btnDaljeActionPerformed(evt);
                }
            });
            this.setSize(800, 600);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean shouldBeShown() {
        List<IzvodBanke> izvodi;
        block7: {
            List<IzvodLoader> ils = IzvodLoaderManager.getIzvodLoaderList();
            PzChoice[] choices = new PzChoice[ils.size()];
            int i = 0;
            while (i < ils.size()) {
                choices[i] = new PzChoice(ils.get(i).toString(), (Object)ils.get(i));
                ++i;
            }
            IzvodLoader il = (IzvodLoader)PzDialogChoice.showPzDialogChoice((PzDialog)this, (PzChoice[])choices, (String)"Izaberite format izvoda koji se uvezuje");
            if (il == null) {
                return false;
            }
            File f = PzFileUtility.selectFile((String[])new String[]{"xml"}, (String)"Izaberite fajl u kome se nalazi izvod banke", (PzDialog)this, (int)0);
            if (f == null) {
                return false;
            }
            try {
                izvodi = il.loadIzvodList(f);
                if (izvodi.size() != 0) break block7;
                return false;
            }
            catch (Exception e1) {
                if (e1.getCause() != null) {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1.getCause());
                }
                return false;
            }
        }
        this.iterator = izvodi.iterator();
        return this.sledeciIzvod();
    }

    private boolean sledeciIzvod() {
        IzvodBanke izvod = null;
        while (this.iterator.hasNext() && (izvod = this.iterator.next()).getTransakcije().size() == 0) {
        }
        if (izvod == null) {
            if (!this.postojiIzvod) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ni jedan od izvoda u selektovanom fajlu ne sadr\u017ei transakcije. Uvoz nemogu\u0107!");
            }
            return false;
        }
        this.postojiIzvod = true;
        this.izvodManager = new IzvodManager(izvod);
        this.pnlIzvodInfo.setIzvod(this.izvodManager);
        this.izvodManager.setDlg(this);
        this.izvodManager.setPnlIzvodInfo(this.pnlIzvodInfo);
        PzWorkerDialog.showStatus((String)"Uvoz izvoda u toku. Ova operacija mo\u017ee da potraje, molim sa\u010dekajte.", (PzDialog)this);
        PzWorkerDialog.getDialogInstance().getProgressBar().setIndeterminate(false);
        PzWorkerDialog.getDialogInstance().setProgresSize(0, izvod.getTransakcije().size());
        this.loadTransakcije(izvod.getTransakcije());
        return true;
    }

    private void loadTransakcije(final List<TransakcijaIzvodaBanke> lt) {
        this.pnlTransakcije.removeAll();
        this.pnlTransakcije.setVisible(false);
        SwingWorker<List<PzPanelTransakcija>, Integer> worker = new SwingWorker<List<PzPanelTransakcija>, Integer>(){

            @Override
            protected List<PzPanelTransakcija> doInBackground() throws Exception {
                PzDialogIzvodImport.this.em = PzEntityManagerFactory.getInstance().createEm();
                PzDialogIzvodImport.this.lpt = new ArrayList();
                PzDialogIzvodImport.this.lpt = new ArrayList();
                for (TransakcijaIzvodaBanke t : lt) {
                    if (IzvodDbManager.postojiTransakcija(t.getIdTransakcijeFormatiran(), PzDialogIzvodImport.this.em)) {
                        IzvodDbManager.srediTransakciju(t, PzDialogIzvodImport.this.em);
                    }
                    if (t.getIznos().compareTo(new BigDecimal("0.00")) == 0) continue;
                    PzPanelTransakcija pt = new PzPanelTransakcija(PzDialogIzvodImport.this.izvodManager);
                    pt.setTransakcija(t, PzDialogIzvodImport.this.em);
                    PzDialogIzvodImport.this.lpt.add(pt);
                    this.publish(1);
                }
                PzDialogIzvodImport.this.em.close();
                return PzDialogIzvodImport.this.lpt;
            }

            @Override
            protected void process(List<Integer> chunks) {
                PzWorkerDialog.getDialogInstance().incProgress(chunks.size());
            }

            @Override
            protected void done() {
                try {
                    try {
                        List lpt = (List)this.get();
                        if (lpt.size() == 0) {
                            PzSwingUtility.showErrorMessage((Component)((Object)PzDialogIzvodImport.this), (String)"Izvod ne sadr\u017ei ni jednu transakciju, ili su sve transakcije ve\u0107 uvezene.");
                            PzDialogIzvodImport.this.dispose();
                        }
                        for (PzPanelTransakcija pt : lpt) {
                            PzDialogIzvodImport.this.pnlTransakcije.add((Component)((Object)pt));
                        }
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogIzvodImport.this), (Throwable)e);
                        PzDialogIzvodImport.this.pnlTransakcije.setVisible(true);
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    PzDialogIzvodImport.this.pnlTransakcije.setVisible(true);
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            Komitent k = (Komitent)entity;
            if (!(this.current == null || this.current.getKomitent() != null && this.current.getKomitent().getSfrKomitent().equals(k.getSfrKomitent()))) {
                boolean ok = this.current.setKomitentAndCheck(k);
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                if (ok) {
                    this.current.setUplate(em, false, true);
                    this.izvodManager.setKomitentByBrRacuna(this.current.getTransakcijaIzvodaBanke(), k, em);
                }
                em.close();
            }
        }
    }

    public PzPanelTransakcija getCurrent() {
        return this.current;
    }

    public void setCurrent(PzPanelTransakcija current) {
        this.current = current;
    }

    private void btnDaljeActionPerformed(ActionEvent evt) {
        block7: {
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            try {
                try {
                    em.getTransaction().begin();
                    for (PzPanelTransakcija pnl : this.lpt) {
                        Tekuciracun tr;
                        if (pnl.getKomitent() == null || (tr = pnl.getTekuciRacun(em)) == null || tr.getKomitent() != null) continue;
                        tr.setKomitent(pnl.getKomitent());
                        em.merge((Object)tr);
                    }
                    em.getTransaction().commit();
                }
                catch (Exception exception) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                em.close();
                throw throwable;
            }
            em.close();
        }
        this.izvodManager.knjiziIzvod((Nzk)this.getSession().getParameter("nzk"));
    }

    public void dalje() {
        boolean jos = this.sledeciIzvod();
        if (!jos) {
            this.dispose();
            this.parentDlg.getTableStavke().refreshData();
        }
    }
}

