/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.nalogZaKnjizenje.akcije;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.db.entity.Uplata;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzComponentFactory;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzDialogAkcija;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.custom.PzDialogMaloprodajaPorezIznos;
import rs.pezar.swing.custom.PzTablePorez;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PovracajAvansaOdDobavljaca
extends PzDialogAkcija {
    private static final long serialVersionUID = -610221729743683725L;
    private final PzPanel contentPanel = new PzPanel();
    private PzPanelHeader pnlHeader;
    private PzPanel pnlForm;
    private JLabel lblifraDobavljaa;
    private JLabel lblDatumKnjienja;
    private JLabel lblDatumUplate;
    private PzDoubleField dfOslobidjen;
    private PzDoubleField dfNijeObveznik;
    private JLabel lblNijeObveznik;
    private JLabel lblOslobidjen;
    private PzPanel pnlPromet;
    private PzPanel pnlPovracaj;
    private JLabel lblRaspoloivAvans;
    private PzDoubleField dblRaspolozivAvans;
    private JScrollPane scpPromet;
    private PzTablePorez tblPorezPromet;
    private JLabel lblIznosPovraaja;
    private PzDoubleField dblIznosPovracaja;
    private PzRadioGroup<PzChoice> rgrSaBezPdvPravom;
    private PzDoubleField dfBezPrava;
    private JLabel lblBezPrava;
    private JScrollPane scpPovracaj;
    private PzNumericOnlyTextField numSifraDobavljaca;
    private PzDateField datDatumKnjizenja;
    private PzDateField datDatumUplate;
    private PzTextField txtNazivDobavljaca;
    private PzTablePorez tblPorezPovracaj;
    private Komitent komitent;
    private Uplata uplata;

    public static void main(String[] args) {
        try {
            PovracajAvansaOdDobavljaca dialog = new PovracajAvansaOdDobavljaca();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PovracajAvansaOdDobavljaca() {
        this.initGUI();
    }

    public PovracajAvansaOdDobavljaca(PzDialog parent) {
        super(parent);
        this.initGUI();
    }

    private void initGUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout((LayoutManager)new BorderLayout());
        this.contentPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        this.contentPanel.setPaintGradient(true);
        this.contentPanel.setGradient(Color.WHITE, PzComponentFactory.COLOR_BLUE_LIGHT, PzPanel.GRADIENT_WEST_EAST);
        this.getContentPane().add((Component)this.contentPanel, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setLayout(new FlowLayout(1));
        this.contentPanel.add((Component)buttonPane, (Object)"South");
        JButton okButton = new JButton("OK");
        okButton.setIcon(new ImageIcon(PovracajAvansaOdDobavljaca.class.getResource("/rs/pezar/finansije/resource/img/check.png")));
        okButton.addActionListener((ActionListener)((Object)this));
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.pnlHeader = new PzPanelHeader();
        this.pnlHeader.setOpaque(false);
        this.pnlHeader.setTitle("Knji\u017eenje povra\u0107aja avansa od dobavlja\u010da");
        this.contentPanel.add((Component)this.pnlHeader, (Object)"North");
        this.pnlForm = new PzPanel();
        GridBagLayout gbl_pnlForm = new GridBagLayout();
        this.pnlForm.setOpaque(false);
        this.contentPanel.add((Component)this.pnlForm, (Object)"Center");
        int[] nArray = new int[7];
        nArray[0] = 154;
        nArray[1] = 155;
        nArray[2] = 142;
        nArray[3] = 206;
        nArray[4] = 20;
        nArray[5] = 171;
        gbl_pnlForm.columnWidths = nArray;
        int[] nArray2 = new int[8];
        nArray2[4] = 20;
        nArray2[5] = 20;
        nArray2[6] = 20;
        gbl_pnlForm.rowHeights = nArray2;
        gbl_pnlForm.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
        gbl_pnlForm.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.pnlForm.setLayout((LayoutManager)gbl_pnlForm);
        this.lblDatumKnjienja = new JLabel("Datum knji\u017eenja:");
        GridBagConstraints gbc_lblDatumKnjienja = new GridBagConstraints();
        gbc_lblDatumKnjienja.anchor = 13;
        gbc_lblDatumKnjienja.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumKnjienja.gridx = 0;
        gbc_lblDatumKnjienja.gridy = 0;
        this.pnlForm.add((Component)this.lblDatumKnjienja, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 5, 5), 0, 0));
        this.datDatumKnjizenja = new PzDateField();
        GridBagConstraints gbc_datDatumKnjizenja = new GridBagConstraints();
        gbc_datDatumKnjizenja.insets = new Insets(0, 0, 5, 5);
        gbc_datDatumKnjizenja.fill = 2;
        gbc_datDatumKnjizenja.gridx = 1;
        gbc_datDatumKnjizenja.gridy = 0;
        this.pnlForm.add((Component)this.datDatumKnjizenja, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.lblDatumUplate = new JLabel("Datum uplate:");
        GridBagConstraints gbc_lblDatumUplate = new GridBagConstraints();
        gbc_lblDatumUplate.anchor = 13;
        gbc_lblDatumUplate.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumUplate.gridx = 0;
        gbc_lblDatumUplate.gridy = 1;
        this.pnlForm.add((Component)this.lblDatumUplate, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 5, 5), 0, 0));
        this.datDatumUplate = new PzDateField();
        GridBagConstraints gbc_datDatumUplate = new GridBagConstraints();
        gbc_datDatumUplate.insets = new Insets(0, 0, 5, 5);
        gbc_datDatumUplate.fill = 2;
        gbc_datDatumUplate.gridx = 1;
        gbc_datDatumUplate.gridy = 1;
        this.pnlForm.add((Component)this.datDatumUplate, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.lblifraDobavljaa = new JLabel("\u0160ifra dobavlja\u010da:");
        GridBagConstraints gbc_lblifraDobavljaa = new GridBagConstraints();
        gbc_lblifraDobavljaa.anchor = 13;
        gbc_lblifraDobavljaa.insets = new Insets(0, 0, 5, 5);
        gbc_lblifraDobavljaa.gridx = 0;
        gbc_lblifraDobavljaa.gridy = 2;
        this.pnlForm.add((Component)this.lblifraDobavljaa, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 5, 5), 0, 0));
        this.numSifraDobavljaca = PzComponentFactory.createKomitentField();
        GridBagConstraints gbc_numSifraDobavljaca = new GridBagConstraints();
        gbc_numSifraDobavljaca.insets = new Insets(0, 0, 5, 5);
        gbc_numSifraDobavljaca.fill = 2;
        gbc_numSifraDobavljaca.gridx = 1;
        gbc_numSifraDobavljaca.gridy = 2;
        this.pnlForm.add((Component)this.numSifraDobavljaca, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.lblNijeObveznik = new JLabel();
        this.pnlForm.add((Component)this.lblNijeObveznik, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 5, 0), 0, 0));
        this.lblNijeObveznik.setText("Nije obveznik:");
        this.dfNijeObveznik = new PzDoubleField();
        this.pnlForm.add((Component)this.dfNijeObveznik, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.dfNijeObveznik.setBackground(new Color(173, 216, 230));
        this.dfNijeObveznik.setFocusable(false);
        this.dfNijeObveznik.setEditable(false);
        this.lblBezPrava = new JLabel();
        this.pnlForm.add((Component)this.lblBezPrava, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 5, 0), 0, 0));
        this.lblBezPrava.setText("Raspolo\u017eivi avans bez prava:");
        this.dfBezPrava = new PzDoubleField();
        this.pnlForm.add((Component)this.dfBezPrava, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.dfBezPrava.setBackground(new Color(173, 216, 230));
        this.dfBezPrava.setFocusable(false);
        this.dfBezPrava.setEditable(false);
        this.lblOslobidjen = new JLabel();
        this.pnlForm.add((Component)this.lblOslobidjen, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 5, 0), 0, 0));
        this.lblOslobidjen.setText("Raspolo\u017eivi avans oslobo\u0111en:");
        this.dfOslobidjen = new PzDoubleField();
        this.pnlForm.add((Component)this.dfOslobidjen, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.dfOslobidjen.setBackground(new Color(173, 216, 230));
        this.dfOslobidjen.setFocusable(false);
        this.dfOslobidjen.setEditable(false);
        this.txtNazivDobavljaca = new PzTextField();
        this.txtNazivDobavljaca.setOpaque(false);
        this.txtNazivDobavljaca.setFocusable(false);
        this.txtNazivDobavljaca.setEditable(false);
        GridBagConstraints gbc_txtNazivDobavljaca = new GridBagConstraints();
        gbc_txtNazivDobavljaca.fill = 2;
        gbc_txtNazivDobavljaca.gridwidth = 2;
        gbc_txtNazivDobavljaca.insets = new Insets(0, 0, 5, 5);
        gbc_txtNazivDobavljaca.gridx = 2;
        gbc_txtNazivDobavljaca.gridy = 2;
        this.pnlForm.add((Component)this.txtNazivDobavljaca, (Object)new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.pnlPromet = new PzPanel();
        GridBagLayout gbl_pnlPromet = new GridBagLayout();
        this.pnlPromet.setOpaque(false);
        this.pnlPromet.setBorder((Border)new TitledBorder(null, "Izvod iz prometa", 4, 2, null, null));
        GridBagConstraints gbc_pnlPromet = new GridBagConstraints();
        gbc_pnlPromet.gridwidth = 3;
        gbc_pnlPromet.insets = new Insets(0, 0, 0, 5);
        gbc_pnlPromet.fill = 1;
        gbc_pnlPromet.gridx = 0;
        gbc_pnlPromet.gridy = 3;
        this.pnlForm.add((Component)this.pnlPromet, (Object)new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        int[] nArray3 = new int[4];
        nArray3[0] = 146;
        nArray3[1] = 155;
        nArray3[2] = 128;
        gbl_pnlPromet.columnWidths = nArray3;
        gbl_pnlPromet.rowHeights = new int[3];
        gbl_pnlPromet.columnWeights = new double[]{0.0, 0.0, 0.1, Double.MIN_VALUE};
        gbl_pnlPromet.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.pnlPromet.setLayout((LayoutManager)gbl_pnlPromet);
        this.lblRaspoloivAvans = new JLabel("Raspolo\u017eiv avans za PDV-om:");
        GridBagConstraints gbc_lblRaspoloivAvans = new GridBagConstraints();
        gbc_lblRaspoloivAvans.anchor = 17;
        gbc_lblRaspoloivAvans.insets = new Insets(0, 0, 5, 5);
        gbc_lblRaspoloivAvans.gridx = 0;
        gbc_lblRaspoloivAvans.gridy = 0;
        this.pnlPromet.add((Component)this.lblRaspoloivAvans, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.dblRaspolozivAvans = new PzDoubleField();
        this.dblRaspolozivAvans.setBackground(new Color(173, 216, 230));
        this.dblRaspolozivAvans.setFocusable(false);
        this.dblRaspolozivAvans.setEditable(false);
        GridBagConstraints gbc_dblRaspolozivAvans = new GridBagConstraints();
        gbc_dblRaspolozivAvans.insets = new Insets(0, 0, 5, 5);
        gbc_dblRaspolozivAvans.fill = 2;
        gbc_dblRaspolozivAvans.gridx = 1;
        gbc_dblRaspolozivAvans.gridy = 0;
        this.pnlPromet.add((Component)this.dblRaspolozivAvans, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.scpPromet = new JScrollPane();
        GridBagConstraints gbc_scpPromet = new GridBagConstraints();
        gbc_scpPromet.gridwidth = 3;
        gbc_scpPromet.insets = new Insets(0, 0, 0, 5);
        gbc_scpPromet.fill = 1;
        gbc_scpPromet.gridx = 0;
        gbc_scpPromet.gridy = 1;
        this.pnlPromet.add((Component)this.scpPromet, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tblPorezPromet = PzComponentFactory.createPzTablePorez();
        this.tblPorezPromet.setEnabled(false);
        this.tblPorezPromet.setId("TABLE_PROMET");
        this.tblPorezPromet.setAutoResizeMode(4);
        this.scpPromet.setViewportView((Component)this.tblPorezPromet);
        this.pnlPovracaj = new PzPanel();
        GridBagLayout gbl_pnlPovracaj = new GridBagLayout();
        this.pnlPovracaj.setOpaque(false);
        this.pnlPovracaj.setBorder((Border)new TitledBorder(null, "Elementi povra\u0107aja", 4, 2, null, null));
        GridBagConstraints gbc_pnlPovracaj = new GridBagConstraints();
        gbc_pnlPovracaj.gridwidth = 2;
        gbc_pnlPovracaj.fill = 1;
        gbc_pnlPovracaj.gridx = 3;
        gbc_pnlPovracaj.gridy = 3;
        this.pnlForm.add((Component)this.pnlPovracaj, (Object)new GridBagConstraints(3, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        int[] nArray4 = new int[4];
        nArray4[0] = 125;
        nArray4[1] = 130;
        nArray4[2] = 105;
        gbl_pnlPovracaj.columnWidths = nArray4;
        int[] nArray5 = new int[4];
        nArray5[0] = 20;
        gbl_pnlPovracaj.rowHeights = nArray5;
        gbl_pnlPovracaj.columnWeights = new double[]{0.0, 0.0, 0.1, Double.MIN_VALUE};
        gbl_pnlPovracaj.rowWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.pnlPovracaj.setLayout((LayoutManager)gbl_pnlPovracaj);
        this.lblIznosPovraaja = new JLabel("Iznos povra\u0107aja:");
        GridBagConstraints gbc_lblIznosPovraaja = new GridBagConstraints();
        gbc_lblIznosPovraaja.insets = new Insets(0, 0, 5, 5);
        gbc_lblIznosPovraaja.anchor = 17;
        gbc_lblIznosPovraaja.gridx = 0;
        gbc_lblIznosPovraaja.gridy = 0;
        this.pnlPovracaj.add((Component)this.lblIznosPovraaja, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.scpPovracaj = new JScrollPane();
        GridBagConstraints gbc_scpPovracaj = new GridBagConstraints();
        gbc_scpPovracaj.gridwidth = 3;
        gbc_scpPovracaj.insets = new Insets(0, 0, 0, 5);
        gbc_scpPovracaj.fill = 1;
        gbc_scpPovracaj.gridx = 0;
        gbc_scpPovracaj.gridy = 1;
        this.pnlPovracaj.add((Component)this.scpPovracaj, (Object)new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.tblPorezPovracaj = PzComponentFactory.createPzTablePorez();
        this.tblPorezPovracaj.setDialogClass(PzDialogMaloprodajaPorezIznos.class);
        this.tblPorezPovracaj.setId("TABLE_POVRACAJ");
        this.tblPorezPovracaj.setAutoResizeMode(4);
        this.scpPovracaj.setViewportView((Component)this.tblPorezPovracaj);
        this.dblIznosPovracaja = this.tblPorezPovracaj.createExpresionField("$2$+$3$");
        GridBagConstraints gbc_dblIznosPovracaja = new GridBagConstraints();
        gbc_dblIznosPovracaja.fill = 2;
        gbc_dblIznosPovracaja.insets = new Insets(0, 0, 5, 5);
        gbc_dblIznosPovracaja.gridx = 1;
        gbc_dblIznosPovracaja.gridy = 0;
        this.pnlPovracaj.add((Component)this.dblIznosPovracaja, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.dblIznosPovracaja.setBackground(new Color(173, 216, 230));
        this.dblIznosPovracaja.setFocusable(false);
        this.dblIznosPovracaja.setEditable(false);
        this.rgrSaBezPdvPravom = PzComponentFactory.createRadioGroup();
        this.pnlPovracaj.add(this.rgrSaBezPdvPravom, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.rgrSaBezPdvPravom.addRadioGroupListener(new PzRadioGroupListener(){

            public void selectionChanged(PzRadioGroupEvent evt) {
                PovracajAvansaOdDobavljaca.this.selectionChangedrgrPdvSaBez(evt);
            }
        });
        this.pack();
        this.setSize(897, 650);
        this.setMinimumSize(new Dimension(897, 650));
        Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
    }

    public void setEntity(PzEntity entity, Component component) {
        try {
            if (entity instanceof Komitent) {
                this.komitent = (Komitent)entity;
                if (this.komitent.getDomaciKomitent() == 0 || this.komitent.getObveznikPDV() == 0) {
                    this.tblPorezPovracaj.setEnabled(false);
                    this.rgrSaBezPdvPravom.setEnabled(false);
                    this.dblIznosPovracaja.setEnabled(true);
                    this.dblIznosPovracaja.setEditable(true);
                    this.dblIznosPovracaja.setFocusable(true);
                }
                this.numSifraDobavljaca.setVal((Object)this.komitent.getSfrKomitent());
                this.txtNazivDobavljaca.setVal((Object)this.komitent.getNaziv());
                this.dblRaspolozivAvans.setVal((Object)this.getRaspolozivAvans().subtract(this.getPovracaj()).subtract(this.getZatvaranjeAvansom()));
                this.tblPorezPromet.setPorezi(this.getPorezi(), true);
                this.setElementiAvansa();
                this.tblPorezPromet.packAll();
                this.tblPorezPovracaj.packAll();
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void selectionChangedrgrPdvSaBez(PzRadioGroupEvent evt) {
        if (evt.getStateChange() == 1) {
            if (!((PzChoice)evt.getValue()).getValue().equals("OSLOBODJENO")) {
                this.tblPorezPovracaj.setEnabled(true);
                this.dblIznosPovracaja.setFocusable(false);
                this.dblIznosPovracaja.setEditable(false);
                this.dblIznosPovracaja.setEnabled(false);
                this.dblIznosPovracaja.setVal((Object)0.0);
            } else {
                this.dblIznosPovracaja.setFocusable(true);
                this.dblIznosPovracaja.setEditable(true);
                this.dblIznosPovracaja.setEnabled(true);
                this.dblIznosPovracaja.setVal((Object)0.0);
                this.tblPorezPovracaj.setEnabled(false);
            }
        }
    }

    private void setElementiAvansa() {
        try {
            Vector uplate = null;
            Vector isplate = null;
            BigDecimal saPravom = new BigDecimal(0);
            BigDecimal bezPrava = new BigDecimal(0);
            BigDecimal nijeObveznik = new BigDecimal(0);
            uplate = PzEntityManager.select((String)("SELECT u FROM Uplata u WHERE u.tip='" + TipDokumentConfig.get().UPLATA_DAT_AVANS + "' " + "AND u.arhiviran != -1 and u.komitent.sfrKomitent=" + this.komitent.getSfrKomitent()));
            isplate = PzEntityManager.select((String)("SELECT u FROM Uplata u WHERE (u.tip='" + TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ + "' OR u.tip='" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "') and u.arhiviran != -1 AND u.komitent.sfrKomitent=" + this.komitent.getSfrKomitent()));
            int i = 0;
            while (i < uplate.size()) {
                if (((Uplata)uplate.get(i)).getPorez().equals("BEZ_PRAVA")) {
                    bezPrava = bezPrava.add(((Uplata)uplate.get(i)).getIznos());
                } else if (((Uplata)uplate.get(i)).getPorez().equals("OSLOBODJENO")) {
                    saPravom = saPravom.add(((Uplata)uplate.get(i)).getIznos());
                } else if (((Uplata)uplate.get(i)).getPorez().equals("NIJE_OBVEZNIK")) {
                    nijeObveznik = nijeObveznik.add(((Uplata)uplate.get(i)).getIznos());
                }
                ++i;
            }
            i = 0;
            while (i < isplate.size()) {
                if (((Uplata)isplate.get(i)).getPorez().equals("BEZ_PRAVA")) {
                    bezPrava = bezPrava.subtract(((Uplata)isplate.get(i)).getIznos());
                } else if (((Uplata)isplate.get(i)).getPorez().equals("OSLOBODJENO")) {
                    saPravom = saPravom.subtract(((Uplata)isplate.get(i)).getIznos());
                } else if (((Uplata)isplate.get(i)).getPorez().equals("NIJE_OBVEZNIK")) {
                    nijeObveznik = nijeObveznik.subtract(((Uplata)isplate.get(i)).getIznos());
                }
                ++i;
            }
            this.dfBezPrava.setVal((Object)bezPrava);
            this.dfOslobidjen.setVal((Object)saPravom);
            this.dfNijeObveznik.setVal((Object)nijeObveznik);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private BigDecimal getRaspolozivAvans() throws Exception {
        BigDecimal val = (BigDecimal)this.getEm().createQuery("SELECT SUM(a.iznosSaPorezom - a.pokriveno) FROM Uplata a WHERE a.arhiviran != -1 and a.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS + "' and  a.porez!='" + "OSLOBODJENO" + "' AND a.komitent.sfrKomitent=" + this.komitent.getSfrKomitent()).getSingleResult();
        if (val == null) {
            val = new BigDecimal(0);
        }
        return val;
    }

    private BigDecimal getPovracaj() throws Exception {
        BigDecimal val = (BigDecimal)this.getEm().createQuery("SELECT SUM(a.iznosSaPorezom) FROM Uplata a WHERE a.arhiviran != -1 and a.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ + "' and  a.porez!='" + "OSLOBODJENO" + "' AND a.komitent.sfrKomitent=" + this.komitent.getSfrKomitent()).getSingleResult();
        if (val == null) {
            val = new BigDecimal(0);
        }
        return val;
    }

    private BigDecimal getZatvaranjeAvansom() throws Exception {
        BigDecimal val = (BigDecimal)this.getEm().createQuery("SELECT SUM(a.iznosSaPorezom) FROM Uplata a WHERE a.arhiviran != -1 and a.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "' and  a.porez!='" + "OSLOBODJENO" + "' AND a.komitent.sfrKomitent=" + this.komitent.getSfrKomitent()).getSingleResult();
        if (val == null) {
            val = new BigDecimal(0);
        }
        return val;
    }

    private List<? extends PzTaksaDokument> getPorezi() throws Exception {
        Vector takse1 = PzEntityManager.select((String)("SELECT t FROM Taksaopstidokument t WHERE (t.uplata.tip='" + TipDokumentConfig.get().UPLATA_DAT_AVANS + "' OR t.uplata.tip='" + TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ + "' OR t.uplata.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "') " + "AND t.uplata.arhiviran != -1 and t.uplata.komitent.sfrKomitent=" + this.komitent.getSfrKomitent() + " AND t.uplata.porez!='" + "OSLOBODJENO" + "'"));
        for (PzEntity entity : takse1) {
            Taksaopstidokument taksa = (Taksaopstidokument)entity;
            if (!taksa.getUplata().getTip().equals(TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ) && !taksa.getUplata().getTip().equals(TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC)) continue;
            taksa.setIznos(taksa.getIznos().negate());
            taksa.setOsnovica(taksa.getOsnovica().negate());
        }
        return takse1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.pnlForm.validateForm(true)) {
            return;
        }
        this.commit();
    }

    @Override
    public Date getDatKnjizenja() {
        return this.datDatumKnjizenja.getVal();
    }

    @Override
    public PzDokument getNewDokument() throws Exception {
        this.uplata = new Uplata();
        this.uplata.setDatum(this.datDatumUplate.getVal());
        this.uplata.setIznos(this.dblIznosPovracaja.getBigDecimal());
        this.uplata.setKomitent(this.komitent);
        System.out.println(((PzChoice)this.rgrSaBezPdvPravom.getSelectedValue()).getValue());
        if (this.uplata.getKomitent().getDomaciKomitent() == 0) {
            this.uplata.setPorez("INO");
        } else if (this.uplata.getKomitent().getObveznikPDV() == 0) {
            this.uplata.setPorez("NIJE_OBVEZNIK");
        } else {
            this.uplata.setPorez((String)((PzChoice)this.rgrSaBezPdvPravom.getSelectedValue()).getValue());
        }
        this.uplata.setTaksaopstidokuments(this.tblPorezPovracaj.getPorezi());
        this.uplata.setTip(TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ);
        return this.uplata;
    }

    @Override
    public void commit() {
        List poreziLevo = this.tblPorezPromet.getPorezi();
        List poreziDesno = this.tblPorezPovracaj.getPorezi();
        if (this.dblIznosPovracaja.getVal() == 0.0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Nije definisan iznos povra\u0107aja. Ne mo\u017eete nastaviti dalje.");
            return;
        }
        if (((PzChoice)this.rgrSaBezPdvPravom.getSelectedValue()).getValue().toString().equals("SA_PRAVOM")) {
            for (Taksaopstidokument porezLevo : poreziLevo) {
                for (Taksaopstidokument porezDesno : poreziDesno) {
                    if (!porezLevo.getId().getOznTarGr().equals(porezDesno.getId().getOznTarGr()) || porezDesno.getIznos().compareTo(porezLevo.getIznos()) <= 0) continue;
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)("Uneseni iznos PDV-a po tarifi " + porezLevo.getId().getOznTarGr() + " je ve\u0107i od iznosa po istoj tarifi sa izabranog avansnog racuna. Unos prekinut!"));
                    return;
                }
            }
        } else if (((PzChoice)this.rgrSaBezPdvPravom.getSelectedValue()).getValue().toString().equals("BEZ_PRAVA")) {
            if (this.dfBezPrava.getVal() < this.dblIznosPovracaja.getVal()) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Iznos povra\u0107aja je ve\u0107i od raspolo\u017eivog avansa bez prava. Ne mo\u017eete nastaviti dalje.");
                return;
            }
        } else if (((PzChoice)this.rgrSaBezPdvPravom.getSelectedValue()).getValue().toString().equals("OSLOBODJENO")) {
            if (this.dfOslobidjen.getVal() < this.dblIznosPovracaja.getVal()) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Iznos povra\u0107aja je ve\u0107i od raspolo\u017eivog avansa oslobo\u0111enog PDV-a. Ne mo\u017eete nastaviti dalje.");
                return;
            }
        } else if (this.dblRaspolozivAvans.getVal() < this.dblIznosPovracaja.getVal()) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Iznos povra\u0107aja je ve\u0107i od raspolo\u017eivog avansa. Ne mo\u017eete nastaviti dalje.");
            return;
        }
        super.commit();
    }
}

