/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.util;

import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzDialogAkcija;

public class TableModelAkcije
extends AbstractTableModel {
    private static final long serialVersionUID = -71610888560515148L;
    private Document dok;
    private String[] columns = new String[]{"\u0160ifra", "Naziv knji\u017eenja"};

    public TableModelAkcije(Document dok) {
        this.dok = dok;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int arg0) {
        return this.columns[arg0];
    }

    @Override
    public int getRowCount() {
        return this.dok.getDocumentElement().getElementsByTagName("akcija").getLength();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Element el = (Element)this.dok.getDocumentElement().getElementsByTagName("akcija").item(row);
        if (column == 0) {
            return el.getAttribute("sfr");
        }
        if (column == 1) {
            return el.getAttribute("naziv");
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class<PzDialogAkcija> getActionClass(int row) throws ClassNotFoundException {
        Element el = (Element)this.dok.getDocumentElement().getElementsByTagName("akcija").item(row);
        return Class.forName(el.getAttribute("class"), false, this.getClass().getClassLoader());
    }

    public int getSfr(int row) throws ClassNotFoundException {
        Element el = (Element)this.dok.getDocumentElement().getElementsByTagName("akcija").item(row);
        return Integer.parseInt(el.getAttribute("sfr"));
    }

    public Class<PzDialogAkcija> getClassBySfr(int sfr) throws ClassNotFoundException {
        NodeList nl = this.dok.getDocumentElement().getElementsByTagName("akcija");
        String className = null;
        int i = 0;
        while (i < nl.getLength()) {
            Element el = (Element)nl.item(i);
            if (Integer.parseInt(el.getAttribute("sfr")) == sfr) {
                className = el.getAttribute("class");
            }
            ++i;
        }
        if (className == null) {
            return null;
        }
        return Class.forName(className, false, this.getClass().getClassLoader());
    }
}

