/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.konsignacije.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalkonsignacija;
import rs.pezar.db.entity.Brojacrj;
import rs.pezar.db.entity.Konsignacija;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.konsignacije.gui.PzDialogDokumentiPovratnicaMaloprodaja;
import rs.pezar.konsignacije.gui.povratnicaMaloprodaja.Arhiviranje;
import rs.pezar.konsignacije.gui.povratnicaMaloprodaja.Dodavanje;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.util.PzMathUtility;

public class PzDialogPovratnicaMaloprodaja
extends PzDialogInsert {
    private PzPanel pzPanelN;
    private JScrollPane jScrollPane;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnIzmena;
    private PzDoubleField vrednostSaPorezom;
    private JLabel jLabel2;
    private PzDoubleField vrednostBezPoreza;
    private JLabel jLabel1;
    private PzPanel pzPanelC;
    private JToolBar jToolBar;
    private PzTable tableInterni;
    private Konsignacija konsignacija;
    private boolean izmena;
    private PzToolBarIcon icnBrisanje;
    private Radnajedinica ulaznaRJ;
    private PzTable table;
    private Stanje stanjeIzlaz;
    private List<Artikalkonsignacija> artkonsigs;
    private PzDialogDokumentiPovratnicaMaloprodaja parent;
    private Brojacrj brojac;
    private PzPanel mainPanel;
    private PzStatusBar statusBar;
    private JLabel jlStatusBar = new JLabel();
    private JLabel brDok = new JLabel();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogPovratnicaMaloprodaja inst = new PzDialogPovratnicaMaloprodaja(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogPovratnicaMaloprodaja(JFrame frame) {
        super(frame);
        this.konsignacija = new Konsignacija();
    }

    public PzDialogPovratnicaMaloprodaja(PzDialog parent, boolean izmena, Object data1, Object data2) {
        super(parent);
        this.parent = (PzDialogDokumentiPovratnicaMaloprodaja)parent;
        this.tableInterni = (PzTable)data1;
        this.konsignacija = izmena ? (Konsignacija)this.tableInterni.getSelectedEntity() : new Konsignacija();
        this.izmena = izmena;
        this.initGUI();
        this.refresh();
        this.paintPanel();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogPovratnicaMaloprodaja.this.brDok.setText(String.valueOf(PzDialogPovratnicaMaloprodaja.this.table.getRowCount()));
            }
        });
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            this.setPreferredSize(new Dimension(1024, 786));
            if (this.izmena) {
                this.setTitle("POVRATNICA ROBE IZ: " + this.konsignacija.getRadnajedinica().getId().getOznRj() + "(" + this.konsignacija.getRadnajedinica().getgTip() + ") " + this.konsignacija.getRadnajedinica().getNaziv());
            }
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.columnWidths = new int[]{7, 7};
            mainPanelLayout.rowHeights = new int[]{69, 47, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.1};
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 20.1};
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.mainPanel.setOpaque(false);
            this.pzPanelN = new PzPanel();
            this.mainPanel.add((Component)this.pzPanelN, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pzPanelNLayout = new GridBagLayout();
            pzPanelNLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            pzPanelNLayout.rowHeights = new int[]{6, 25, 7};
            pzPanelNLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pzPanelNLayout.columnWidths = new int[]{111, 150, 20, 110, 150, 99, 324};
            this.pzPanelN.setLayout((LayoutManager)pzPanelNLayout);
            this.pzPanelN.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.jLabel1.setText("Iznos bez poreza");
            this.vrednostBezPoreza = new PzDoubleField();
            this.pzPanelN.add((Component)this.vrednostBezPoreza, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.vrednostBezPoreza.setVal((Object)this.konsignacija.getIznosBezPoreza());
            this.vrednostBezPoreza.setFocusable(false);
            this.jLabel2 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel2, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("Iznos sa porezom");
            this.vrednostSaPorezom = new PzDoubleField();
            this.pzPanelN.add((Component)this.vrednostSaPorezom, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.vrednostSaPorezom.setVal((Object)this.konsignacija.getIznosSaPorezom());
            this.vrednostSaPorezom.setFocusable(false);
            this.pzPanelC = new PzPanel();
            GridBagLayout pzPanelCLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pzPanelC, (Object)new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanelC.setLayout((LayoutManager)pzPanelCLayout);
            pzPanelCLayout.rowWeights = new double[]{0.1};
            pzPanelCLayout.rowHeights = new int[]{7};
            pzPanelCLayout.columnWeights = new double[]{0.1};
            pzPanelCLayout.columnWidths = new int[]{7};
            this.pzPanelC.setOpaque(false);
            this.jScrollPane = new JScrollPane();
            this.pzPanelC.add((Component)this.jScrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.jScrollPane.setOpaque(false);
            if (this.konsignacija.getArtikalkonsignacijas() == null) {
                this.konsignacija.setArtikalkonsignacijas((List)new IndirectList());
            }
            this.table = new PzTable(this.konsignacija.getArtikalkonsignacijas(), Artikalkonsignacija.class);
            this.table.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PzDialogPovratnicaMaloprodaja.this.icnDodavanje.doClick();
                }
            });
            this.jScrollPane.setViewportView((Component)this.table);
            this.jToolBar = new JToolBar();
            this.mainPanel.add((Component)this.jToolBar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.jToolBar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.jToolBar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(ins)");
            this.icnDodavanje.setPreferredSize(new Dimension(90, 90));
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/product_add.png")));
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("insert");
            this.icnIzmena = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/product_edit.png")));
            this.icnIzmena.setPreferredSize(new Dimension(90, 90));
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("f3");
            this.icnBrisanje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|(del)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/box_delete.png")));
            this.icnBrisanje.setActionCommand("Brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.icnArhiva = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|(ctrl+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/address_book.png")));
            this.icnArhiva.setPreferredSize(new Dimension(90, 90));
            this.icnArhiva.setActionCommand("Arhiviranje");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("ctrl+w");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki ");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setMinimumSize(new Dimension(900, 700));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        try {
            boolean izmena1 = false;
            PzTable data1 = null;
            Konsignacija data2 = null;
            Class action = Dodavanje.class;
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("Brisanje")) {
                boolean result;
                if (this.table.getSelectedEntity() == null) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Niste odabrali stavku za brisanje.", "Obavestenje", 1);
                    return;
                }
                boolean bl = result = JOptionPane.showConfirmDialog((Component)((Object)this), "Da li ste sigurni?", "Brisanje", 0) == 0;
                if (!result) {
                    return;
                }
                Artikalkonsignacija artkons = (Artikalkonsignacija)this.table.getSelectedEntity();
                this.konsignacija.setIznosBezPoreza(this.konsignacija.getIznosBezPoreza().subtract(PzMathUtility.roundToBigDecimal((double)(artkons.getCenaBezPoreza() * artkons.getKolicina()))));
                this.konsignacija.setIznosSaPorezom(this.konsignacija.getIznosSaPorezom().subtract(PzMathUtility.roundToBigDecimal((double)(artkons.getCenaSaPorezom() * artkons.getKolicina()))));
                this.konsignacija.setPdvIznos(this.konsignacija.getIznosSaPorezom().subtract(this.konsignacija.getIznosBezPoreza()));
                this.artkonsigs = this.konsignacija.getArtikalkonsignacijas();
                this.artkonsigs.remove(artkons);
                this.konsignacija.setArtikalkonsignacijas(this.artkonsigs);
                this.vrednostBezPoreza.setVal((Object)this.konsignacija.getIznosBezPoreza());
                this.vrednostSaPorezom.setVal((Object)this.konsignacija.getIznosSaPorezom());
                em.getTransaction().begin();
                em.remove(em.find(Artikalkonsignacija.class, (Object)artkons.getId()));
                em.merge((Object)this.konsignacija);
                em.getTransaction().commit();
                this.table.refreshData();
                return;
            }
            if (actionCommand.equals("Izmena")) {
                JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Izmena nemogu\u0107a. Probaj brisanje pa dodavanje.", "Obavestenje", 1);
                return;
            }
            if (actionCommand.equals("Arhiviranje")) {
                if (this.table.getRowCount() == 0) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nije uneta nijedna stavka na povratnici.", "Obavestenje", 1);
                    return;
                }
                action = Arhiviranje.class;
            }
            data1 = this.table;
            data2 = this.konsignacija;
            this.showDialog(action, izmena1, data1, data2);
            this.vrednostBezPoreza.setVal((Object)this.konsignacija.getIznosBezPoreza());
            this.vrednostSaPorezom.setVal((Object)this.konsignacija.getIznosSaPorezom());
        }
        catch (Exception e1) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public boolean shouldBeShown() {
        if (this.izmena) {
            return true;
        }
        boolean result = false;
        this.ulaznaRJ = PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"ET"});
        if (this.ulaznaRJ != null) {
            result = true;
            this.setTitle("POVRATNICA ROBE IZ: " + this.ulaznaRJ.getId().getOznRj() + "(" + this.ulaznaRJ.getgTip() + ") " + this.ulaznaRJ.getNaziv());
            EntityManager em = PzEntityManager.getEm();
            try {
                if (this.konsignacija == null) {
                    this.konsignacija = new Konsignacija();
                }
                this.konsignacija.setStorno(0);
                this.konsignacija.setArhiviran((short)0);
                this.konsignacija.setTip("KONSIGNACIJA_POVRATNICA_M");
                em.getTransaction().begin();
                this.konsignacija.setRadnajedinica(this.ulaznaRJ);
                this.konsignacija.setDatum(new Date(new java.util.Date().getTime()));
                this.konsignacija.setProknjizen((short)0);
                this.konsignacija.setProcRabata(0.0);
                this.konsignacija.setIznosBezPoreza(new BigDecimal(0));
                this.konsignacija.setIznosSaPorezom(new BigDecimal(0));
                this.konsignacija.setPdvIznos(new BigDecimal(0));
                this.konsignacija.setRjUlaz(this.ulaznaRJ.getPunNaziv());
                PzDokumentManager.getInstance().snimiDokument((PzDokument)this.konsignacija, true, null, em);
                em.getTransaction().commit();
                this.tableInterni.insert((PzEntity)this.konsignacija, false);
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        return result;
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPovratnicaMaloprodaja(Boolean.FALSE);
    }

    public PzDialogPovratnicaMaloprodaja(Boolean initGUI) {
    }

    public void finish() {
        this.parent.finish();
        this.dispose();
    }
}

