/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.konsignacije.gui.prijemVelikoprodaja;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Artikalkonsignacija;
import rs.pezar.db.entity.Brojacrj;
import rs.pezar.db.entity.Konsignacija;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.konsignacije.gui.PzDialogPrijemVelikoprodaja;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class Arhiviranje
extends PzDialogInsert {
    private PzPanel mainPanel;
    private PzPanel pnlNorth;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private PzButton btnOk;
    private JLabel jLabel1;
    private PzPanel pnlButtons;
    private PzPanel pnlSouth;
    private Konsignacija konsignacija;
    private Brojacrj brojac;
    private PzDateField datum;
    private PzTextField oznDokumenta;
    private PzTextAreaPanel razlog;
    private ButtonGroup buttonGroupNivelacija;
    private JRadioButton saNivelacijom;
    private PzRadioGroup radioPanel;
    private JRadioButton bezNivelacije;
    private PzDialogPrijemVelikoprodaja parent;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Arhiviranje inst = new Arhiviranje(frame);
                inst.setVisible(true);
            }
        });
    }

    public Arhiviranje() {
        this.initGUI();
        this.paintPanel();
    }

    public Arhiviranje(JFrame frame) {
        super(frame);
        this.initGUI();
        this.paintPanel();
    }

    public Arhiviranje(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog, izmena, (PzTable)data1, data2);
        this.parent = (PzDialogPrijemVelikoprodaja)dialog;
        this.konsignacija = (Konsignacija)data2;
        this.paintPanel();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            this.setResizable(false);
            this.setTitle("Arhiviranje prijemnice u velikoprodaju");
            this.mainPanel = new PzPanel();
            GridBagLayout pnlMainLayout = new GridBagLayout();
            pnlMainLayout.columnWidths = new int[]{7};
            pnlMainLayout.rowHeights = new int[]{104, 234, 3};
            pnlMainLayout.columnWeights = new double[]{0.1};
            pnlMainLayout.rowWeights = new double[]{0.0, 0.0, 2.0};
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout((LayoutManager)pnlMainLayout);
            this.pnlNorth = new PzPanel();
            GridBagLayout pnlNorthLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlNorth, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            pnlNorthLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1, 0.1};
            pnlNorthLayout.rowHeights = new int[]{12, 25, 25, 7, 7, 7};
            pnlNorthLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlNorthLayout.columnWidths = new int[]{112, 113, 7, 20};
            this.pnlNorth.setLayout((LayoutManager)pnlNorthLayout);
            this.pnlNorth.setOpaque(false);
            this.jLabel7 = new JLabel();
            this.pnlNorth.add((Component)this.jLabel7, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.jLabel7.setText("Datum izrade:");
            this.datum = new PzDateField();
            this.pnlNorth.add((Component)this.datum, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.datum.setVal((Object)new Date(new java.util.Date().getTime()));
            this.radioPanel = PzRadioGroup.create((Object[])new String[]{"Sa nivelacijom", "Bez nivelacije"});
            this.radioPanel.setSelectedIndex(0);
            this.radioPanel.setLayoutAxis(1);
            this.radioPanel.setOpaque(false);
            this.pnlNorth.add((Component)this.radioPanel, (Object)new GridBagConstraints(1, 4, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel8 = new JLabel();
            this.pnlNorth.add((Component)this.jLabel8, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.jLabel8.setText("Oznaka dokumenta:");
            this.oznDokumenta = new PzTextField(){

                public boolean entityExists() {
                    String q = "SELECT k FROM Konsignacija k WHERE k.oznDokumenta = :ozndok AND k.radnajedinica.komitent = :komitent AND k.tip = :tip";
                    EntityManager em = PzEntityManager.getEm();
                    Query query = em.createQuery(q).setParameter("ozndok", (Object)Arhiviranje.this.oznDokumenta.getVal()).setParameter("komitent", (Object)Arhiviranje.this.konsignacija.getRadnajedinica().getKomitent()).setParameter("tip", (Object)"KONSIGNACIJA_PRIJEM_V");
                    return query.getResultList().size() > 0;
                }
            };
            this.pnlNorth.add((Component)this.oznDokumenta, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.oznDokumenta.setMaxLength(15);
            this.oznDokumenta.setPKField(Konsignacija.class, null);
            this.buttonGroupNivelacija = new ButtonGroup();
            this.pnlSouth = new PzPanel();
            GridBagLayout pnlSouthLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlSouth, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            pnlSouthLayout.rowWeights = new double[]{0.0, 0.1};
            pnlSouthLayout.rowHeights = new int[]{25, 7};
            pnlSouthLayout.columnWeights = new double[]{5.0};
            pnlSouthLayout.columnWidths = new int[1];
            this.pnlSouth.setLayout((LayoutManager)pnlSouthLayout);
            this.pnlSouth.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.pnlSouth.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 18, 0, 0), 0, 0));
            this.jLabel1.setText("Razlog izrade");
            this.jLabel1.setPreferredSize(new Dimension(123, 14));
            this.razlog = new PzTextAreaPanel();
            this.pnlSouth.add((Component)this.razlog, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 6, 0, 6), 0, 0));
            this.pnlButtons = new PzPanel();
            GridBagLayout pnlButtonsLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlButtons, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlButtons.setLayout((LayoutManager)pnlButtonsLayout);
            this.btnOk = new PzButton();
            this.pnlButtons.add((Component)this.btnOk, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOk.setText("OK");
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/check.png")));
            this.btnOk.setSize(100, 40);
            this.btnOk.setPreferredSize(new Dimension(160, 40));
            this.btnOk.setActionCommand("arhiva");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.btnOk.setShortcut("ctrl+w");
            pnlButtonsLayout.rowWeights = new double[]{0.1, 0.0, 0.1};
            pnlButtonsLayout.rowHeights = new int[]{20, 35, 20};
            pnlButtonsLayout.columnWeights = new double[]{0.0};
            pnlButtonsLayout.columnWidths = new int[]{124};
            this.pnlButtons.setOpaque(false);
            this.pack();
            this.setSize(559, 445);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("arhiva")) {
                this.arhiviraj();
            }
            this.dispose();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }

    private void arhiviraj() {
        boolean saNivel = false;
        if (this.radioPanel.getSelectedValue().equals("Sa nivelacijom")) {
            saNivel = true;
        } else if (this.radioPanel.getSelectedValue().equals("Bez nivelacije")) {
            saNivel = false;
        }
        if (this.oznDokumenta.isEmpty()) {
            PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Nije uneta oznaka dokumenta po kome se radi prijemnica");
            this.oznDokumenta.requestFocus();
            return;
        }
        Stanje stanje = null;
        EntityManager em = PzEntityManager.getEm();
        try {
            em.getTransaction().begin();
            this.konsignacija.setDatum(this.datum.getVal());
            this.konsignacija.setDatArh(new Date(new java.util.Date().getTime()));
            this.konsignacija.setOznDokumenta(this.oznDokumenta.getVal());
            this.konsignacija.setPoruka(this.razlog.getVal());
            Nivelacija nivelacija = null;
            if (saNivel && (nivelacija = PzEntityUtil.createNivelacija((PzDokument)this.konsignacija, (boolean)true, (boolean)true, (EntityManager)em)) != null) {
                PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivelacija, true, null, em);
            }
            for (Artikalkonsignacija akons : this.konsignacija.getArtikalkonsignacijas()) {
                StanjePK stanjepk = new StanjePK(akons.getId().getSfrProizvod(), this.konsignacija.getRadnajedinica());
                stanje = (Stanje)em.find(Stanje.class, (Object)stanjepk);
                if (stanje == null) {
                    stanje = new Stanje();
                    stanje.setId(stanjepk);
                    stanje.setAlocKolicina(0.0);
                    stanje.setKolicina(akons.getKolicina());
                    stanje.setDatZadUlaza(this.datum.getVal());
                    stanje.setKumUlaza(akons.getKolicina());
                    stanje.setProdCena(akons.getCenaBezPoreza());
                    em.persist((Object)stanje);
                    continue;
                }
                stanje.setKolicina(stanje.getKolicina() + akons.getKolicina());
                stanje.setProdCena(akons.getCenaBezPoreza());
                stanje.setDatZadUlaza(this.datum.getVal());
                stanje.setKumUlaza(stanje.getKumUlaza() + akons.getKolicina());
                em.merge((Object)stanje);
            }
            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.konsignacija, true, null, em);
            em.getTransaction().commit();
            PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.konsignacija);
            if (saNivel && nivelacija != null) {
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)nivelacija);
            }
            this.parent.finish();
            this.dispose();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new Arhiviranje(Boolean.FALSE);
    }

    public Arhiviranje(Boolean initGUI) {
    }
}

