/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.konsignacije.transformation;

import java.sql.Date;
import java.util.HashMap;
import javax.persistence.EntityManager;
import rs.pezar.core.transformation.DefaultDokumentTransformer;
import rs.pezar.core.transformation.DokumentTransformer;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Artikalkonsignacija;
import rs.pezar.db.entity.Konsignacija;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.konsignacije.gui.PzDialogDokumentiPovratnicaMaloprodaja;
import rs.pezar.konsignacije.gui.PzDialogPovratnicaMaloprodajaPregled;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.util.PzDateUtility;
import util.PzKonsignacijeUtil;

public class PovratnicaMaloprodajaTransformer
extends DokumentTransformer {
    public static final String PARAMETER_RJ = "RJ";
    public static final String PARAMETER_TIP = "TIP_DOKUMENTA";
    private boolean priprema = false;

    public HashMap<String, Object> getDokumentParameters(PzDialog parent, Lista l) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Radnajedinica rj = PzDialogRJ.getRJ((PzDialog)parent, (String[])new String[]{"ET"});
        parameters.put(PARAMETER_RJ, rj);
        parameters.put(PARAMETER_TIP, "KONSIGNACIJA_POVRATNICA_M");
        if (parameters.get(PARAMETER_RJ) == null) {
            return null;
        }
        return parameters;
    }

    public PzDokument getDokumentToTransform(PzDialog parent) {
        PzChoice[] choices = new PzChoice[]{new PzChoice("Povratnica iz arhive", (Object)"ARHIVA"), new PzChoice("Povratnica u pripremi", (Object)"U_PRIPREMI")};
        String choice = (String)PzDialogChoice.showPzDialogChoice((PzDialog)parent, (PzChoice[])choices, (String)"Izabor povratnice");
        if (choice == null) {
            return null;
        }
        if (choice.equals("ARHIVA")) {
            return PzDialogPovratnicaMaloprodajaPregled.getKonsignacijaIzArhive(parent);
        }
        this.priprema = true;
        return PzDialogDokumentiPovratnicaMaloprodaja.getKonsignacijaUPripermi(parent, "Konsignacija");
    }

    public PzDokument toDokument(Lista l, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        return PzKonsignacijeUtil.toKonsignacija(l, parameters, em);
    }

    public Lista toLista(PzDokument dokument, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Lista l = new DefaultDokumentTransformer(Konsignacija.class, Artikalkonsignacija.class).toLista(dokument, parameters, em);
        if (this.priprema) {
            l.setNaslov("KONSIGNACIJA_POVRATNICA_M " + PzDateUtility.formatDate((Date)dokument.getDatum()));
        }
        return l;
    }

    public String getName() {
        return "Transformator povratnica kons tu\u0111a roba maloprodaja";
    }

    public String getDescription() {
        return null;
    }
}

