/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.efaktura.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;

public class DataValidator {
    public static boolean isPIBValid(String string) {
        if (string == null || !string.matches("\\d{9,9}")) {
            return false;
        }
        String value = string.substring(0, 8);
        int last = DataValidator.parseInt(string.charAt(8));
        return last == DataValidator.checkSum(value, 10);
    }

    public static boolean isMBValid(String string) {
        if (string == null || !string.matches("\\d{8,8}")) {
            return false;
        }
        int last = DataValidator.parseInt(string.charAt(7));
        String value = string.substring(0, 7);
        int cs = DataValidator.mod11(value);
        int n = cs = cs > 9 ? 0 : cs;
        return last == cs;
    }

    public static boolean isJMBGValid(String string) {
        if (string == null || !string.matches("\\d{13,13}")) {
            return false;
        }
        int last = DataValidator.parseInt(string.charAt(12));
        if (DataValidator.isDateValid(string.substring(0, 7), "ddMMyyy")) {
            int cs = DataValidator.mod11(string.substring(0, 12));
            int n = cs == 11 ? 0 : (cs = cs == 10 ? 99 : cs);
            return "^60|66$".matches(string.substring(7, 9)) || last == cs;
        }
        return false;
    }

    private static int checkSum(String string, int i) {
        int first = DataValidator.parseInt(string.charAt(0));
        int cs = (first + i) % 10;
        cs = (cs != 0 ? cs : 10) * 2 % 11;
        if (string.length() == 1) {
            return (11 - cs) % 10;
        }
        return DataValidator.checkSum(string.substring(1), cs);
    }

    private static boolean isDateValid(String value, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setLenient(false);
        try {
            sdf.parse(value);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    private static int mod11(String value) {
        int cs = 0;
        int i = value.length() - 1;
        int multiplier = 2;
        while (i >= 0) {
            cs += DataValidator.parseInt(value.charAt(i)) * multiplier;
            multiplier = multiplier == 7 ? 2 : multiplier + 1;
            --i;
        }
        return 11 - cs % 11;
    }

    private static int parseInt(char value) {
        return value - 48;
    }

    public static void main(String[] args) {
        System.out.println(DataValidator.isPIBValid("107170517"));
        System.out.println(DataValidator.isMBValid("61930507"));
        System.out.println(DataValidator.isJMBGValid("0802982720086"));
    }
}

