/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzExtension;
import rs.pezar.core.log.PzLogger;

public class PzExtensionManager {
    private Vector<PzExtension> extensions;
    private Vector<PzExtension> queue;
    private PzApplication application;
    private static PzExtensionManager instance;

    public void startup() {
        instance = this;
        if (PzApplication.getApplication() != null) {
            this.application = PzApplication.getApplication();
        }
    }

    public void shutdown() {
        this.extensions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtension(PzExtension extension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        if (this.queue == null) {
            this.queue = new Vector();
        }
        this.extensions.add(extension);
        Vector<PzExtension> vector = this.queue;
        synchronized (vector) {
            if (this.application != null && this.application.getWorkbench() != null) {
                extension.initExtension(this.application);
            } else {
                PzLogger.getInstance().logInfo("Adding extension to the queue : " + extension.getClass().getName());
                this.queue.add(extension);
            }
        }
    }

    public void removeExtension(PzExtension extension) {
        if (this.extensions != null) {
            this.extensions.remove(extension);
        }
    }

    public List<PzExtension> getExtensions() {
        return this.extensions;
    }

    public static PzExtensionManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplication(PzApplication application) {
        this.application = application;
        Vector<PzExtension> vector = this.queue;
        synchronized (vector) {
            if (this.queue.size() > 0) {
                Iterator<PzExtension> i = this.queue.iterator();
                while (i.hasNext()) {
                    PzExtension e = i.next();
                    PzLogger.getInstance().logInfo("Initializing extension : " + e.getClass().getName());
                    e.initExtension(application);
                    i.remove();
                }
            }
        }
    }

    public PzApplication getApplication() {
        return this.application;
    }
}

