/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.format;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import rs.pezar.core.format.PzFormatFactory;

public class BDConverter {
    public static BigDecimal getBigDecimal(String value, DecimalFormat df) {
        df.setParseBigDecimal(true);
        BigDecimal res = null;
        try {
            res = (BigDecimal)df.parse(value);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static BigDecimal getKolicina(double value) {
        DecimalFormat df = PzFormatFactory.getKolicinaFormat();
        return BDConverter.getBigDecimal(df.format(value), df);
    }

    public static BigDecimal getProdCena(double value) {
        DecimalFormat df = PzFormatFactory.getProdCenaFormat();
        return BDConverter.getBigDecimal(df.format(value), df);
    }

    public static BigDecimal getProdCenaValuta(double value) {
        DecimalFormat df = PzFormatFactory.getProdCenaValutaFormat();
        return BDConverter.getBigDecimal(df.format(value), df);
    }

    public static BigDecimal getPlanskaCena(double value) {
        DecimalFormat df = PzFormatFactory.getPlanskaCenaFormat();
        return BDConverter.getBigDecimal(df.format(value), df);
    }

    public static BigDecimal getNabCena(double value) {
        DecimalFormat df = PzFormatFactory.getNabCenaFormat();
        return BDConverter.getBigDecimal(df.format(value), df);
    }

    public static BigDecimal getPrnc(double value) {
        DecimalFormat df = PzFormatFactory.getPrncFormat();
        return BDConverter.getBigDecimal(df.format(value), df);
    }

    public static BigDecimal getProcRabata(double value) {
        DecimalFormat df1 = PzFormatFactory.getProcRabataFormat();
        return BDConverter.getBigDecimal(df1.format(value), df1);
    }

    public static BigDecimal getProcRabata100(double value) {
        DecimalFormat df1 = PzFormatFactory.getProcRabataFormat();
        DecimalFormat df2 = (DecimalFormat)PzFormatFactory.getProcRabataFormat().clone();
        df2.setMultiplier(100);
        return BDConverter.getBigDecimal(df1.format(value), df2);
    }

    public static BigDecimal getProcMarze(double value) {
        DecimalFormat df1 = PzFormatFactory.getProcMarzeFormat();
        DecimalFormat df2 = (DecimalFormat)df1.clone();
        df2.setMultiplier(100);
        return BDConverter.getBigDecimal(df1.format(value), df2);
    }

    public static BigDecimal getIznos(double value) {
        DecimalFormat df1 = PzFormatFactory.getIznosFormat();
        return BDConverter.getBigDecimal(df1.format(value), df1);
    }

    public static BigDecimal getIznosValuta(double value) {
        DecimalFormat df1 = PzFormatFactory.getIznosValutaFormat();
        return BDConverter.getBigDecimal(df1.format(value), df1);
    }

    public static BigDecimal getIznos(BigDecimal value) {
        DecimalFormat df1 = PzFormatFactory.getIznosFormat();
        return BDConverter.getBigDecimal(df1.format(value), df1);
    }

    public static BigDecimal getIznosValuta(BigDecimal value) {
        DecimalFormat df1 = PzFormatFactory.getIznosValutaFormat();
        return BDConverter.getBigDecimal(df1.format(value), df1);
    }

    public static BigDecimal getIznosDiv100(double value) {
        DecimalFormat df1 = PzFormatFactory.getIznosFormat();
        DecimalFormat df2 = (DecimalFormat)df1.clone();
        df2.setMultiplier(100);
        return BDConverter.getBigDecimal(df1.format(value), df2);
    }

    public static BigDecimal getDefaultBigDecimal(double value) {
        DecimalFormat df1 = PzFormatFactory.getDefaultDecimalFormat();
        return BDConverter.getBigDecimal(df1.format(value), df1);
    }

    public static BigDecimal getFakturnaCena(double value) {
        DecimalFormat df1 = PzFormatFactory.getFakturnaCenaFormat();
        return BDConverter.getBigDecimal(df1.format(value), df1);
    }

    public static BigDecimal getStopaPDVProc(double value) {
        DecimalFormat df1 = PzFormatFactory.getStopaPDVFormat();
        DecimalFormat df2 = (DecimalFormat)df1.clone();
        df2.setMultiplier(100);
        return BDConverter.getBigDecimal(df1.format(value), df2);
    }

    public static BigDecimal getStopaPDV(double value) {
        DecimalFormat df1 = PzFormatFactory.getStopaPDVFormat();
        return BDConverter.getBigDecimal(df1.format(value), df1);
    }

    public static BigDecimal getKurs(double value) {
        DecimalFormat df1 = PzFormatFactory.getKursFormat();
        return BDConverter.getBigDecimal(df1.format(value), df1);
    }

    public static void main(String[] args) {
        System.out.println(BDConverter.getProcMarze(5.0));
    }

    public static int getRoundedInt(double value) {
        DecimalFormat df1 = PzFormatFactory.getIntFormat();
        return BDConverter.getBigDecimal(df1.format(value), df1).intValue();
    }
}

