/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.format;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Locale;
import rs.pezar.db.commons.PzParameter;

public class PzFormatFactory {
    private static String prodCenaPattern;
    private static String prodCenaValutaPattern;
    private static String planskaCenaPattern;
    private static String kolicinaPattern;
    private static String prncPattern;
    private static String nabCenaPattern;
    private static String procRabataPattern;
    private static String procMarzePattern;
    private static String iznosPattern;
    private static String iznosValutaPattern;
    private static String defaultDecimalPattern;
    private static String fakturnaCenaPattern;
    private static String stopaPdvPattern;
    private static String kursPattern;
    private static String garKoefPattern;
    private static Locale l;
    private static SimpleDateFormat datumFormat;

    static {
        l = new Locale(PzParameter.getParameterValue("LOCALE", "sr"));
    }

    public static DecimalFormat getProdCenaFormat() {
        if (prodCenaPattern == null) {
            prodCenaPattern = PzParameter.getParameterValue("PROD_CENA_FORMAT", "###,##0.00");
        }
        return PzFormatFactory.createDecimalFormat(new String(prodCenaPattern));
    }

    public static DecimalFormat getProdCenaValutaFormat() {
        if (prodCenaValutaPattern == null) {
            prodCenaValutaPattern = PzParameter.getParameterValue("PROD_CENA_VALUTA_FORMAT", "###,##0.00");
        }
        return PzFormatFactory.createDecimalFormat(new String(prodCenaValutaPattern));
    }

    public static DecimalFormat getPlanskaCenaFormat() {
        if (planskaCenaPattern == null) {
            planskaCenaPattern = PzParameter.getParameterValue("PLANSKA_CENA_FORMAT", "###,##0.00");
        }
        return PzFormatFactory.createDecimalFormat(new String(planskaCenaPattern));
    }

    public static DecimalFormat getFakturnaCenaFormat() {
        if (fakturnaCenaPattern == null) {
            fakturnaCenaPattern = PzParameter.getParameterValue("FAKTURNA_CENA_FORMAT", "###,##0.00");
        }
        return PzFormatFactory.createDecimalFormat(fakturnaCenaPattern);
    }

    public static DecimalFormat getPrncFormat() {
        if (prncPattern == null) {
            prncPattern = PzParameter.getParameterValue("PRNC_FORMAT", "###,##0.0000");
        }
        return PzFormatFactory.createDecimalFormat(prncPattern);
    }

    public static DecimalFormat getNabCenaFormat() {
        if (nabCenaPattern == null) {
            nabCenaPattern = PzParameter.getParameterValue("NAB_CENA_FORMAT", "###,##0.0000");
        }
        return PzFormatFactory.createDecimalFormat(nabCenaPattern);
    }

    public static DecimalFormat getKolicinaFormat() {
        if (kolicinaPattern == null) {
            kolicinaPattern = PzParameter.getParameterValue("KOLICINA_FORMAT", "###,##0.000");
        }
        return PzFormatFactory.createDecimalFormat(kolicinaPattern);
    }

    public static DecimalFormat getProcRabataFormat() {
        if (procRabataPattern == null) {
            procRabataPattern = PzParameter.getParameterValue("PROC_RABATA_FORMAT", "##0.0000");
        }
        DecimalFormat procRabataFormat = PzFormatFactory.createDecimalFormat(procRabataPattern);
        procRabataFormat.setMaximumIntegerDigits(3);
        return procRabataFormat;
    }

    public static DecimalFormat getProcMarzeFormat() {
        if (procMarzePattern == null) {
            procMarzePattern = PzParameter.getParameterValue("PROC_MARZE_FORMAT", "###,##0.0000");
        }
        return PzFormatFactory.createDecimalFormat(procMarzePattern);
    }

    public static DecimalFormat getIznosFormat() {
        if (iznosPattern == null) {
            iznosPattern = PzParameter.getParameterValue("IZNOS_FORMAT", "###,##0.00");
        }
        return PzFormatFactory.createDecimalFormat(iznosPattern);
    }

    public static DecimalFormat getIznosValutaFormat() {
        if (iznosValutaPattern == null) {
            iznosValutaPattern = PzParameter.getParameterValue("IZNOS_VALUTA_FORMAT", "###,##0.00");
        }
        return PzFormatFactory.createDecimalFormat(iznosValutaPattern);
    }

    public static DecimalFormat getGarKoefUgradnjeFormat() {
        if (garKoefPattern == null) {
            garKoefPattern = PzParameter.getParameterValue("GAR_KOEF_FORMAT", "###,##0.00");
        }
        return PzFormatFactory.createDecimalFormat(garKoefPattern);
    }

    public static DecimalFormat getDefaultDecimalFormat() {
        if (defaultDecimalPattern == null) {
            defaultDecimalPattern = PzParameter.getParameterValue("DEFAULT_DECIMAL_FORMAT", "###,##0.00");
        }
        return PzFormatFactory.createDecimalFormat(defaultDecimalPattern);
    }

    public static DecimalFormat getStopaPDVFormat() {
        if (stopaPdvPattern == null) {
            stopaPdvPattern = PzParameter.getParameterValue("STOPAPDV_DECIMAL_FORMAT", "#0.00");
        }
        DecimalFormat stopaPdvFormat = PzFormatFactory.createDecimalFormat(stopaPdvPattern);
        stopaPdvFormat.setMaximumIntegerDigits(2);
        return stopaPdvFormat;
    }

    public static DecimalFormat getKursFormat() {
        if (kursPattern == null) {
            kursPattern = PzParameter.getParameterValue("KURS_FORMAT", "###,##0.0000");
        }
        return PzFormatFactory.createDecimalFormat(kursPattern);
    }

    public static SimpleDateFormat getDateFormat() {
        if (datumFormat == null) {
            String pattern = PzParameter.getParameterValue("DATUM_FORMAT", "dd.MM.yyyy");
            datumFormat = new SimpleDateFormat(pattern);
        }
        return datumFormat;
    }

    public static DecimalFormat getIntFormat() {
        return PzFormatFactory.createDecimalFormat("###,##0");
    }

    public static synchronized DecimalFormat createDecimalFormat(String pattern) {
        DecimalFormat df = new DecimalFormat(pattern);
        df.setDecimalFormatSymbols(new DecimalFormatSymbols(l));
        df.setRoundingMode(RoundingMode.HALF_UP);
        df.setParseBigDecimal(true);
        return df;
    }
}

