/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.defaultWidgets.mainView;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import rs.pezar.core.PzApplication;
import rs.pezar.core.gui.defaultWidgets.mainView.PzTreeCellRenderer;
import rs.pezar.core.gui.defaultWidgets.mainView.TreeElement;
import rs.pezar.core.gui.defaultWidgets.mainView.WidgetTree;
import rs.pezar.core.gui.defaultWidgets.workArea.PzDragAndDropTransferHandler;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzWidget;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzExpressionParser;

public class MainViewWidget
extends PzWidget {
    private static final long serialVersionUID = -1465448963629640841L;
    private JScrollPane scp;
    private WidgetTree stablo;
    public static String ID = "MAIN_VIEW";
    private static MainViewWidget _instance;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new MainViewWidget());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public MainViewWidget() {
        this.initGUI();
        this.setID(ID);
        this.setName(ID);
        this.setTitle("Glavne akcije");
        this.setDefaultLocation(new PzWidget.Location(0, 0, 1, 1));
        _instance = this;
    }

    public static MainViewWidget getInstance() {
        return _instance;
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            thisLayout.columnWeights = new double[]{0.1};
            thisLayout.columnWidths = new int[]{7};
            thisLayout.rowWeights = new double[]{0.1};
            thisLayout.rowHeights = new int[]{7};
            this.setLayout(thisLayout);
            this.setPaintGradient(true);
            this.setGradient(new Color(132, 5, 250), Color.WHITE, PzPanel.GRADIENT_NORTH_SOUTH);
            this.scp = new JScrollPane();
            this.stablo = new WidgetTree();
            this.stablo.setBorder(new EmptyBorder(5, 5, 5, 5));
            PzTreeCellRenderer renderer = new PzTreeCellRenderer();
            this.stablo.setCellRenderer(renderer);
            this.stablo.setDragEnabled(true);
            this.stablo.setTransferHandler(new PzDragAndDropTransferHandler(this.stablo));
            this.scp.setOpaque(false);
            this.scp.getViewport().setOpaque(false);
            this.scp.setViewportView((Component)((Object)this.stablo));
            this.add((Component)this.scp, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void addElement(TreeElement element) {
        try {
            element.removeUnallowed();
            if (element.getChildren() != null && element.getChildren().size() != 0) {
                this.stablo.addElement(element);
            }
        }
        catch (PzExpressionParser.PzExpressionParserException e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }

    public void addElements(List<TreeElement> elements) {
        Iterator<TreeElement> iterator = elements.iterator();
        while (iterator.hasNext()) {
            this.addElement(iterator.next());
        }
    }

    public synchronized void removeElement(TreeElement element) {
        this.stablo.removeElement(element);
    }

    @Override
    public void setFocusOnContent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainViewWidget.this.stablo.requestFocusInWindow();
                MainViewWidget.this.stablo.setSelectionRow(0);
            }
        });
    }

    public void removeUnallowed() {
        try {
            Vector root = (Vector)this.stablo.getModel().getRoot();
            Iterator i = root.iterator();
            while (i.hasNext()) {
                TreeElement el = (TreeElement)i.next();
                if (!PzApplication.getApplication().getPermissionController().itemAvailable("TREE", String.valueOf(el.getActionClass()) + "[" + el.getParameter() + "]")) {
                    i.remove();
                    continue;
                }
                el.removeUnallowed();
            }
            this.stablo.refresh();
        }
        catch (PzExpressionParser.PzExpressionParserException e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }

    public WidgetTree getStablo() {
        return this.stablo;
    }
}

