/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.log;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFrame;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import rs.pezar.core.PzApplication;

public class PzLogListener
implements LogListener {
    private LogReaderService reader;
    private File file;

    public void logged(LogEntry entry) {
        if (entry.getLevel() != 1) {
            System.out.println(entry.getMessage());
            return;
        }
        boolean logtofile = "true".equalsIgnoreCase(PzApplication.getApplication().getAppArguments().get("pz.logtofile"));
        try {
            if (logtofile) {
                FileWriter writer = new FileWriter(this.file, true);
                String time = new SimpleDateFormat("[dd.MM.yyyy hh:mm:ss]").format(new Date(entry.getTime()));
                writer.append(String.format("%s ------ MESSAGE ------\n", time));
                writer.append(String.format("%s Bundle - %s : %s \n", time, entry.getBundle().getSymbolicName(), entry.getMessage()));
                if (entry.getException() != null) {
                    Throwable e = entry.getException();
                    writer.append(String.format("%s ------ STACKTRACE ------\n", time));
                    writer.append(ExceptionUtils.getStackTrace((Throwable)e));
                    writer.append("\n");
                }
                writer.close();
            } else {
                String time = new SimpleDateFormat("[dd.MM.yyyy hh:mm:ss]").format(new Date(entry.getTime()));
                System.out.println(String.format("%s Bundle - %s : %s \n", time, entry.getBundle().getSymbolicName(), entry.getMessage()));
                if (entry.getException() != null) {
                    Throwable e = entry.getException();
                    ExceptionUtils.printRootCauseStackTrace((Throwable)e);
                }
            }
        }
        catch (IOException e) {
            JXErrorPane.showDialog((Component)new JFrame(), (ErrorInfo)new ErrorInfo("Gre\u0161ka!", e.getMessage(), null, null, (Throwable)e, null, null));
        }
    }

    public void startup() {
        String logDirPath = String.valueOf(PzApplication.getApplication().getDataFolder().getAbsolutePath()) + File.separator + "log" + File.separator;
        File logDir = new File(logDirPath);
        if (!logDir.exists()) {
            logDir.mkdir();
        }
        this.file = new File(String.valueOf(logDirPath) + "errLog" + new SimpleDateFormat("dd-MM-yyyy").format(new Date()) + ".log");
    }

    public void shutdown() {
    }

    public void setReader(LogReaderService value) {
        this.reader = value;
        this.reader.addLogListener((LogListener)this);
    }
}

