/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.commons;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import rs.pezar.core.PzApplication;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Setting;
import rs.pezar.db.entity.SettingPK;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzSettings {
    private static String path = PzApplication.getApplication().getDataFolder() + File.separator + "dlg-data" + File.separator;
    private static JAXBContext jc;
    private static Unmarshaller u;
    private static Marshaller m;

    static {
        try {
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdir();
            }
            jc = JAXBContext.newInstance((Class[])new Class[]{Setting.class});
            m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            u = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            PzMysqlExceptionHandler.handle(e);
        }
    }

    public static String getUserSettings(String className, String componentName, String parameter) throws Exception {
        Setting s = (Setting)PzEntityManager.find(Setting.class, new SettingPK(PzApplication.getApplication().getSession().getLoggedUser().getPzusername(), className, componentName, parameter));
        if (s != null) {
            return s.getValue();
        }
        return null;
    }

    public static Dimension getDimension(String className, String componentName) {
        try {
            String[] dim = PzSettings.getSetting(className, componentName, "DIMENSION").split(",");
            return new Dimension(Integer.parseInt(dim[0]), Integer.parseInt(dim[1]));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setDimension(String className, String componentName, Dimension dim) throws Exception {
        Setting s = new Setting();
        s.setId(new SettingPK(PzApplication.getApplication().getSession().getLoggedUser().getPzusername(), className, componentName, "DIMENSION"));
        s.setValue(String.valueOf((int)dim.getWidth()) + "," + (int)dim.getHeight());
        PzSettings.saveSetting(s);
    }

    public static Point getLocation(String className, String componentName) {
        try {
            String[] dim = PzSettings.getSetting(className, componentName, "LOCATION").split(",");
            return new Point(Integer.parseInt(dim[0]), Integer.parseInt(dim[1]));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setLocation(String className, String componentName, Point p) throws Exception {
        Setting s = new Setting();
        s.setId(new SettingPK(PzApplication.getApplication().getSession().getLoggedUser().getPzusername(), className, componentName, "LOCATION"));
        s.setValue(String.valueOf((int)p.getX()) + "," + (int)p.getY());
        PzSettings.saveSetting(s);
    }

    public static int[] getVisibleColumns(String className, String componentName) {
        try {
            String[] columns = PzSettings.getSetting(className, componentName, "COLUMNS").split(",");
            int[] col = new int[columns.length];
            int i = 0;
            while (i < columns.length) {
                col[i] = Integer.parseInt(columns[i]);
                ++i;
            }
            return col;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setVisibleColumns(String className, String componentName, int[] columns) throws Exception {
        Setting s = new Setting();
        s.setId(new SettingPK(PzApplication.getApplication().getSession().getLoggedUser().getPzusername(), className, componentName, "COLUMNS"));
        String res = "";
        int i = 0;
        while (i < columns.length) {
            res = String.valueOf(res) + (i > 0 ? "," + columns[i] : "" + columns[i]);
            ++i;
        }
        s.setValue(res);
        PzSettings.saveSetting(s);
    }

    public static int[] getColumnWidths(String className, String componentName) {
        try {
            String[] columns = PzSettings.getSetting(className, componentName, "COLUMN_WIDTH").split(",");
            int[] col = new int[columns.length];
            int i = 0;
            while (i < columns.length) {
                col[i] = Integer.parseInt(columns[i]);
                ++i;
            }
            return col;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setColumnWidths(String className, String componentName, int[] columns) {
        Setting s = new Setting();
        s.setId(new SettingPK(PzApplication.getApplication().getSession().getLoggedUser().getPzusername(), className, componentName, "COLUMN_WIDTH"));
        String res = "";
        int i = 0;
        while (i < columns.length) {
            res = String.valueOf(res) + (i > 0 ? "," + columns[i] : "" + columns[i]);
            ++i;
        }
        s.setValue(res);
        PzSettings.saveSetting(s);
    }

    private static void saveSetting(Setting setting) {
        try {
            m.marshal((Object)setting, new File(String.valueOf(path) + setting.getId().getClass_() + "." + setting.getId().getComponent() + "." + setting.getId().getParameter() + ".pzdlg"));
        }
        catch (JAXBException e) {
            PzLogger.getInstance().logException(e);
        }
    }

    private static String getSetting(String className, String componentName, String parameter) throws JAXBException {
        Setting s = (Setting)u.unmarshal(new File(String.valueOf(path) + className + "." + componentName + "." + parameter + ".pzdlg"));
        if (s != null) {
            return s.getValue();
        }
        return null;
    }
}

