/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.entity.AdtaksaPK;
import rs.pezar.db.entity.Artikaldokument;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
@Table(name="ADTaksa")
public class Adtaksa
extends PzADTaksa
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private AdtaksaPK id;
    @Column(nullable=false)
    private double stopa;
    @Column(nullable=false)
    private String oznVrstaTG;
    @Column(nullable=false)
    private String opis;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="idDok", referencedColumnName="IDDOK", nullable=false, insertable=false, updatable=false), @JoinColumn(name="sfrProizvod", referencedColumnName="SFRPROIZVOD", nullable=false, insertable=false, updatable=false), @JoinColumn(name="rBroj", referencedColumnName="RBROJ", nullable=false, insertable=false, updatable=false)})
    private Artikaldokument artikaldokument;

    public Adtaksa() {
    }

    public Adtaksa(Artikaldokument artikaldokument, Tarifnagrupa tgr) {
        this.id = new AdtaksaPK(artikaldokument.getId().getIdDok(), artikaldokument.getId().getSfrProizvod(), tgr.getOznTarGr(), artikaldokument.getId().getrBroj());
        this.artikaldokument = artikaldokument;
        this.opis = tgr.getVrstatg().getOpis();
        this.stopa = tgr.getStopa();
        this.oznVrstaTG = tgr.getVrstatg().getOznVrstaTG();
    }

    public Adtaksa(Artikaldokument artikaldokument, PzADTaksa taksa) {
        this.id = new AdtaksaPK(artikaldokument.getId().getIdDok(), artikaldokument.getId().getSfrProizvod(), taksa.getOznTarGr(), artikaldokument.getId().getrBroj());
        this.artikaldokument = artikaldokument;
        this.opis = taksa.getOpis();
        this.oznVrstaTG = taksa.getOznVrstaTG();
        this.stopa = taksa.getStopa();
    }

    public AdtaksaPK getId() {
        return this.id;
    }

    public void setId(AdtaksaPK id) {
        this.id = id;
    }

    @Override
    public double getStopa() {
        return this.stopa;
    }

    public void setStopa(double stopa) {
        this.stopa = stopa;
    }

    public Artikaldokument getArtikaldokument() {
        return this.artikaldokument;
    }

    public void setArtikaldokument(Artikaldokument artikaldokument) {
        this.artikaldokument = artikaldokument;
    }

    @Override
    public String getOznVrstaTG() {
        return this.oznVrstaTG;
    }

    public void setOznVrstaTG(String oznaka) {
        this.oznVrstaTG = oznaka;
    }

    @Override
    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    @Override
    public String getOznTarGr() {
        return this.id.getOznTarGr();
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Oznaka TG", "Vrsta TG", "Stopa", "Opis"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.id.getOznTarGr(), this.oznVrstaTG, this.stopa, this.opis};
    }
}

