/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.entity.AftaksaPK;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
@Table(name="AFTaksa")
public class Aftaksa
extends PzADTaksa
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private AftaksaPK id;
    @Column(nullable=false)
    private double stopa;
    @Column(nullable=false)
    private String oznVrstaTG;
    @Column(nullable=false)
    private String opis;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="sfrProizvod", referencedColumnName="SFRPROIZVOD", nullable=false, insertable=false, updatable=false), @JoinColumn(name="idDok", referencedColumnName="IDDOK", nullable=false, insertable=false, updatable=false), @JoinColumn(name="rBroj", referencedColumnName="RBROJ", nullable=false, insertable=false, updatable=false)})
    private Artikalfaktura artikalfaktura;

    public Aftaksa() {
    }

    public Aftaksa(int idDok, String sfrProizvod, String oznTarGr, int rBroj, double stopa, String oznaka, String opis) {
        AftaksaPK id;
        this.id = id = new AftaksaPK(idDok, sfrProizvod, oznTarGr, rBroj);
        this.stopa = stopa;
        this.oznVrstaTG = oznaka;
        this.opis = opis;
    }

    public Aftaksa(Aftaksa afTaksa) {
        this(afTaksa.getId().getIdDok(), afTaksa.getId().getSfrProizvod(), afTaksa.getId().getOznTarGr(), afTaksa.getId().getrBroj(), afTaksa.getStopa(), afTaksa.getOznVrstaTG(), afTaksa.getOpis());
    }

    public Aftaksa(Artikalfaktura artikalfaktura2, Tarifnagrupa tgr) {
        this.id = new AftaksaPK(artikalfaktura2.getId().getIdDok(), artikalfaktura2.getId().getSfrProizvod(), tgr.getOznTarGr(), artikalfaktura2.getId().getrBroj());
        this.artikalfaktura = artikalfaktura2;
        this.opis = tgr.getVrstatg().getOpis();
        this.stopa = tgr.getStopa();
        this.oznVrstaTG = tgr.getVrstatg().getOznVrstaTG();
    }

    public AftaksaPK getId() {
        return this.id;
    }

    public void setId(AftaksaPK id) {
        this.id = id;
    }

    @Override
    public double getStopa() {
        return this.stopa;
    }

    public void setStopa(double stopa) {
        this.stopa = stopa;
    }

    public Artikalfaktura getArtikalfaktura() {
        return this.artikalfaktura;
    }

    public void setArtikalfaktura(Artikalfaktura artikalfaktura) {
        this.artikalfaktura = artikalfaktura;
    }

    @Override
    public String getOznVrstaTG() {
        return this.oznVrstaTG;
    }

    public void setOznVrstaTG(String oznaka) {
        this.oznVrstaTG = oznaka;
    }

    @Override
    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    @Override
    public String getOznTarGr() {
        return this.id.getOznTarGr();
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Oznaka TG", "Vrsta TG", "Stopa", "Opis"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.id.getOznTarGr(), this.oznVrstaTG, this.stopa, this.opis};
    }
}

