/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.entity.AkonstaksaPK;
import rs.pezar.db.entity.Artikalkonsignacija;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
@Table(name="AKonsTaksa")
public class Akonstaksa
extends PzADTaksa
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private AkonstaksaPK id;
    private String oznVrstaTG;
    private String opis;
    @Column(nullable=false)
    private double stopa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="sfrProizvod", referencedColumnName="sfrProizvod", nullable=false, insertable=false, updatable=false), @JoinColumn(name="idDok", referencedColumnName="idDok", nullable=false, insertable=false, updatable=false), @JoinColumn(name="rBroj", referencedColumnName="RBROJ", nullable=false, insertable=false, updatable=false)})
    private Artikalkonsignacija artikalkonsignacija;

    public Akonstaksa() {
    }

    public Akonstaksa(Artikalkonsignacija artikalkonsignacija2, Tarifnagrupa tgr) {
        this.id = new AkonstaksaPK(artikalkonsignacija2.getId().getSfrProizvod(), artikalkonsignacija2.getId().getIdDok(), tgr.getOznTarGr(), artikalkonsignacija2.getId().getrBroj());
        this.artikalkonsignacija = artikalkonsignacija2;
        this.opis = tgr.getVrstatg().getOpis();
        this.stopa = tgr.getStopa();
        this.oznVrstaTG = tgr.getVrstatg().getOznVrstaTG();
    }

    public AkonstaksaPK getId() {
        return this.id;
    }

    public void setId(AkonstaksaPK id) {
        this.id = id;
    }

    @Override
    public String getOznVrstaTG() {
        return this.oznVrstaTG;
    }

    public void setOznVrstaTG(String oznaka) {
        this.oznVrstaTG = oznaka;
    }

    @Override
    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    @Override
    public double getStopa() {
        return this.stopa;
    }

    public void setStopa(double stopa) {
        this.stopa = stopa;
    }

    public Artikalkonsignacija getArtikalkonsignacija() {
        return this.artikalkonsignacija;
    }

    public void setArtikalkonsignacija(Artikalkonsignacija artikalkonsignacija) {
        this.artikalkonsignacija = artikalkonsignacija;
    }

    @Override
    public String getOznTarGr() {
        return this.id.getOznTarGr();
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Oznaka TG", "Vrsta TG", "Stopa", "Opis"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.id.getOznTarGr(), this.oznVrstaTG, this.stopa, this.opis};
    }
}

