/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.sql.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Ambalaza;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikalgarnitura;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Artikalkonsignacija;
import rs.pezar.db.entity.Artikalnivelacija;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.EksternaSifra;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Lokacija;
import rs.pezar.db.entity.Model;
import rs.pezar.db.entity.OEBroj;
import rs.pezar.db.entity.Proizvod;
import rs.pezar.db.entity.Rabatnaskala;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.db.entity.Slika;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.Stavkakarticeartikla;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
@Table(name="Artikal")
public class Artikal
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false, length=255)
    private String sfrProizvod;
    @Column(nullable=false, length=255)
    private String barKod;
    @Column(nullable=false, length=255)
    private String bliziOpis;
    private double cenaBazna;
    private double cenaPlanska;
    private double cenaPoeni;
    private Date datDodavanja;
    private Date datDeaktivacije;
    private double duzina;
    private double fi;
    @Column(nullable=false, length=255)
    private String jedMere;
    private short garnitura;
    @Column(length=30)
    private String katBroj;
    @Column(nullable=false, length=255)
    private String naziv;
    @Column(nullable=false, length=255)
    private String opis;
    @Column(nullable=false, length=255)
    private String dobSifra;
    @Column(nullable=false)
    private double procKala;
    @Column(nullable=false, length=255)
    private String prSifra;
    private String sfrSort;
    private double sirina;
    @Column(nullable=false)
    private double standPak;
    private int status;
    @Column(nullable=false)
    private double stokMax;
    @Column(nullable=false)
    private double stokMin;
    @Column(nullable=false)
    private double tezina;
    @Column(nullable=false, length=255)
    private String tip;
    private double visina;
    @Transient
    private double kolicina;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="ArtikalSlika", joinColumns={@JoinColumn(name="sfrProizvod", nullable=false)}, inverseJoinColumns={@JoinColumn(name="fileName", nullable=false)})
    private List<Slika> slikas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="proizvodjac")
    private Komitent proizvodjac;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dobavljac")
    private Komitent dobavljac;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK", nullable=false), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ", nullable=false)})
    private Radnajedinica konsignacija;
    @OneToMany(mappedBy="artikal", fetch=FetchType.LAZY)
    private List<Artikalfaktura> artikalfakturas;
    @OneToMany(mappedBy="artikal", fetch=FetchType.LAZY)
    private List<Artikalinterniracun> artikalinterniracuns;
    @OneToMany(mappedBy="artikal", fetch=FetchType.LAZY)
    private List<Artikalkalkulacija> artikalkalkulacijas;
    @OneToMany(mappedBy="artikal", fetch=FetchType.LAZY)
    private List<Artikalkonsignacija> artikalkonsignacijas;
    @OneToMany(mappedBy="artikal", fetch=FetchType.LAZY)
    private List<Artikalnivelacija> artikalnivelacijas;
    @OneToMany(mappedBy="artikal")
    private List<Artikalopstidokument> artikalopstidokuments;
    @ManyToMany
    @JoinTable(name="TGArtikal", joinColumns={@JoinColumn(name="SFRPROIZVOD", nullable=false)}, inverseJoinColumns={@JoinColumn(name="OZNTARGR", nullable=false)})
    private List<Tarifnagrupa> tarifnagrupas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oznRobGr", nullable=false)
    private Robnagrupa robnagrupa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oznModel")
    private Model model;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oznAmbalaza")
    private Ambalaza ambalaza;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="sfrProizvod", nullable=false, insertable=false, updatable=false)
    private Proizvod proizvod;
    @OneToMany(mappedBy="artikal", fetch=FetchType.LAZY)
    @PrivateOwned
    private List<Lokacija> lokacijas;
    @OneToMany(mappedBy="artikal", fetch=FetchType.LAZY)
    @PrivateOwned
    private List<OEBroj> oebrojs;
    @OneToMany(mappedBy="artikal", fetch=FetchType.LAZY)
    private List<Rabatnaskala> rabatnaskalas;
    @OneToMany(mappedBy="artikal", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<Stanje> stanjes;
    @OneToMany(mappedBy="artikal", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<EksternaSifra> eksternasifras;
    @OneToMany(mappedBy="artikal", fetch=FetchType.LAZY)
    private List<Stavkakarticeartikla> stavkakarticeartiklas;
    @OneToMany(mappedBy="garnitura", fetch=FetchType.LAZY)
    private List<Artikalgarnitura> deloviGarniture;
    @OneToMany(mappedBy="deo", fetch=FetchType.LAZY)
    private List<Artikalgarnitura> garniture;
    @ManyToMany
    @JoinTable(name="Zamena", joinColumns={@JoinColumn(name="artikal", nullable=false)}, inverseJoinColumns={@JoinColumn(name="zamena", nullable=false)})
    private List<Artikal> zamenas;
    @ManyToMany(mappedBy="zamenas")
    private List<Artikal> artikals;

    public Artikal(String sfrProizvod2, String barKod, String jedMere, String naziv, String pomSifra, double procKala, double standPak, double stokMax, double stokMin, double tezina, String tip, Komitent sfrKomitent, Robnagrupa oznRobGr, Tarifnagrupa oznTarGr, Komitent komitent, Model oznModel, Ambalaza sfrAmbalaza, Proizvod sfrProizvod) {
        this.sfrProizvod = sfrProizvod2;
        this.barKod = barKod;
        this.jedMere = jedMere;
        this.naziv = naziv;
        this.dobSifra = pomSifra;
        this.procKala = procKala;
        this.standPak = standPak;
        this.stokMax = stokMax;
        this.stokMin = stokMin;
        this.tezina = tezina;
        this.tip = tip;
        this.dobavljac = sfrKomitent;
        this.robnagrupa = oznRobGr;
        this.proizvodjac = komitent;
        this.model = oznModel;
        this.ambalaza = sfrAmbalaza;
        this.proizvod = sfrProizvod;
        this.opis = "";
        this.setTarifnagrupas((List<Tarifnagrupa>)new IndirectList());
        this.getTarifnagrupas().add(oznTarGr);
        oznTarGr.getArtikals().add(this);
    }

    public Artikal() {
    }

    public String getSfrProizvod() {
        return this.sfrProizvod;
    }

    public void setSfrProizvod(String sfrProizvod) {
        this.sfrProizvod = sfrProizvod;
    }

    public String getBarKod() {
        return this.barKod;
    }

    public void setBarKod(String barKod) {
        this.barKod = barKod;
    }

    public void setBliziOpis(String bliziOpis) {
        this.bliziOpis = bliziOpis;
    }

    public String getBliziOpis() {
        return this.bliziOpis;
    }

    public double getCenaBazna() {
        return this.cenaBazna;
    }

    public void setCenaBazna(double cenaBazna) {
        this.cenaBazna = cenaBazna;
    }

    public double getCenaPlanska() {
        return this.cenaPlanska;
    }

    public void setCenaPlanska(double cenaPlanska) {
        this.cenaPlanska = cenaPlanska;
    }

    public double getCenaPoeni() {
        return this.cenaPoeni;
    }

    public void setCenaPoeni(double cenaPoeni) {
        this.cenaPoeni = cenaPoeni;
    }

    public Date getDatDodavanja() {
        return this.datDodavanja;
    }

    public void setDatDodavanja(Date datDodavanja) {
        this.datDodavanja = datDodavanja;
    }

    public Date getDatDeaktivacije() {
        return this.datDeaktivacije;
    }

    public void setDatDeaktivacije(Date datDeaktivacije) {
        this.datDeaktivacije = datDeaktivacije;
    }

    public double getDuzina() {
        return this.duzina;
    }

    public void setDuzina(double duzina) {
        this.duzina = duzina;
    }

    public double getFi() {
        return this.fi;
    }

    public void setFi(double fi) {
        this.fi = fi;
    }

    public String getJedMere() {
        return this.jedMere;
    }

    public void setJedMere(String jedMere) {
        this.jedMere = jedMere;
    }

    public String getKatBroj() {
        return this.katBroj;
    }

    public void setKatBroj(String katBroj) {
        this.katBroj = katBroj;
    }

    public String getNaziv() {
        return this.naziv;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public short getGarnitura() {
        return this.garnitura;
    }

    public void setGarnitura(short garnitura) {
        this.garnitura = garnitura;
    }

    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    public String getDobSifra() {
        return this.dobSifra;
    }

    public void setDobSifra(String pomSifra) {
        this.dobSifra = pomSifra;
    }

    public void setPrSifra(String prSifra) {
        this.prSifra = prSifra;
    }

    public String getPrSifra() {
        return this.prSifra;
    }

    public String getSfrSort() {
        return this.sfrSort;
    }

    public void setSfrSort(String sfrSort) {
        this.sfrSort = sfrSort;
    }

    public double getProcKala() {
        return this.procKala;
    }

    public void setProcKala(double procKala) {
        this.procKala = procKala;
    }

    public double getSirina() {
        return this.sirina;
    }

    public void setSirina(double sirina) {
        this.sirina = sirina;
    }

    public double getStandPak() {
        return this.standPak;
    }

    public void setStandPak(double standPak) {
        this.standPak = standPak;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public double getStokMax() {
        return this.stokMax;
    }

    public void setStokMax(double stokMax) {
        this.stokMax = stokMax;
    }

    public double getStokMin() {
        return this.stokMin;
    }

    public void setStokMin(double stokMin) {
        this.stokMin = stokMin;
    }

    public double getTezina() {
        return this.tezina;
    }

    public void setTezina(double tezina) {
        this.tezina = tezina;
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public double getVisina() {
        return this.visina;
    }

    public void setVisina(double visina) {
        this.visina = visina;
    }

    public void setSlikas(List<Slika> slikas) {
        this.slikas = slikas;
    }

    public List<Slika> getSlikas() {
        return this.slikas;
    }

    public Komitent getProizvodjac() {
        return this.proizvodjac;
    }

    public void setProizvodjac(Komitent komitent1) {
        this.proizvodjac = komitent1;
    }

    public Komitent getDobavljac() {
        return this.dobavljac;
    }

    public void setDobavljac(Komitent komitent2) {
        this.dobavljac = komitent2;
    }

    public void setKonsignacija(Radnajedinica konsignacija) {
        this.konsignacija = konsignacija;
    }

    public Radnajedinica getKonsignacija() {
        return this.konsignacija;
    }

    public List<Artikalfaktura> getArtikalfakturas() {
        return this.artikalfakturas;
    }

    public void setArtikalfakturas(List<Artikalfaktura> artikalfakturas) {
        this.artikalfakturas = artikalfakturas;
    }

    public List<Artikalinterniracun> getArtikalinterniracuns() {
        return this.artikalinterniracuns;
    }

    public void setArtikalinterniracuns(List<Artikalinterniracun> artikalinterniracuns) {
        this.artikalinterniracuns = artikalinterniracuns;
    }

    public List<Artikalkalkulacija> getArtikalkalkulacijas() {
        return this.artikalkalkulacijas;
    }

    public void setArtikalkalkulacijas(List<Artikalkalkulacija> artikalkalkulacijas) {
        this.artikalkalkulacijas = artikalkalkulacijas;
    }

    public List<Artikalkonsignacija> getArtikalkonsignacijas() {
        return this.artikalkonsignacijas;
    }

    public void setArtikalkonsignacijas(List<Artikalkonsignacija> artikalkonsignacijas) {
        this.artikalkonsignacijas = artikalkonsignacijas;
    }

    public List<Artikalnivelacija> getArtikalnivelacijas() {
        return this.artikalnivelacijas;
    }

    public void setArtikalnivelacijas(List<Artikalnivelacija> artikalnivelacijas) {
        this.artikalnivelacijas = artikalnivelacijas;
    }

    public List<Artikalopstidokument> getArtikalopstidokuments() {
        return this.artikalopstidokuments;
    }

    public void setArtikalopstidokuments(List<Artikalopstidokument> artikalopstidokuments) {
        this.artikalopstidokuments = artikalopstidokuments;
    }

    public List<Tarifnagrupa> getTarifnagrupas() {
        return this.tarifnagrupas;
    }

    public void setTarifnagrupas(List<Tarifnagrupa> tarifnagrupas) {
        this.tarifnagrupas = tarifnagrupas;
    }

    public Robnagrupa getRobnagrupa() {
        return this.robnagrupa;
    }

    public void setRobnagrupa(Robnagrupa robnagrupa) {
        this.robnagrupa = robnagrupa;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Ambalaza getAmbalaza() {
        return this.ambalaza;
    }

    public void setAmbalaza(Ambalaza ambalaza) {
        this.ambalaza = ambalaza;
    }

    public Proizvod getProizvod() {
        return this.proizvod;
    }

    public void setProizvod(Proizvod proizvod) {
        this.proizvod = proizvod;
    }

    public List<Lokacija> getLokacijas() {
        return this.lokacijas;
    }

    public void setLokacijas(List<Lokacija> lokacijas) {
        this.lokacijas = lokacijas;
    }

    public List<OEBroj> getOebrojs() {
        return this.oebrojs;
    }

    public void setOebrojs(List<OEBroj> oebrojs) {
        this.oebrojs = oebrojs;
    }

    public List<Rabatnaskala> getRabatnaskalas() {
        return this.rabatnaskalas;
    }

    public void setRabatnaskalas(List<Rabatnaskala> rabatnaskalas) {
        this.rabatnaskalas = rabatnaskalas;
    }

    public List<Stanje> getStanjes() {
        return this.stanjes;
    }

    public void setStanjes(List<Stanje> stanjes) {
        this.stanjes = stanjes;
    }

    public List<Stavkakarticeartikla> getStavkakarticeartiklas() {
        return this.stavkakarticeartiklas;
    }

    public void setStavkakarticeartiklas(List<Stavkakarticeartikla> stavkakarticeartiklas) {
        this.stavkakarticeartiklas = stavkakarticeartiklas;
    }

    public List<Artikalgarnitura> getDeloviGarniture() {
        return this.deloviGarniture;
    }

    public void setDeloviGarniture(List<Artikalgarnitura> deloviGarniture) {
        this.deloviGarniture = deloviGarniture;
    }

    public List<Artikalgarnitura> getGarniture() {
        return this.garniture;
    }

    public void setGarniture(List<Artikalgarnitura> garniture) {
        this.garniture = garniture;
    }

    public List<Artikal> getZamenas() {
        return this.zamenas;
    }

    public void setZamenas(List<Artikal> zamenas) {
        this.zamenas = zamenas;
    }

    public List<Artikal> getArtikals() {
        return this.artikals;
    }

    public void setArtikals2(List<Artikal> artikals) {
        this.artikals = artikals;
    }

    public List<EksternaSifra> getEksternasifras() {
        return this.eksternasifras;
    }

    public void setEksternasifras(List<EksternaSifra> eksternasifras) {
        this.eksternasifras = eksternasifras;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"\u0160ifra", "Naziv", "JM", "RGR", "Proizvo\u0111a\u010d", "Model", "Dobavlja\u010d", "Bar kod", "Katalo\u0161ki broj", "Pr. \u0161ifra", "Stand. pak.", "Stok MIN", "Stok MAX", "Ambala\u017ea", "Te\u017eina"};
    }

    @Override
    public Object[] getValues() {
        String sifProizvodjac = this.proizvodjac == null ? "" : this.proizvodjac.getSfrKomitent();
        String sifModel = this.model == null ? "" : this.model.getOznModel();
        String sifDobavljac = this.dobavljac == null ? "" : this.dobavljac.getSfrKomitent();
        String sifAmbalaza = this.ambalaza == null ? "" : this.ambalaza.getOznAmbalaza();
        return new Object[]{PzEntityUtil.strZero(this.sfrProizvod, 9), this.naziv, this.jedMere, this.robnagrupa.getOznRobGr(), sifProizvodjac, sifModel, sifDobavljac, this.barKod, this.dobSifra, this.prSifra, this.standPak, this.stokMin, this.stokMax, sifAmbalaza, this.tezina};
    }

    public Tarifnagrupa getTarifnaGrupa(String vrsta) {
        Tarifnagrupa result = null;
        if (this.tarifnagrupas != null && this.tarifnagrupas.size() > 0) {
            for (Tarifnagrupa tgr : this.tarifnagrupas) {
                if (!tgr.getVrstatg().getOznVrstaTG().equals(vrsta)) continue;
                result = tgr;
                break;
            }
        }
        return result;
    }

    public double getStopa(String vrsta) {
        Tarifnagrupa tgr = this.getTarifnaGrupa(vrsta);
        if (tgr == null) {
            return 0.0;
        }
        return tgr.getStopa();
    }

    public double getUkupnaStopa() {
        double result = 0.0;
        for (Tarifnagrupa tg : this.getTarifnagrupas()) {
            result += tg.getStopa();
        }
        return result;
    }

    public double getKolicina() {
        return this.kolicina;
    }

    public void setKolicina(double kolicina) {
        this.kolicina = kolicina;
    }
}

