/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Aodtaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.ArtikalopstidokumentPK;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Usluga;
import rs.pezar.globals.TipDokumentConfig;

@Entity
@Table(name="ArtikalOpstiDokument")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="discriminator", discriminatorType=DiscriminatorType.STRING, length=255)
public class Artikalopstidokument
extends PzArtikalDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ArtikalopstidokumentPK id;
    @Column(length=255)
    private String bliziOpis;
    @Column(nullable=false)
    private double cenaBezPoreza;
    @Column(nullable=false)
    private double cenaSaPorezom;
    @Column(nullable=false, length=255)
    private String jm;
    @Column(nullable=false)
    private double kolicina;
    @Column(nullable=false)
    private double kolicinaBaza;
    @Column(length=40)
    private String lokacija;
    @Column(nullable=false, length=255)
    private String naziv;
    @Column(nullable=false)
    private double procRabata;
    private BigDecimal prodCena = new BigDecimal(0);
    private BigDecimal prosNabCena = new BigDecimal(0);
    private int sort;
    private int indk;
    private String dobSifra;
    @OneToMany(mappedBy="artikalopstidokument", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    private List<Aodtaksa> aodtaksas;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumns(value={@JoinColumn(name="par_idDok", referencedColumnName="IDDOK"), @JoinColumn(name="par_sfrProizvod", referencedColumnName="SFRPROIZVOD"), @JoinColumn(name="par_rBroj", referencedColumnName="RBROJ")})
    private Artikalopstidokument artikalopstidokument;
    @OneToMany(mappedBy="artikalopstidokument", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Artikalopstidokument> artikalopstidokuments;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrProizvod", nullable=false, insertable=false, updatable=false)
    private Artikal artikal;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Opstidokument opstidokument;

    @Override
    public ArtikalopstidokumentPK getId() {
        return this.id;
    }

    public void setId(ArtikalopstidokumentPK id) {
        this.id = id;
    }

    @Override
    public String getBliziOpis() {
        return this.bliziOpis;
    }

    @Override
    public void setBliziOpis(String bliziOpis) {
        this.bliziOpis = bliziOpis;
    }

    public double getCenaBezPoreza() {
        return this.cenaBezPoreza;
    }

    public void setCenaBezPoreza(double cenaBezPoreza) {
        this.cenaBezPoreza = cenaBezPoreza;
    }

    public double getCenaSaPorezom() {
        return this.cenaSaPorezom;
    }

    public void setCenaSaPorezom(double cenaSaPorezom) {
        this.cenaSaPorezom = cenaSaPorezom;
    }

    @Override
    public String getJm() {
        return this.jm;
    }

    @Override
    public void setJm(String jm) {
        this.jm = jm;
    }

    @Override
    public double getKolicina() {
        return this.kolicina;
    }

    @Override
    public void setKolicina(double kolicina) {
        this.kolicina = kolicina;
    }

    public double getKolicinaBaza() {
        return this.kolicinaBaza;
    }

    public void setKolicinaBaza(double kolicinaBaza) {
        this.kolicinaBaza = kolicinaBaza;
    }

    public String getLokacija() {
        return this.lokacija;
    }

    public void setLokacija(String lokacija) {
        this.lokacija = lokacija;
    }

    @Override
    public String getNaziv() {
        return this.naziv;
    }

    @Override
    public void setNaziv(String nazivArt) {
        this.naziv = nazivArt;
    }

    @Override
    public double getProcRabata() {
        return this.procRabata;
    }

    @Override
    public void setProcRabata(double procRabata) {
        this.procRabata = procRabata;
    }

    @Override
    public BigDecimal getProdCena() {
        return this.prodCena;
    }

    @Override
    public void setProdCena(BigDecimal prodCena) {
        this.prodCena = prodCena;
    }

    @Override
    public BigDecimal getProsNabCena() {
        return this.prosNabCena;
    }

    @Override
    public void setProsNabCena(BigDecimal prosNabCena) {
        this.prosNabCena = prosNabCena;
    }

    @Override
    public int getSort() {
        return this.sort;
    }

    @Override
    public void setSort(int sort) {
        this.sort = sort;
    }

    public List<Aodtaksa> getAodtaksas() {
        return this.aodtaksas;
    }

    public void setAodtaksas(List<Aodtaksa> aodtaksas) {
        this.aodtaksas = aodtaksas;
    }

    public Artikalopstidokument getArtikalopstidokument() {
        return this.artikalopstidokument;
    }

    public void setArtikalopstidokument(Artikalopstidokument artikalopstidokument) {
        this.artikalopstidokument = artikalopstidokument;
    }

    public List<Artikalopstidokument> getArtikalopstidokuments() {
        return this.artikalopstidokuments;
    }

    public void setArtikalopstidokuments(List<Artikalopstidokument> artikalopstidokuments) {
        this.artikalopstidokuments = artikalopstidokuments;
    }

    @Override
    public Artikal getArtikal() {
        return this.artikal;
    }

    @Override
    public void setArtikal(Artikal artikal) {
        this.artikal = artikal;
    }

    public Opstidokument getOpstidokument() {
        return this.opstidokument;
    }

    public void setOpstidokument(Opstidokument opstidokument) {
        this.opstidokument = opstidokument;
    }

    @Override
    public void addTaksa(Tarifnagrupa tgr) {
        if (this.aodtaksas == null) {
            this.aodtaksas = new IndirectList();
        }
        this.aodtaksas.add(new Aodtaksa(this, tgr));
    }

    @Override
    public double getCena() {
        if (this.opstidokument.getTip().equals("OTPIS") || this.opstidokument.getTip().equals("UVECANJE_LAGERA") || this.opstidokument.getTip().equals("UMANJENJE_LAGERA")) {
            if (this.opstidokument.getRadnajedinica().getgTip().equals("E")) {
                return this.getCenaSaPorezom();
            }
            return this.getCenaBezPoreza();
        }
        if (this.opstidokument.getTip().equals("TRANSFER")) {
            return this.getCenaSaPorezom();
        }
        if (this.opstidokument.getTip().equals("TREBOVANJE") || this.opstidokument.getTip().equals(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU) || this.opstidokument.getTip().equals("PREDAJNICA")) {
            return this.getCenaBezPoreza();
        }
        if (this.opstidokument.getTip().equals("FISKALNI_IZVESTAJ")) {
            return this.getProdCena().doubleValue();
        }
        if (this.opstidokument.getTip().equals(TipDokumentConfig.get().PROMENA_STOPE)) {
            return this.getCenaSaPorezom();
        }
        if (this.opstidokument.getTip().equals(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA)) {
            return this.getProdCena().doubleValue();
        }
        return 0.0;
    }

    @Override
    public String[] getColumnNames() {
        if (PzEntityUtil.currentType == null) {
            if (this.opstidokument.getTip().equals("FISKALNI_IZVESTAJ")) {
                return new String[]{"\u0160ifra", "Naziv", "Koli\u010dina", "Cena", "Vrednost"};
            }
            if (this.opstidokument.getTip().equals("PREDAJNICA")) {
                return new String[]{"\u0160ifra", "Naziv", "JM", "Koli\u010dina", "Cena", "Vrednost", "Prodajna cena"};
            }
            return new String[]{"\u0160ifra", "Naziv", "JM", "Koli\u010dina", "Cena", "Vrednost"};
        }
        if (PzEntityUtil.currentType.equals("POPIS")) {
            return new String[]{"\u0160ifra", "Naziv", "Bli\u017ei opis", "Knj. kol.", "Kol. pop.", "Razlika kol.", "Knj. cena", "Cena na popisu", "Vred. razlike", "Vred. popisa"};
        }
        return new String[]{"\u0160ifra", "Naziv", "JM", "Koli\u010dina", "Cena", "Vrednost"};
    }

    @Override
    public PzDokument getDokument() {
        return this.opstidokument;
    }

    @Override
    public Object[] getKValues() {
        return null;
    }

    @Override
    public String getSifra() {
        return this.getId().getSfrProizvod();
    }

    @Override
    public List<? extends PzADTaksa> getTaksas() {
        return this.aodtaksas;
    }

    @Override
    public Usluga getUsluga() {
        return null;
    }

    @Override
    public Object[] getValues() {
        if (PzEntityUtil.currentType == "POPIS") {
            return new Object[]{this.id.getSfrProizvod(), this.naziv, this.bliziOpis, this.kolicinaBaza, this.kolicina, this.kolicina - this.kolicinaBaza, this.cenaBezPoreza, this.cenaSaPorezom, (this.kolicina - this.kolicinaBaza) * this.cenaSaPorezom, this.kolicina * this.cenaSaPorezom};
        }
        if (this.opstidokument.getTip().equals("FISKALNI_IZVESTAJ")) {
            return new Object[]{this.id.getSfrProizvod(), this.naziv, this.kolicina, this.cenaBezPoreza, this.cenaBezPoreza * this.kolicina};
        }
        if (this.opstidokument.getTip().equals("OTPIS") || this.opstidokument.getTip().equals("UVECANJE_LAGERA") || this.opstidokument.getTip().equals("UMANJENJE_LAGERA")) {
            if (this.opstidokument.getRadnajedinica().getgTip().equals("E")) {
                return new Object[]{this.id.getSfrProizvod(), this.naziv, this.jm, this.kolicina, this.cenaSaPorezom, this.kolicina * this.cenaSaPorezom};
            }
            return new Object[]{this.id.getSfrProizvod(), this.naziv, this.jm, this.kolicina, this.cenaBezPoreza, this.kolicina * this.cenaBezPoreza};
        }
        if (this.opstidokument.getTip().equals("TREBOVANJE") || this.opstidokument.getTip().equals("TREBOVANJE_SASTAVNICE") || this.opstidokument.getTip().equals(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU)) {
            return new Object[]{this.id.getSfrProizvod(), this.naziv, this.jm, this.kolicina, this.cenaBezPoreza, this.cenaBezPoreza * this.kolicina};
        }
        if (this.opstidokument.getTip().equals("PREDAJNICA")) {
            return new Object[]{this.id.getSfrProizvod(), this.naziv, this.jm, this.kolicina, this.cenaBezPoreza, this.cenaBezPoreza * this.kolicina, this.prodCena.doubleValue()};
        }
        return null;
    }

    @Override
    public void setCena(double cena) {
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.opstidokument = (Opstidokument)dokument;
    }

    @Override
    public void setId(int dokId, String artId, int rBroj) {
        this.id = new ArtikalopstidokumentPK(dokId, artId, rBroj);
    }

    @Override
    public void setUsluga(Usluga usluga) {
    }

    public void setIndk(int indk) {
        this.indk = indk;
    }

    public int getIndk() {
        return this.indk;
    }

    public void setDobSifra(String dobSifra) {
        this.dobSifra = dobSifra;
    }

    public String getDobSifra() {
        return this.dobSifra;
    }

    @Override
    public BigDecimal getVrednost() {
        if (this.getOpstidokument() != null && this.getOpstidokument().getTip().equals(TipDokumentConfig.get().PROMENA_STOPE)) {
            return BDConverter.getProdCena(this.getCenaSaPorezom() - this.getCenaBezPoreza());
        }
        return super.getVrednost();
    }

    public BigDecimal getPdv() {
        BigDecimal pdvPlus100Podeljeno100 = BDConverter.getIznos((100.0 + this.getTaksa("PDV").getStopa()) / 100.0);
        BigDecimal cenaBezPDVa = BDConverter.getIznos(this.cenaSaPorezom / pdvPlus100Podeljeno100.doubleValue());
        return BDConverter.getIznos(this.cenaSaPorezom - cenaBezPDVa.doubleValue());
    }
}

