/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.PzRacun;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Aftaksa;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikalfakturaparameter;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Fakturaopstidokument;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.Fizickolice;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Koplaca;
import rs.pezar.db.entity.Nalogmagacinu;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadniNalog;
import rs.pezar.db.entity.Stavkafaktureusl;
import rs.pezar.db.entity.Stavkaporudzbine;
import rs.pezar.db.entity.Taksafaktura;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.util.PzDateUtility;

@Entity
@Table(name="Faktura")
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="discriminator", discriminatorType=DiscriminatorType.STRING, length=100)
@DiscriminatorValue(value="FAKTURA_STANDARDNA")
public class Faktura
extends PzDokument
implements PzRacun,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false)
    private int idDok;
    @Column(nullable=false)
    private short arhiviran;
    @Column(nullable=false)
    private short cvProdajna;
    private Date datArh;
    private Date datPrometa;
    @Column(nullable=false)
    private Date datum;
    private Date datValute;
    private BigDecimal iznos = new BigDecimal(0);
    private BigDecimal iznosBezPoreza = new BigDecimal(0);
    private BigDecimal vrednostRobe = new BigDecimal(0);
    private double kurs;
    private BigDecimal nabavnaUkupno = new BigDecimal(0);
    @Column(length=255)
    private String oznDokumenta;
    @Column(length=100)
    private String pb;
    @Column(length=30)
    private String podTip;
    @Column(length=2000)
    private String poruka;
    private String potvrda;
    private double procRabata;
    @Column(nullable=false)
    private short proknjizen;
    private BigDecimal rabatUkupno = new BigDecimal(0);
    @Column(nullable=false)
    private int rbrDok;
    @Column(nullable=false)
    private int rBroj;
    @Column(nullable=false)
    private int storno;
    private BigDecimal stornoIznos = new BigDecimal(0);
    @Column(nullable=false, length=255)
    private String tip;
    private BigDecimal uplata = new BigDecimal(0);
    private short zaOtpremnice;
    private String zauzeto;
    private String robuIzdao;
    private String robuPrimio;
    private int saPorezom;
    private int saPravomNaOdbitak;
    private String licnaKarta;
    private String komercijalista;
    @Column(length=100)
    private String tekuciRacun;
    @Transient
    private double zatvaranje;
    @Transient
    private String minusnaPotvrda;
    private String nacinOtpreme;
    private BigDecimal vrednostUsluga = new BigDecimal(0);
    private BigDecimal vrednostPutTroskova;
    @OneToMany(mappedBy="faktura", cascade={CascadeType.ALL})
    @PrivateOwned
    @OrderBy(value="sort ASC")
    private List<Artikalfaktura> artikalfakturas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="faktura")
    private Faktura fakturaBean;
    @OneToMany(mappedBy="fakturaBean")
    private List<Faktura> fakturas;
    @OneToMany(mappedBy="faktura", fetch=FetchType.LAZY)
    private List<Fakturaopstidokument> fakturaopstidokuments;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Dokument dokument;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrKomitent")
    private Komitent komitent;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznRadniNalog", referencedColumnName="OZNRADNINALOG", nullable=false)})
    private RadniNalog radninalog;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK", nullable=false), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ", nullable=false)})
    private Radnajedinica radnajedinica;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamepoc", nullable=false)
    private Pzuser userPoc;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamekraj", nullable=false)
    private Pzuser userKraj;
    @OneToMany(mappedBy="faktura", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Taksafaktura> taksafakturas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="original")
    private Faktura original;
    @OneToMany(mappedBy="original")
    private List<Faktura> originals;
    @OneToMany(mappedBy="faktura", cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Stavkaporudzbine> stavkaporudzbines;
    @OneToOne(mappedBy="faktura", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Fizickolice fizickolice;
    @OneToMany(mappedBy="faktura", cascade={CascadeType.ALL})
    private List<Fakturaparameter> fakturaparameters;
    @OneToMany(mappedBy="fakturausluga", cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Stavkafaktureusl> stavkafaktureusls;
    @Transient
    private String kepu = null;

    public Faktura() {
    }

    public Faktura(Date datum, BigDecimal iznos, String oznDokumenta, BigDecimal stornoIznos, BigDecimal uplata) {
        this.datum = datum;
        this.iznos = iznos;
        this.oznDokumenta = oznDokumenta;
        this.stornoIznos = stornoIznos;
        this.uplata = uplata;
    }

    @Override
    public int getIdDok() {
        return this.idDok;
    }

    @Override
    public void setIdDok(int idDok) {
        this.idDok = idDok;
    }

    @Override
    public short getArhiviran() {
        return this.arhiviran;
    }

    @Override
    public void setArhiviran(short arhiviran) {
        this.arhiviran = arhiviran;
    }

    @Override
    public void setCvProdajna(short cvProdajna) {
        this.cvProdajna = cvProdajna;
    }

    @Override
    public short getCvProdajna() {
        return this.cvProdajna;
    }

    @Override
    public Date getDatArh() {
        return this.datArh;
    }

    @Override
    public void setDatArh(Date datArh) {
        this.datArh = datArh;
    }

    @Override
    public Date getDatPrometa() {
        return this.datPrometa;
    }

    public void setDatPrometa(Date datPrometa) {
        this.datPrometa = datPrometa;
    }

    @Override
    public Date getDatum() {
        return this.datum;
    }

    public String getMinusnaPotvrda() {
        return this.minusnaPotvrda;
    }

    public void setMinusnaPotvrda(String minusnaPotvrda) {
        this.minusnaPotvrda = minusnaPotvrda;
    }

    @Override
    public void setDatum(Date datum) {
        this.datum = datum;
    }

    @Override
    public Date getDatValute() {
        return this.datValute;
    }

    @Override
    public void setDatValute(Date datValute) {
        this.datValute = datValute;
    }

    @Override
    public BigDecimal getIznos() {
        return this.iznos;
    }

    @Override
    public void setIznos(BigDecimal iznos) {
        this.iznos = iznos;
    }

    public BigDecimal getIznosBezPoreza() {
        return this.iznosBezPoreza;
    }

    public void setIznosBezPoreza(BigDecimal iznosBezPoreza) {
        this.iznosBezPoreza = iznosBezPoreza;
    }

    @Override
    public BigDecimal getVrednostRobe() {
        return this.vrednostRobe;
    }

    @Override
    public void setVrednostRobe(BigDecimal iznosrobe) {
        this.vrednostRobe = iznosrobe;
    }

    public double getKurs() {
        return this.kurs;
    }

    public void setKurs(double kurs) {
        this.kurs = kurs;
    }

    public void setNabavnaUkupno(BigDecimal nabavnaUkupno) {
        this.nabavnaUkupno = nabavnaUkupno;
    }

    public BigDecimal getNabavnaUkupno() {
        return this.nabavnaUkupno;
    }

    @Override
    public Faktura getOriginal() {
        return this.original;
    }

    public void setOriginal(Faktura original) {
        this.original = original;
    }

    public List<Faktura> getOriginals() {
        return this.originals;
    }

    public void setOriginals(List<Faktura> originals) {
        this.originals = originals;
    }

    public void setStavkaporudzbines(List<Stavkaporudzbine> stavkaporudzbines) {
        this.stavkaporudzbines = stavkaporudzbines;
    }

    public List<Stavkaporudzbine> getStavkaporudzbines() {
        return this.stavkaporudzbines;
    }

    public Fizickolice getFizickolice() {
        return this.fizickolice;
    }

    public void setFizickolice(Fizickolice fizickolice) {
        this.fizickolice = fizickolice;
    }

    @Override
    public String getOznDokumenta() {
        return this.oznDokumenta;
    }

    @Override
    public void setOznDokumenta(String oznDokumenta) {
        this.oznDokumenta = oznDokumenta;
    }

    public String getPb() {
        return this.pb;
    }

    public void setPb(String pb) {
        this.pb = pb;
    }

    @Override
    public String getPodTip() {
        return this.podTip;
    }

    @Override
    public void setPodTip(String podTip) {
        this.podTip = podTip;
    }

    public String getPoruka() {
        return this.poruka;
    }

    public void setPoruka(String poruka) {
        this.poruka = poruka;
    }

    public String getPotvrda() {
        return this.potvrda;
    }

    public void setPotvrda(String potvrda) {
        this.potvrda = potvrda;
    }

    public double getProcRabata() {
        return this.procRabata;
    }

    public void setProcRabata(double procRabata) {
        this.procRabata = procRabata;
    }

    @Override
    public short getProknjizen() {
        return this.proknjizen;
    }

    @Override
    public void setProknjizen(short proknjizen) {
        this.proknjizen = proknjizen;
    }

    public void setRabatUkupno(BigDecimal rabatUkupno) {
        this.rabatUkupno = rabatUkupno;
    }

    public BigDecimal getRabatUkupno() {
        return this.rabatUkupno;
    }

    @Override
    public int getRbrDok() {
        return this.rbrDok;
    }

    @Override
    public void setRbrDok(int rbrDok) {
        this.rbrDok = rbrDok;
    }

    @Override
    public int getrBroj() {
        return this.rBroj;
    }

    @Override
    public void setrBroj(int rBroj) {
        this.rBroj = rBroj;
    }

    @Override
    public int getStorno() {
        return this.storno;
    }

    @Override
    public void setStorno(int storno) {
        this.storno = storno;
    }

    @Override
    public BigDecimal getStornoIznos() {
        return this.stornoIznos;
    }

    @Override
    public void setStornoIznos(BigDecimal stornoIznos) {
        this.stornoIznos = stornoIznos;
        if (this.getDokument() != null) {
            this.getDokument().setStornoIznos(stornoIznos);
        }
    }

    @Override
    public String getTip() {
        return this.tip;
    }

    @Override
    public void setTip(String tip) {
        this.tip = tip;
    }

    @Override
    public BigDecimal getUplata() {
        return this.uplata;
    }

    @Override
    public void setUplata(BigDecimal uplata) {
        this.uplata = uplata;
        if (this.getDokument() != null) {
            this.getDokument().setUplata(uplata);
        }
    }

    public short getZaOtpremnice() {
        return this.zaOtpremnice;
    }

    public void setZaOtpremnice(short zaOtpremnice) {
        this.zaOtpremnice = zaOtpremnice;
    }

    public String getRobuIzdao() {
        return this.robuIzdao;
    }

    public void setRobuIzdao(String robuIzdao) {
        this.robuIzdao = robuIzdao;
    }

    public String getRobuPrimio() {
        return this.robuPrimio;
    }

    public void setRobuPrimio(String robuPrimio) {
        this.robuPrimio = robuPrimio;
    }

    public int getSaPorezom() {
        return this.saPorezom;
    }

    public void setSaPorezom(int saPorezom) {
        this.saPorezom = saPorezom;
    }

    public int getSaPravomNaOdbitak() {
        return this.saPravomNaOdbitak;
    }

    public void setSaPravomNaOdbitak(int saPravomNaOdbitak) {
        this.saPravomNaOdbitak = saPravomNaOdbitak;
    }

    public String getLicnaKarta() {
        return this.licnaKarta;
    }

    public void setTekuciRacun(String tekuciRacun) {
        this.tekuciRacun = tekuciRacun;
    }

    public String getTekuciRacun() {
        return this.tekuciRacun;
    }

    public void setLicnaKarta(String licnaKarta) {
        this.licnaKarta = licnaKarta;
    }

    public String getKomercijalista() {
        return this.komercijalista;
    }

    public void setKomercijalista(String komercijalista) {
        this.komercijalista = komercijalista;
    }

    @Override
    public Date getDatumKnjizenja() {
        return this.getDatPrometa();
    }

    @Override
    public String getVrsta() {
        if (this.kepu != null) {
            return this.kepu;
        }
        if (this.getTip().equals("FAKTURA") || this.getTip().equals("FAKTURA_INTERNI_RACUN") || this.getTip().equals("PRENOSNICA_SA_KONSIGNACIJE")) {
            return "I";
        }
        return "N";
    }

    @Override
    public void setVrsta(String vrsta) {
        this.kepu = vrsta;
    }

    @Override
    public BigDecimal getVrednostUsluga() {
        return this.vrednostUsluga;
    }

    @Override
    public void setVrednostUsluga(BigDecimal vrednostUsluga) {
        this.vrednostUsluga = vrednostUsluga;
    }

    public BigDecimal getVrednostPutTroskova() {
        return this.vrednostPutTroskova;
    }

    public void setVrednostPutTroskova(BigDecimal vrednostPutTroskova) {
        this.vrednostPutTroskova = vrednostPutTroskova;
    }

    public List<Artikalfaktura> getArtikalfakturas() {
        return this.artikalfakturas;
    }

    public void setArtikalfakturas(List<Artikalfaktura> artikalfakturas) {
        this.artikalfakturas = artikalfakturas;
    }

    public void setFakturaBean(Faktura fakturaBean) {
        this.fakturaBean = fakturaBean;
    }

    public Faktura getFakturaBean() {
        return this.fakturaBean;
    }

    public List<Faktura> getFakturas() {
        return this.fakturas;
    }

    public void setFakturas(List<Faktura> fakturas) {
        this.fakturas = fakturas;
    }

    public List<Fakturaopstidokument> getFakturaopstidokuments() {
        return this.fakturaopstidokuments;
    }

    public void setFakturaopstidokuments(List<Fakturaopstidokument> fakturaopstidokuments) {
        this.fakturaopstidokuments = fakturaopstidokuments;
    }

    @Override
    public Dokument getDokument() {
        return this.dokument;
    }

    @Override
    public void setDokument(Dokument dokument) {
        this.dokument = dokument;
    }

    @Override
    public Komitent getKomitent() {
        return this.komitent;
    }

    @Override
    public void setKomitent(Komitent komitent) {
        this.komitent = komitent;
    }

    @Override
    public Radnajedinica getRadnajedinica() {
        return this.radnajedinica;
    }

    @Override
    public void setRadnajedinica(Radnajedinica radnajedinica) {
        this.radnajedinica = radnajedinica;
    }

    @Override
    public Pzuser getUserPoc() {
        return this.userPoc;
    }

    @Override
    public void setUserPoc(Pzuser pzuser) {
        this.userPoc = pzuser;
    }

    @Override
    public Pzuser getUserKraj() {
        return this.userKraj;
    }

    @Override
    public void setUserKraj(Pzuser pzuser) {
        this.userKraj = pzuser;
    }

    public List<Taksafaktura> getTaksafakturas() {
        return this.taksafakturas;
    }

    public void setTaksafakturas(List<Taksafaktura> taksafakturas) {
        this.taksafakturas = taksafakturas;
    }

    public List<Nalogmagacinu> getNalogmagacinus() {
        return this.getDokument().getNalogmagacinus();
    }

    public void setNalogmagacinus(List<Nalogmagacinu> nalogmagacinus) {
        this.getDokument().setNalogmagacinus(nalogmagacinus);
    }

    public Double getZatvaranje() {
        return this.zatvaranje;
    }

    public void setZatvaranje(Double zatvaranje) {
        this.zatvaranje = zatvaranje;
    }

    public List<Stavkafaktureusl> getStavkafaktureusls() {
        return this.stavkafaktureusls;
    }

    public void setStavkafaktureusls(List<Stavkafaktureusl> stavkafaktureusls) {
        this.stavkafaktureusls = stavkafaktureusls;
    }

    public String getNacinOtpreme() {
        return this.nacinOtpreme;
    }

    public void setNacinOtpreme(String nacinOtpreme) {
        this.nacinOtpreme = nacinOtpreme;
    }

    @Override
    public Object[] getKValues(byte type) {
        if (type == 1) {
            return new Object[]{this.getOznDokumenta(), this.getIznos(), this.getIznos().subtract(this.getUplata()), this.getDatum(), this.getDatValute()};
        }
        if (type == 2) {
            Object[] objectArray = new Object[7];
            objectArray[0] = this.dokument;
            objectArray[1] = this.getOznDokumenta();
            objectArray[2] = this.getIznos();
            objectArray[3] = this.getDatValute();
            objectArray[6] = this.getUplata();
            return objectArray;
        }
        return new Object[]{this.getDatum(), this.getOpis(), this.getOznDokumenta(), this.storno == 0 ? this.iznos : this.iznos.negate(), 0.0, 0.0, this.getDatValute(), 0};
    }

    @Override
    public void formirajOznaku() {
        if (!"POCETNO".equals(this.podTip)) {
            String tipf = this.getTip();
            String godina = String.valueOf(PzDateUtility.getCurrentYear());
            String rbroj = PzEntityUtil.strZero("" + this.getrBroj(), 5);
            if (tipf.equals("FAKTURA")) {
                this.oznDokumenta = this.getPodTip().equals("TRENUTNA_SITUACIJA") ? String.format("%s/%s", rbroj, godina) : String.format("%s-%s/%s", PzEntityUtil.strZero(this.getRadnajedinica().getId().getOznRj(), 3), rbroj, godina);
            } else if (tipf.equals("FAKTURA_IZ_SERVISA")) {
                this.oznDokumenta = "1" + PzEntityUtil.strZero(this.getRadnajedinica().getId().getOznRj(), 3) + "-" + PzEntityUtil.strZero(rbroj, 5) + "/" + godina;
            } else if (tipf.equals("FAKTURA_USLUGA")) {
                this.oznDokumenta = "2" + PzEntityUtil.strZero(this.getRadnajedinica().getId().getOznRj(), 3) + "-" + PzEntityUtil.strZero(rbroj, 5) + "/" + godina;
            } else if (tipf.equals("PRENOSNICA_SA_KONSIGNACIJE")) {
                this.oznDokumenta = "4" + PzEntityUtil.strZero(this.getRadnajedinica().getId().getOznRj(), 3) + "-" + PzEntityUtil.strZero(rbroj, 5) + "/" + godina;
            } else if (tipf.equals("OTPREMNICA")) {
                this.oznDokumenta = this.getRadnajedinica().getgTip().equals("T") ? "3" + PzEntityUtil.strZero(this.getRadnajedinica().getId().getOznRj(), 3) + "-" + PzEntityUtil.strZero(rbroj, 5) + "/" + godina : "5" + String.format("%s-%s/%s", PzEntityUtil.strZero(this.getRadnajedinica().getId().getOznRj(), 3), rbroj, godina);
            } else if (tipf.equals("FAKTURA_TRANZITA")) {
                this.oznDokumenta = "6" + String.format("%s-%s/%s", PzEntityUtil.strZero(this.getRadnajedinica().getId().getOznRj(), 3), rbroj, godina);
            } else if (tipf.equals("PROFAKTURA")) {
                this.oznDokumenta = "7" + String.format("%s-%s/%s", PzEntityUtil.strZero(this.getRadnajedinica().getId().getOznRj(), 3), rbroj, godina);
            } else if (!tipf.equals("FAKTURA_IZ_SERVISA")) {
                if (tipf.equals("AVANSNI_RACUN")) {
                    this.oznDokumenta = String.format("%s/%s", rbroj, godina);
                } else if (tipf.equals("FAKTURA_INTERNI_RACUN")) {
                    this.oznDokumenta = "9" + String.format("%s-%s", PzEntityUtil.strZero(this.getRadnajedinica().getId().getOznRj(), 3), rbroj);
                } else if (tipf.equals("SLIKA_MALOPRODAJNOG_RACUNA")) {
                    this.oznDokumenta = "10" + String.format("%s-%s", PzEntityUtil.strZero(this.getRadnajedinica().getId().getOznRj(), 3), rbroj);
                }
            }
            if (this.tip.equals(TipDokumentConfig.get().FAKTURA) || this.tip.equals(TipDokumentConfig.get().FAKTURA_USLUGA) && this.tip.equals(TipDokumentConfig.get().FAKTURA_SERVISA)) {
                BigDecimal brrac = new BigDecimal(this.oznDokumenta.replaceAll("\\D", ""));
                BigDecimal temp1 = brrac.multiply(new BigDecimal("100")).divide(new BigDecimal("97"), 2, 3);
                BigDecimal temp2 = new BigDecimal(brrac.multiply(new BigDecimal("100")).toBigInteger().divide(new BigInteger("97")));
                BigDecimal raz = temp1.subtract(temp2).setScale(2, 3);
                int result = new BigDecimal("98").subtract(raz.multiply(new BigDecimal(97).setScale(2, 3))).intValue();
                this.pb = String.valueOf(result) + "-" + this.oznDokumenta.replaceAll("\\D", "").replaceAll("^0+", "");
            }
        }
    }

    public void setId(int id) {
        this.idDok = id;
    }

    @Override
    public String[] getColumnNames() {
        if (this.tip.equals("FAKTURA_TRANZITA") || this.tip.equals("PROFAKTURA") || this.tip.equals("PRENOSNICA_SA_KONSIGNACIJE") || this.tip.equals("AVANSNI_RACUN") || this.tip.equals("PROPUSTENA_PRODAJA")) {
            return new String[]{"\u0160ifra", "Naziv kupca", "RJ", "Vrednost bez poreza", "Vrednost sa porezom", "Datum izrade", "Datum prometa", "Datum valute"};
        }
        if (this.tip.equals("FAKTURA") || this.tip.equals("OTPREMNICA")) {
            return new String[]{"\u0160ifra", "Naziv kupca", "RJ", "Vrednost bez poreza", "Vrednost sa porezom", "Datum izrade", "Datum prometa", "Datum valute", "Oznaka", "Nalog magacinu (Brza po\u0161ta)"};
        }
        if (this.getTip().equals("FAKTURA_INTERNI_RACUN")) {
            return new String[]{"RJ", "Datum izrade", "Vrednost bez poreza", "Vrednost sa porezom", "Nalog magacinu (Brza po\u0161ta)"};
        }
        if (this.tip.equals("OTPREMNICA") & this.fakturaBean != null) {
            return new String[]{"Otpremnica", "Iznos", "Datum izrade"};
        }
        if (this.tip.equals("SLIKA_MALOPRODAJNOG_RACUNA")) {
            return new String[]{"Oznaka dokumenta", "Datum", "Iznos", "Dokument arhivirao"};
        }
        return null;
    }

    @Override
    public Object[] getValues() {
        if (this.tip.equals("FAKTURA_TRANZITA") || this.tip.equals("PROFAKTURA") || this.tip.equals("PRENOSNICA_SA_KONSIGNACIJE") || this.tip.equals("AVANSNI_RACUN") || this.tip.equals("PROPUSTENA_PRODAJA")) {
            return new Object[]{this.komitent.getSfrKomitent(), this.komitent.getNaziv(), this.radnajedinica.getId().getOznRj(), this.iznosBezPoreza, this.iznos, this.datum, this.datPrometa, this.datValute};
        }
        if (this.tip.equals("FAKTURA") || this.tip.equals("OTPREMNICA") || this.tip.equals("FAKTURA_INTERNI_RACUN")) {
            String nalogBrzaPosta = "";
            if (this.getNalogmagacinus() != null && this.getNalogmagacinus().size() != 0) {
                for (Nalogmagacinu nalog : this.getNalogmagacinus()) {
                    Koplaca kp;
                    if (nalogBrzaPosta.length() != 0) {
                        nalogBrzaPosta = String.valueOf(nalogBrzaPosta) + ", ";
                    }
                    nalogBrzaPosta = String.valueOf(nalogBrzaPosta) + nalog.getOznNalogMagacinu();
                    if (nalog.getKoplacas() == null || nalog.getKoplacas().size() == 0 || (kp = nalog.getKoplacas().get(0)).getBrzaposta() == null) continue;
                    nalogBrzaPosta = String.valueOf(nalogBrzaPosta) + "(" + kp.getBrzaposta().getNaziv() + ")";
                }
            }
            if (this.tip.equals("FAKTURA_INTERNI_RACUN")) {
                return new Object[]{this.radnajedinica.getId().getOznRj(), this.datum, this.iznosBezPoreza, this.iznos, nalogBrzaPosta};
            }
            return new Object[]{this.komitent.getSfrKomitent(), this.komitent.getNaziv(), this.radnajedinica.getId().getOznRj(), this.iznosBezPoreza, this.iznos, this.datum, this.datPrometa, this.datValute, this.oznDokumenta, nalogBrzaPosta};
        }
        if (this.tip.equals("OTPREMNICA") & this.fakturaBean != null) {
            return new Object[]{this.oznDokumenta, this.iznos.compareTo(new BigDecimal("0.00")) == 0 ? this.getIznosSaPorezomVeleprodaja(this.artikalfakturas) : this.iznos, this.datum};
        }
        if (this.tip.equals("SLIKA_MALOPRODAJNOG_RACUNA")) {
            return new Object[]{this.oznDokumenta, this.datum, this.iznos, this.userKraj.getPzusername()};
        }
        return null;
    }

    @Override
    public String[] getDokColumnNames() {
        try {
            boolean prodajna = false;
            if (this.radnajedinica != null) {
                prodajna = this.radnajedinica.getNacinVodjenja().equals("PRODAJNA");
            }
            if (this.getTip().equals("FAKTURA")) {
                if (this.izMaloprodaje()) {
                    return new String[]{"Faktura", "\u0160ifra kupca", "Naziv kupca", "Datum fakture", "Datum valute", "Iznos fakture", "PDV", "Dokument arhivirao", "iddok"};
                }
                if (!prodajna) {
                    return new String[]{"Faktura", "\u0160ifra kupca", "Naziv kupca", "Datum fakture", "Datum valute", "Proknji\u017een", "Iznos fakture", "Rabat", "PDV", "Nabavna vrednost", "Prod. bez PDV", "Dokument arhivirao", "iddok"};
                }
                return new String[]{"Faktura", "\u0160ifra kupca", "Naziv kupca", "Datum fakture", "Datum valute", "Proknji\u017een", "Iznos fakture", "Rabat", "PDV", "Dokument arhivirao", "iddok"};
            }
            if (this.getTip().equals("OTPREMNICA")) {
                return new String[]{"Broj otpremnice", "\u0160ifra kupca", "Naziv kupca", "Datum", "Iznos", "Ukupan iznos", "Faktura", "PDV", "Zauzeto", "Dokument arhivirao", "iddok"};
            }
            if (this.tip.equals("SLIKA_MALOPRODAJNOG_RACUNA")) {
                return new String[]{"Oznaka dokumenta", "Datum", "Iznos"};
            }
            if (this.getTip().equals("PRENOSNICA_SA_KONSIGNACIJE")) {
                return new String[]{"Broj prenosnice", "\u0160ifra kupca", "Naziv kupca", "Datum", "Iznos", "Ukupan iznos", "PDV", "Dokument arhivirao", "iddok"};
            }
            if (this.getTip().equals("PROFAKTURA")) {
                return new String[]{"Broj profakture", "\u0160ifra kupca", "Naziv kupca", "Datum", "Iznos", "PDV", "Dokument arhivirao", "iddok"};
            }
            if (this.getTip().equals("AVANSNI_RACUN")) {
                return new String[]{"Broj avansnog ra\u010duna", "\u0160ifra kupca", "Naziv kupca", "Datum", "Iznos", "PDV", "Uplate", "Dokument arhivirao", "iddok"};
            }
            if (this.getTip().equals("FAKTURA_INTERNI_RACUN")) {
                if (!this.izMaloprodaje() && !prodajna) {
                    return new String[]{"Ra\u010dun", "Datum izdavanja", "Proknji\u017een", "Roba bez PDV-a", "PDV", "Iznos sa PDV-om", "Nabavna vrednost", "Dokument arhivirao", "iddok"};
                }
                if (this.izMaloprodaje()) {
                    return new String[]{"Ra\u010dun", "Datum izdavanja", "Roba bez PDV-a", "PDV", "Iznos sa PDV-om", "Dokument arhivirao", "iddok"};
                }
                return new String[]{"Ra\u010dun", "Datum izdavanja", "Proknji\u017een", "Roba bez PDV-a", "PDV", "Iznos sa PDV-om", "Dokument arhivirao", "iddok"};
            }
            if (this.getTip().equals("FAKTURA_TRANZITA")) {
                if (!prodajna) {
                    return new String[]{"Faktura", "\u0160ifra kupca", "Naziv kupca", "Datum fakture", "Datum valute", "Proknji\u017een", "Iznos fakture", "Rabat", "PDV", "Nabavna vrednost", "Dokument arhivirao", "iddok"};
                }
                return new String[]{"Faktura", "\u0160ifra kupca", "Naziv kupca", "Datum fakture", "Datum valute", "Proknji\u017een", "Iznos fakture", "Rabat", "PDV", "Dokument arhivirao", "iddok"};
            }
        }
        catch (Exception exception) {}
        return null;
    }

    @Override
    public Object[] getDokValues() {
        if (this.tip.equals("SLIKA_MALOPRODAJNOG_RACUNA")) {
            return new Object[]{this.oznDokumenta, this.datum, this.iznos};
        }
        return null;
    }

    public boolean izMaloprodaje() {
        return this.getRadnajedinica().getgTip().equals("E");
    }

    public BigDecimal getRabat() {
        BigDecimal rez = new BigDecimal(0);
        for (Artikalfaktura af : this.artikalfakturas) {
            BigDecimal kolicina = BDConverter.getKolicina(af.getKolicina());
            BigDecimal cena = BDConverter.getProdCena(af.getCena());
            BigDecimal vrednost = BDConverter.getIznos(cena.multiply(kolicina));
            BigDecimal procRabata = BDConverter.getProcRabata100(af.getProcRabata());
            BigDecimal iznosRabata = BDConverter.getIznos(vrednost.multiply(procRabata));
            rez = rez.add(iznosRabata);
        }
        return rez;
    }

    public BigDecimal getUkupanPDV() {
        BigDecimal rez = new BigDecimal(0);
        for (Taksafaktura pdvF : this.taksafakturas) {
            if (!pdvF.getVrsta().equals("PDV")) continue;
            BigDecimal pdvIznos = BDConverter.getIznos(pdvF.getIznos());
            rez = rez.add(pdvIznos);
        }
        return rez;
    }

    public void povecajCenu(double procenat, EntityManager em) {
        for (Artikalfaktura af : this.artikalfakturas) {
            double cena = af.getCena();
            af.setCena(cena + cena * procenat / 100.0);
            em.merge((Object)af);
        }
    }

    public BigDecimal getIznosSaPorezomVeleprodaja(List<Artikalfaktura> artikli) {
        BigDecimal rez = new BigDecimal(0);
        if (artikli != null) {
            for (Artikalfaktura af : artikli) {
                rez = rez.add(af.iznosSaPorezomVeleprodaja());
            }
        }
        return rez;
    }

    public BigDecimal getIznosBezPorezaVeleprodaja(List<Artikalfaktura> artikli) {
        BigDecimal rez = new BigDecimal(0);
        if (artikli != null) {
            for (Artikalfaktura af : artikli) {
                BigDecimal osnovica = af.naracunajIznosBezRabata();
                rez = rez.add(osnovica);
            }
        }
        return rez;
    }

    public BigDecimal getIznosBezPorezaMaloprodaja(List<Artikalfaktura> artikli) {
        BigDecimal rez = new BigDecimal(0);
        if (artikli != null) {
            for (Artikalfaktura af : artikli) {
                rez = rez.add(af.iznosBezPorezaMaloprodaja());
            }
        }
        return rez;
    }

    public BigDecimal getNabavnaVrednost(List<Artikalfaktura> artikli) {
        BigDecimal rez = new BigDecimal(0);
        if (artikli != null) {
            for (Artikalfaktura af : artikli) {
                BigDecimal kolicina = BDConverter.getKolicina(af.getKolicina());
                BigDecimal vrednost = BDConverter.getIznos(kolicina.multiply(af.getProsNabCena()));
                rez = rez.add(vrednost);
            }
        }
        return rez;
    }

    public Artikalfaktura getArtikal(String sfrA) {
        for (Artikalfaktura af : this.artikalfakturas) {
            if (!af.getId().getSfrProizvod().equals(sfrA)) continue;
            return af;
        }
        return null;
    }

    public boolean postojiTaksa(String oznTarGr) {
        for (Taksafaktura taksa : this.taksafakturas) {
            if (!taksa.getId().getOznTarGr().equals(oznTarGr)) continue;
            return true;
        }
        return false;
    }

    public BigDecimal getObracunatiIznos() {
        BigDecimal rez = new BigDecimal(0);
        for (Taksafaktura pdvF : this.taksafakturas) {
            BigDecimal obracunatiIznos = BDConverter.getIznos(pdvF.getObracunatiIznos());
            rez = rez.add(obracunatiIznos);
        }
        return rez;
    }

    public BigDecimal getIznosDokumenta() {
        if (this.izMaloprodaje()) {
            if (this.saPorezom == 1) {
                return this.getIznosBezPorezaVeleprodaja(this.artikalfakturas).add(this.getTrosakBezPoreza()).add(this.getTrosakPorez());
            }
            return this.getIznosBezPorezaMaloprodaja(this.artikalfakturas).add(this.getTrosakBezPoreza());
        }
        if (this.saPorezom == 1) {
            return this.getIznosSaPorezomVeleprodaja(this.artikalfakturas).add(this.getTrosakBezPoreza()).add(this.getTrosakPorez());
        }
        return this.getIznosBezPorezaVeleprodaja(this.artikalfakturas).add(this.getTrosakBezPoreza());
    }

    public BigDecimal getTrosakBezPoreza() {
        BigDecimal res = new BigDecimal(0);
        if (this.getFakturaParameterValue("DOD_TROS_IZNOS") != null && !"".equals(this.getFakturaParameterValue("DOD_TROS_IZNOS"))) {
            res = BDConverter.getIznos(new BigDecimal(this.getFakturaParameterValue("DOD_TROS_IZNOS")));
            if (this.izMaloprodaje()) {
                res = res.subtract(BDConverter.getIznos(new BigDecimal(this.getFakturaParameterValue("DOD_TROS_TG_IZNOS"))));
            }
        }
        return res;
    }

    public BigDecimal getTrosakPorez() {
        BigDecimal res = new BigDecimal(0);
        if (this.getFakturaParameterValue("DOD_TROS_TG_IZNOS") != null && !"".equals(this.getFakturaParameterValue("DOD_TROS_TG_IZNOS"))) {
            res = BDConverter.getIznos(new BigDecimal(this.getFakturaParameterValue("DOD_TROS_TG_IZNOS")));
        }
        return res;
    }

    @Override
    public void addTaksas() {
        super.addTaksas();
        if (this.getFakturaParameterValue("DOD_TROS_TG_IZNOS") != null && !this.getFakturaParameterValue("DOD_TROS_TG_IZNOS").equals("")) {
            Taksafaktura tf = (Taksafaktura)this.getTaksa(this.getFakturaParameterValue("DOD_TROS_TG"), "PDV", PzTaksaDokument.TIP_IZRACUNATI);
            if (tf == null) {
                tf = (Taksafaktura)this.createEmptyTaksaDokument(this.getFakturaParameterValue("DOD_TROS_TG"), PzTaksaDokument.TIP_IZRACUNATI);
                tf.setIznos(this.getTrosakPorez());
                tf.setOsnovica(this.getTrosakBezPoreza());
                tf.setTarifnagrupa((Tarifnagrupa)PzEntityManager.findEntity(Tarifnagrupa.class, this.getFakturaParameterValue("DOD_TROS_TG")));
                tf.getId().setIdDok(this.getIdDok());
                tf.setVrsta("PDV");
                this.getTaksafakturas().add(tf);
            } else {
                tf.getOsnovica().add(this.getTrosakBezPoreza());
                tf.getIznos().add(this.getTrosakPorez());
            }
        }
    }

    @Override
    public void izracunajVrednostRobe() {
        super.izracunajVrednostRobe();
        if (this.getFakturaParameterValue("DOD_TROS_TG_IZNOS") != null) {
            this.setVrednostUsluga(this.getVrednostUsluga().add(this.getTrosakBezPoreza()));
        }
    }

    public Artikalfaktura getStavkaZaSpajanje(Artikalfaktura stavka) {
        String stavkaSifra = stavka.getId().getSfrProizvod();
        BigDecimal stavkaCena = stavka.getProdCena();
        BigDecimal stavkaRabat = BDConverter.getProcRabata(stavka.getProcRabata());
        String stavkaKonsignacija = stavka.getKonsignacija();
        for (Artikalfaktura tekuciArtikal : this.artikalfakturas) {
            String tekuciArtikalSifra = tekuciArtikal.getId().getSfrProizvod();
            BigDecimal tekuciArtikalCena = tekuciArtikal.getProdCena();
            BigDecimal tekuciArtikalRabat = BDConverter.getProcRabata(tekuciArtikal.getProcRabata());
            String tekuciArtikalKonsignacija = tekuciArtikal.getKonsignacija();
            if (!tekuciArtikalSifra.equals(stavkaSifra) || tekuciArtikalCena.compareTo(stavkaCena) != 0 || tekuciArtikalRabat.compareTo(stavkaRabat) != 0 || !tekuciArtikalKonsignacija.equals(stavkaKonsignacija)) continue;
            return tekuciArtikal;
        }
        return null;
    }

    public void kopirajArtikleSaFakture(Faktura f, boolean spojiStavke) throws Exception {
        f.getArtikalfakturas();
        for (Artikalfaktura af : f.getArtikalfakturas()) {
            Artikalfaktura postojecaStavka;
            Artikalfaktura kopija = new Artikalfaktura(af);
            boolean postojiStavka = false;
            if (spojiStavke && (postojecaStavka = this.getStavkaZaSpajanje(kopija)) != null) {
                postojecaStavka.setKolicina(postojecaStavka.getKolicina() + kopija.getKolicina());
                postojecaStavka.setKolSaKons(postojecaStavka.getKolSaKons() + kopija.getKolSaKons());
                postojiStavka = true;
            }
            if (postojiStavka) continue;
            kopija.getId().setrBroj(this.getNextRBrojArtikli());
            this.artikalfakturas.add(kopija);
            kopija.setFaktura(this);
            if (this.zaOtpremnice == 1) {
                kopija.setSaOtpremnice(f.getOznDokumenta());
            }
            for (Aftaksa taksa : af.getAftaksas()) {
                Aftaksa taksaKopija = new Aftaksa(taksa);
                taksaKopija.setArtikalfaktura(kopija);
                if (kopija.getAftaksas() == null) {
                    kopija.setAftaksas((List<Aftaksa>)new IndirectList());
                }
                kopija.getAftaksas().add(taksaKopija);
            }
            for (Artikalfakturaparameter param : af.getArtikalFakturaParameters()) {
                Artikalfakturaparameter parameterKopija = new Artikalfakturaparameter(param);
                parameterKopija.setArtikalFaktura(kopija);
                if (kopija.getArtikalFakturaParameters() == null) {
                    kopija.setArtikalFakturaParameters((List<Artikalfakturaparameter>)new IndirectList());
                }
                kopija.getArtikalFakturaParameters().add(parameterKopija);
            }
        }
        this.adjust();
        this.iznos = new BigDecimal(0);
        this.iznosBezPoreza = new BigDecimal(0);
        this.rabatUkupno = new BigDecimal(0);
        this.nabavnaUkupno = new BigDecimal(0);
    }

    public String getZauzeto() {
        return this.zauzeto;
    }

    public void setZauzeto(String zauzeto) {
        this.zauzeto = zauzeto;
    }

    @Override
    public List<? extends PzArtikalDokument> getArtikalDocuments() {
        return this.artikalfakturas;
    }

    @Override
    public String getOpis() {
        String dokument = "Greska u prepoznavanju ili neimplementirani dokument";
        String tipFakture = this.getTip();
        int storno = this.getStorno();
        if (tipFakture.equalsIgnoreCase("FAKTURA")) {
            dokument = storno == 0 ? "Faktura" : "Storno fakture";
        } else if (tipFakture.equalsIgnoreCase("FAKTURA_TRANZITA")) {
            dokument = storno == 0 ? "Faktura tranzita" : "Storno fakture tranzita";
        } else if (tipFakture.equalsIgnoreCase("FAKTURA_IZ_SERVISA")) {
            dokument = storno == 0 ? "Faktura iz servisa" : "Storno fakture iz servisa";
        } else if (tipFakture.equalsIgnoreCase("OTPREMNICA")) {
            dokument = storno == 0 ? "Otpremnica" : "Storno otpremnice";
        } else if (tipFakture.equalsIgnoreCase("PROFAKTURA")) {
            dokument = storno == 0 ? "Profaktura" : "Storno profakture";
        } else if (tipFakture.equalsIgnoreCase("FAKTURA_INTERNI_RACUN")) {
            dokument = storno == 0 ? "Interni ra\u010dun" : "Storno internog ra\u010duna";
        } else if (tipFakture.equalsIgnoreCase("PRENOSNICA_SA_KONSIGNACIJE")) {
            dokument = storno == 0 ? "Prenosnica" : "Storno prenosnice";
        } else if (tipFakture.equalsIgnoreCase("AVANSNI_RACUN")) {
            dokument = storno == 0 ? "Avansni ra\u010dun" : "Storno avansnog ra\u010duna";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        String datum = formatter.format((Object)this.getDatum());
        String brFakture = this.getOznDokumenta();
        String opis = String.format("%s: %s od %s", dokument, brFakture, datum);
        return opis;
    }

    @Override
    public void setOpis(String opis) {
    }

    public String getLokacijaIsporuke() {
        return this.getFakturaParameterValue("LOKACIJA_KOMITENTA");
    }

    @Override
    public List<? extends PzTaksaDokument> getTaksadokuments() {
        return this.getTaksafakturas();
    }

    @Override
    public void adjust() throws Exception {
        Iterator<PzEntity> i;
        if (this.getArtikalfakturas() != null) {
            for (Artikalfaktura af : this.getArtikalfakturas()) {
                af.getId().setIdDok(this.getIdDok());
                if (af.getAftaksas() != null) {
                    for (Aftaksa taksa : af.getAftaksas()) {
                        taksa.getId().setIdDok(this.getIdDok());
                        taksa.getId().setrBroj(af.getId().getrBroj());
                    }
                }
                if (af.getArtikalFakturaParameters() == null) continue;
                for (Artikalfakturaparameter param : af.getArtikalFakturaParameters()) {
                    param.getId().setIdDok(this.getIdDok());
                    param.getId().setrBroj(af.getId().getrBroj());
                }
            }
            if (!(this.tip.equals("AVANSNI_RACUN") && this.podTip.equals("AVANSNI_RACUN_IZNOS") || this.tip.equals("FAKTURA_IZ_SERVISA"))) {
                this.setIznos(this.getIznosDokumenta());
                this.setIznosBezPoreza(this.izMaloprodaje() ? this.getIznosBezPorezaMaloprodaja(this.artikalfakturas) : this.getIznosBezPorezaVeleprodaja(this.artikalfakturas));
                this.setRabatUkupno(this.getRabat());
                this.setNabavnaUkupno(this.getNabavnaVrednost(this.artikalfakturas));
            }
        }
        if (this.getTaksafakturas() != null) {
            i = this.getTaksafakturas().iterator();
            while (i.hasNext()) {
                ((Taksafaktura)i.next()).getId().setIdDok(this.getIdDok());
            }
        }
        if (this.getFakturaparameters() != null) {
            i = this.getFakturaparameters().iterator();
            while (i.hasNext()) {
                ((Fakturaparameter)i.next()).getId().setIdDok(this.getIdDok());
            }
        }
        if (this.getStavkaporudzbines() != null) {
            i = this.getStavkaporudzbines().iterator();
            while (i.hasNext()) {
                ((Stavkaporudzbine)i.next()).getId().setIdDok(this.getIdDok());
            }
        }
    }

    @Override
    public void setOriginal(PzDokument original) {
        this.original = (Faktura)original;
    }

    @Override
    public PzTaksaDokument createEmptyTaksaDokument(String oznTarGr, String tip) {
        return new Taksafaktura(this.idDok, tip, oznTarGr);
    }

    @Override
    public boolean obracunavaSePorez(Tarifnagrupa tg, String tip) {
        if (tg.getGrupaPDV().startsWith("SS")) {
            return false;
        }
        if (tg.getVrstatg().getOznVrstaTG().equals("AKC")) {
            return true;
        }
        if (tg.getVrstatg().getOznVrstaTG().equals("PDV")) {
            return this.saPorezom == 1;
        }
        return true;
    }

    @Override
    public void setTaksadokuments(List<? extends PzTaksaDokument> taksaDokuments) {
        this.taksafakturas = taksaDokuments;
    }

    @Override
    public BigDecimal getDug() {
        return this.getIznos().subtract(this.getUplata()).subtract(this.getStornoIznos());
    }

    @Override
    public void setArtikalDokuments(List<? extends PzArtikalDokument> list) {
        this.artikalfakturas = list;
    }

    public boolean potrebanNalog() {
        return this.getTip().equals(TipDokumentConfig.get().FAKTURA) || this.getTip().equals(TipDokumentConfig.get().OTPREMNICA);
    }

    public void izracunajIznosSaIBezPoreza() {
        if (this.izMaloprodaje()) {
            this.iznos = this.getIznosBezPorezaVeleprodaja(this.getArtikalfakturas());
            this.iznosBezPoreza = this.getIznosBezPorezaMaloprodaja(this.getArtikalfakturas());
        } else {
            this.iznos = this.getIznosSaPorezomVeleprodaja(this.getArtikalfakturas());
            this.iznosBezPoreza = this.getIznosBezPorezaVeleprodaja(this.getArtikalfakturas());
        }
    }

    public RadniNalog getRadninalog() {
        return this.radninalog;
    }

    public void setRadninalog(RadniNalog radninalog) {
        this.radninalog = radninalog;
    }

    public List<Fakturaparameter> getFakturaparameters() {
        return this.fakturaparameters;
    }

    public void setFakturaparameters(List<Fakturaparameter> fakturaparameters) {
        this.fakturaparameters = fakturaparameters;
    }

    public void addFakturaparameter(Fakturaparameter fp) {
        if (this.getFakturaparameters() == null) {
            this.setFakturaparameters(new Vector<Fakturaparameter>());
        }
        this.getFakturaparameters().add(fp);
    }

    public Fakturaparameter getFakturaparameter(int iddok, String name) {
        for (Fakturaparameter f : this.getFakturaparameters()) {
            if (f.getId().getIdDok() != iddok || !f.getId().getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public void removeFakturaparameter(int iddok, String name) {
        Fakturaparameter f = null;
        Iterator<Fakturaparameter> iterator = this.getFakturaparameters().iterator();
        while (iterator.hasNext() && f == null) {
            Fakturaparameter t = iterator.next();
            if (t.getId().getIdDok() != iddok || !t.getId().getName().equals(name)) continue;
            f = t;
        }
        if (f != null) {
            this.getFakturaparameters().remove(f);
        }
    }

    public String getFakturaParameterValue(String name) {
        String val = "";
        if (this.getFakturaparameters() != null && this.getFakturaparameters().size() > 0) {
            for (Fakturaparameter f : this.getFakturaparameters()) {
                if (!f.getId().getName().equals(name)) continue;
                val = f.getValue();
                break;
            }
        }
        return val;
    }

    public void setIznosi() {
        if (this.izMaloprodaje()) {
            this.setIznos(this.saPorezom == 1 ? this.getIznosBezPorezaVeleprodaja(this.artikalfakturas) : this.getIznosBezPorezaMaloprodaja(this.artikalfakturas));
            this.setIznosBezPoreza(this.getIznosBezPorezaMaloprodaja(this.artikalfakturas));
        } else {
            this.setIznos(this.saPorezom == 1 ? this.getIznosSaPorezomVeleprodaja(this.artikalfakturas) : this.getIznosBezPorezaVeleprodaja(this.artikalfakturas));
            this.setIznosBezPoreza(this.getIznosBezPorezaVeleprodaja(this.artikalfakturas));
        }
    }
}

