/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzUslugaDokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Uftaksa;
import rs.pezar.db.entity.Uslugafaktura;

@Entity
@Table(name="FakturaServisa")
@DiscriminatorValue(value="FAKTURA_SERVISA")
public class Fakturaservisa
extends Faktura
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BigDecimal vrednostUsluga = new BigDecimal(0);
    private String sredstvoFabrickiBroj;
    private String sredstvoKarakteristika;
    private String sredstvoNaziv;
    @OneToMany(mappedBy="fakturaservisa", cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Uslugafaktura> uslugafakturas;

    @Override
    public BigDecimal getVrednostUsluga() {
        return this.vrednostUsluga;
    }

    @Override
    public void setVrednostUsluga(BigDecimal iznosusluga) {
        this.vrednostUsluga = iznosusluga;
    }

    public String getSredstvoFabrickiBroj() {
        return this.sredstvoFabrickiBroj;
    }

    public void setSredstvoFabrickiBroj(String sredstvofabrickibroj) {
        this.sredstvoFabrickiBroj = sredstvofabrickibroj;
    }

    public String getSredstvoKarakteristika() {
        return this.sredstvoKarakteristika;
    }

    public void setSredstvoKarakteristika(String sredstvokarakteristika) {
        this.sredstvoKarakteristika = sredstvokarakteristika;
    }

    public String getSredstvoNaziv() {
        return this.sredstvoNaziv;
    }

    public void setSredstvoNaziv(String sredstvonaziv) {
        this.sredstvoNaziv = sredstvonaziv;
    }

    public List<Uslugafaktura> getUslugafakturas() {
        return this.uslugafakturas;
    }

    public void setUslugafakturas(List<Uslugafaktura> uslugafakturas) {
        this.uslugafakturas = uslugafakturas;
    }

    @Override
    public List<? extends PzUslugaDokument> getUslugaDocuments() {
        return this.getUslugafakturas();
    }

    public BigDecimal getIznosUslugaBezPoreza() {
        BigDecimal rez = new BigDecimal(0);
        if (this.uslugafakturas != null) {
            for (Uslugafaktura uf : this.uslugafakturas) {
                BigDecimal cena = BDConverter.getIznos(uf.getCena());
                BigDecimal kolicina = BDConverter.getKolicina(uf.getKolicina());
                BigDecimal vrednost = BDConverter.getIznos(cena.multiply(kolicina));
                rez = rez.add(vrednost);
            }
        }
        return rez;
    }

    public BigDecimal getIznosUslugaSaPorezom() {
        BigDecimal rez = new BigDecimal(0);
        if (this.uslugafakturas != null) {
            for (Uslugafaktura uf : this.uslugafakturas) {
                BigDecimal cena = BDConverter.getIznos(uf.getCena());
                BigDecimal kolicina = BDConverter.getKolicina(uf.getKolicina());
                BigDecimal osnovica = BDConverter.getIznos(cena.multiply(kolicina));
                BigDecimal stopaPDV100 = BDConverter.getStopaPDVProc(uf.getUsluga().getTarifnaGrupa("PDV").getStopa());
                BigDecimal iznosPDVa = BDConverter.getIznos(osnovica.multiply(stopaPDV100));
                BigDecimal ukupno = BDConverter.getIznos(osnovica.add(iznosPDVa));
                rez = rez.add(ukupno);
            }
        }
        return rez;
    }

    public Uslugafaktura getUsluga(String sfrUsluga) {
        for (Uslugafaktura uf : this.uslugafakturas) {
            if (uf.getUsluga() == null || !uf.getUsluga().getSfrProizvod().equals(sfrUsluga)) continue;
            return uf;
        }
        return null;
    }

    @Override
    public void adjust() throws Exception {
        if (this.getUslugafakturas() != null) {
            for (Uslugafaktura uf : this.getUslugafakturas()) {
                uf.getId().setIdDok(this.getIdDok());
                if (uf.getUftaksas() == null) continue;
                for (Uftaksa taksa : uf.getUftaksas()) {
                    taksa.getId().setIdDok(this.getIdDok());
                    taksa.getId().setrBroj(uf.getId().getrBroj());
                }
            }
        }
        this.setVrednostUsluga(this.getIznosUslugaBezPoreza());
        if (this.getSaPorezom() == 0) {
            this.setIznos(this.getIznosBezPorezaVeleprodaja(this.getArtikalfakturas()).add(this.getIznosUslugaBezPoreza()));
            this.setIznosBezPoreza(this.getIznos());
        } else {
            this.setIznosBezPoreza(this.izMaloprodaje() ? this.getIznosBezPorezaMaloprodaja(this.getArtikalfakturas()).add(this.getIznosUslugaBezPoreza()) : this.getIznosBezPorezaVeleprodaja(this.getArtikalfakturas()).add(this.getIznosUslugaBezPoreza()));
            this.setIznos(this.getIznosSaPorezomVeleprodaja(this.getArtikalfakturas()).add(this.getIznosUslugaSaPorezom()));
        }
        this.setNabavnaUkupno(this.getNabavnaVrednost(this.getArtikalfakturas()));
        super.adjust();
    }

    @Override
    public String getVrsta() {
        return "I";
    }
}

