/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.LokacijaPK;
import rs.pezar.db.entity.Radnajedinica;

@Entity
@Table(name="Lokacija")
public class Lokacija
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private LokacijaPK id;
    @Column(nullable=false, length=20)
    private String nivo;
    @Column(nullable=false, length=20)
    private String paleta;
    @Column(nullable=false, length=20)
    private String stalaza;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK", nullable=false, insertable=false, updatable=false), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ", nullable=false, insertable=false, updatable=false)})
    private Radnajedinica radnajedinica;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinColumn(name="sfrProizvod", nullable=false, insertable=false, updatable=false)
    private Artikal artikal;

    public Lokacija() {
    }

    public Lokacija(Artikal artikal, Radnajedinica rj) {
        this.id = new LokacijaPK();
        this.id.setOznOgranak(rj.getId().getOznOgranak());
        this.id.setOznRj(rj.getId().getOznRj());
        this.id.setSfrProizvod(artikal.getSfrProizvod());
        this.setArtikal(artikal);
        this.setRadnajedinica(rj);
    }

    public LokacijaPK getId() {
        return this.id;
    }

    public void setId(LokacijaPK id) {
        this.id = id;
    }

    public String getNivo() {
        return this.nivo;
    }

    public void setNivo(String nivo) {
        this.nivo = nivo;
    }

    public String getPaleta() {
        return this.paleta;
    }

    public void setPaleta(String paleta) {
        this.paleta = paleta;
    }

    public String getStalaza() {
        return this.stalaza;
    }

    public void setStalaza(String stalaza) {
        this.stalaza = stalaza;
    }

    public Radnajedinica getRadnajedinica() {
        return this.radnajedinica;
    }

    public void setRadnajedinica(Radnajedinica radnajedinica) {
        this.radnajedinica = radnajedinica;
    }

    public Artikal getArtikal() {
        return this.artikal;
    }

    public void setArtikal(Artikal artikal) {
        this.artikal = artikal;
    }

    @Override
    public String[] getColumnNames() {
        return null;
    }

    @Override
    public Object[] getValues() {
        return null;
    }
}

