/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.entity.Artikalneispravnaisporuka;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Opstidokument;

@Entity
@DiscriminatorValue(value="NEISPRAVNA_ISPORUKA")
public class NeispravnaIsporuka
extends Opstidokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="str1")
    private String oznakaKalkulacije;
    @Column(name="int1")
    private int brojKalkulacije;
    @Column(name="date1")
    private Date datumKalkulacije;
    @OneToMany(mappedBy="neispravnaisporuka", cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    @PrivateOwned
    private List<Artikalneispravnaisporuka> artikalneispravnaisporukas;

    public Artikalopstidokument getArtikal(String sfrA) {
        for (Artikalopstidokument af : this.getArtikalopstidokuments()) {
            if (!af.getId().getSfrProizvod().equals(sfrA)) continue;
            return af;
        }
        return null;
    }

    public String getOznakaKalkulacije() {
        return this.oznakaKalkulacije;
    }

    public void setOznakaKalkulacije(String oznakaKalkulacije) {
        this.oznakaKalkulacije = oznakaKalkulacije;
    }

    public int getBrojKalkulacije() {
        return this.brojKalkulacije;
    }

    public void setBrojKalkulacije(int brojKalkulacije) {
        this.brojKalkulacije = brojKalkulacije;
    }

    public Date getDatumKalkulacije() {
        return this.datumKalkulacije;
    }

    public void setDatumKalkulacije(Date datumKalkulacije) {
        this.datumKalkulacije = datumKalkulacije;
    }

    public List<Artikalneispravnaisporuka> getArtikalneispravnaisporukas() {
        return this.artikalneispravnaisporukas;
    }

    public void setArtikalneispravnaisporukas(List<Artikalneispravnaisporuka> artikalneispravnaisporukas) {
        this.artikalneispravnaisporukas = artikalneispravnaisporukas;
    }

    @Override
    public void adjust() {
        this.setIznos(new BigDecimal("0.00"));
        if (this.getArtikalopstidokuments() != null) {
            for (Artikalopstidokument aod : this.getArtikalopstidokuments()) {
                BigDecimal kolicina = BDConverter.getKolicina(aod.getKolicina());
                this.setIznos(this.getIznos().add(BDConverter.getIznos(aod.getProdCena().multiply(kolicina))));
            }
        }
    }

    @Override
    public String getVrsta() {
        return "I";
    }
}

