/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityExtended;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Antaksa;
import rs.pezar.db.entity.Artikalnivelacija;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Taksanivelacija;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.util.PzDateUtility;

@Entity
@Table(name="Nivelacija")
public class Nivelacija
extends PzDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false)
    private int idDok;
    @Column(nullable=false)
    private short arhiviran;
    @Column(nullable=false)
    private short cvProdajna;
    private Date datArh;
    @Column(nullable=false)
    private Date datum;
    @Column(nullable=false)
    private BigDecimal novaVrednost = new BigDecimal(0);
    @Column(nullable=false)
    private BigDecimal staraVrednost = new BigDecimal(0);
    @Column(length=30)
    private String oznDokumenta;
    @Column(length=30)
    private String podTip;
    @Column(nullable=false)
    private short proknjizen;
    @Column(nullable=false)
    private int rbrDok;
    @Column(nullable=false)
    private int rBroj;
    @Column(nullable=false, length=40)
    private String tip;
    @Column(length=5000)
    private String poruka;
    private int podok;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Dokument dokument;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK", nullable=false), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ", nullable=false)})
    private Radnajedinica radnajedinica;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamepoc", nullable=false)
    private Pzuser userPoc;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamekraj", nullable=false)
    private Pzuser userKraj;
    @OneToMany(mappedBy="nivelacija", cascade={CascadeType.ALL})
    @OrderBy(value="sort ASC")
    private List<Artikalnivelacija> artikalnivelacijas;
    @OneToMany(mappedBy="nivelacija", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Taksanivelacija> taksanivelacijas;

    @Override
    public int getIdDok() {
        return this.idDok;
    }

    @Override
    public void setIdDok(int idDok) {
        this.idDok = idDok;
    }

    @Override
    public short getArhiviran() {
        return this.arhiviran;
    }

    @Override
    public void setArhiviran(short arhiviran) {
        this.arhiviran = arhiviran;
    }

    @Override
    public void setCvProdajna(short cvProdajna) {
        this.cvProdajna = cvProdajna;
    }

    @Override
    public short getCvProdajna() {
        return this.cvProdajna;
    }

    @Override
    public Date getDatArh() {
        return this.datArh;
    }

    @Override
    public void setDatArh(Date datArh) {
        this.datArh = datArh;
    }

    @Override
    public Date getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Date datum) {
        this.datum = datum;
    }

    public BigDecimal getNovaVrednost() {
        return this.novaVrednost;
    }

    public void setNovaVrednost(BigDecimal novaVrednost) {
        this.novaVrednost = novaVrednost;
    }

    public BigDecimal getStaraVrednost() {
        return this.staraVrednost;
    }

    public void setStaraVrednost(BigDecimal staravrednost) {
        this.staraVrednost = staravrednost;
    }

    @Override
    public String getPodTip() {
        return this.podTip;
    }

    @Override
    public void setPodTip(String podTip) {
        this.podTip = podTip;
    }

    @Override
    public short getProknjizen() {
        return this.proknjizen;
    }

    @Override
    public void setProknjizen(short proknjizen) {
        this.proknjizen = proknjizen;
    }

    @Override
    public int getRbrDok() {
        return this.rbrDok;
    }

    @Override
    public void setRbrDok(int rbrDok) {
        this.rbrDok = rbrDok;
    }

    @Override
    public int getrBroj() {
        return this.rBroj;
    }

    @Override
    public void setrBroj(int rBroj) {
        this.rBroj = rBroj;
    }

    @Override
    public String getTip() {
        return this.tip;
    }

    @Override
    public void setTip(String tip) {
        this.tip = tip;
    }

    @Override
    public Dokument getDokument() {
        return this.dokument;
    }

    @Override
    public void setDokument(Dokument dokument) {
        this.dokument = dokument;
    }

    @Override
    public Radnajedinica getRadnajedinica() {
        return this.radnajedinica;
    }

    @Override
    public void setRadnajedinica(Radnajedinica radnajedinica) {
        this.radnajedinica = radnajedinica;
    }

    @Override
    public Pzuser getUserPoc() {
        return this.userPoc;
    }

    @Override
    public void setUserPoc(Pzuser pzuser) {
        this.userPoc = pzuser;
    }

    @Override
    public Pzuser getUserKraj() {
        return this.userKraj;
    }

    @Override
    public void setUserKraj(Pzuser pzuser) {
        this.userKraj = pzuser;
    }

    @Override
    public String getVrsta() {
        return "L";
    }

    @Override
    public void setVrsta(String vrsta) {
    }

    public List<Artikalnivelacija> getArtikalnivelacijas() {
        return this.artikalnivelacijas;
    }

    public void setArtikalnivelacijas(List<Artikalnivelacija> artikalnivelacijas) {
        this.artikalnivelacijas = artikalnivelacijas;
    }

    public List<Taksanivelacija> getTaksanivelacijas() {
        return this.taksanivelacijas;
    }

    public void setTaksanivelacijas(List<Taksanivelacija> taksanivelacijas) {
        this.taksanivelacijas = taksanivelacijas;
    }

    public String getPoruka() {
        return this.poruka;
    }

    public void setPoruka(String poruka) {
        this.poruka = poruka;
    }

    @Override
    public String[] getDokColumnNames() {
        if (this.getRadnajedinica().getgTip().equals("V")) {
            return new String[]{"Nivelacija", "Datum", "NZK", "Stara vrednost", "Nova vrednost", "Razlika u ceni", "ID"};
        }
        return new String[]{"Nivelacija", "Datum", "NZK", "Stara vrednost", "Nova vrednost", "Razlika u ceni", "Porez na razl.", "Razl.bez poreza", "ID"};
    }

    @Override
    public Object[] getDokValues() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[0];
    }

    @Override
    public Object[] getValues() {
        return new Object[0];
    }

    public BigDecimal getNovaVrednost1() {
        BigDecimal novaVrednost = new BigDecimal("0");
        for (Artikalnivelacija arniv : this.artikalnivelacijas) {
            novaVrednost = novaVrednost.multiply(new BigDecimal(arniv.getCenaNova() * arniv.getKolicina()));
        }
        return novaVrednost;
    }

    @Override
    public Object[] getKValues(byte type) {
        return null;
    }

    @Override
    public String getOznDokumenta() {
        return this.oznDokumenta;
    }

    @Override
    public void setOznDokumenta(String oznDokumenta) {
        this.oznDokumenta = oznDokumenta;
    }

    @Override
    public void formirajOznaku() {
        this.oznDokumenta = "NIV-" + PzEntityUtil.strZero(this.radnajedinica.getId().getOznRj(), 4) + "-" + PzEntityUtil.strZero("" + this.rBroj, 5) + "/" + PzDateUtility.getCurrentYear();
    }

    public void setId(int id) {
        this.idDok = id;
    }

    public int getId() {
        return this.idDok;
    }

    @Override
    public int getStorno() {
        return 0;
    }

    @Override
    public void setStorno(int storno) {
    }

    @Override
    public List<? extends PzArtikalDokument> getArtikalDocuments() {
        return this.artikalnivelacijas;
    }

    @Override
    public BigDecimal getIznos() {
        return null;
    }

    @Override
    public Komitent getKomitent() {
        return null;
    }

    @Override
    public void setIznos(BigDecimal iznos) {
    }

    @Override
    public void setKomitent(Komitent komitent) {
    }

    @Override
    public String getOpis() {
        return TipDokumentConfig.getNameByValue(this.getTip(), null);
    }

    @Override
    public void setOpis(String opis) {
    }

    @Override
    public void adjust() throws Exception {
        this.staraVrednost = new BigDecimal(0);
        if (this.getArtikalnivelacijas() != null) {
            for (Artikalnivelacija artniv : this.getArtikalnivelacijas()) {
                this.staraVrednost = this.staraVrednost.add(BDConverter.getIznos(BDConverter.getProdCena(artniv.getCenaStara()).multiply(BDConverter.getKolicina(artniv.getKolicina()))));
                artniv.getId().setIdDok(this.idDok);
                if (!this.getPodTip().equals(TipDokumentConfig.get().PODTIP_NIVELACIJA_VREDNOSNA) && this.radnajedinica.getNacinVodjenja().equals("PRODAJNA")) {
                    artniv.setVrednost(BDConverter.getIznos(artniv.getKolicina() * (artniv.getCenaNova() - artniv.getCenaStara())));
                }
                if (artniv.getAntaksas() == null) continue;
                for (Antaksa at : artniv.getAntaksas()) {
                    at.getId().setIdDok(this.idDok);
                }
            }
        }
        if (this.getTaksanivelacijas() != null) {
            Iterator<PzEntityExtended> i = this.getTaksanivelacijas().iterator();
            while (i.hasNext()) {
                ((Taksanivelacija)i.next()).getId().setIdDok(this.getIdDok());
            }
        }
    }

    @Override
    public Date getDatValute() {
        return null;
    }

    @Override
    public void setDatValute(Date datum) {
    }

    @Override
    public BigDecimal getStornoIznos() {
        return null;
    }

    @Override
    public void setStornoIznos(BigDecimal iznos) {
    }

    public int getPodok() {
        return this.podok;
    }

    public void setPodok(int podok) {
        this.podok = podok;
    }

    @Override
    public PzTaksaDokument createEmptyTaksaDokument(String oznTarGr, String tip) {
        return new Taksanivelacija(this.idDok, tip, oznTarGr);
    }

    @Override
    public void setTaksadokuments(List<? extends PzTaksaDokument> taksaDokuments) {
        this.taksanivelacijas = taksaDokuments;
    }

    @Override
    public List<? extends PzTaksaDokument> getTaksadokuments() {
        return this.taksanivelacijas;
    }

    @Override
    public boolean obracunavaSePorez(Tarifnagrupa tg, String tip) {
        return this.getRadnajedinica().getgTip().equals("E") && tg.getVrstatg().getOznVrstaTG().equals("PDV");
    }

    @Override
    public void izracunajVrednostRobe() {
    }

    @Override
    public Date getDatPrometa() {
        return this.datum;
    }

    @Override
    public void setArtikalDokuments(List<? extends PzArtikalDokument> list) {
        this.artikalnivelacijas = list;
    }

    public void sumVrednost() {
        BigDecimal vred = new BigDecimal(0);
        for (Artikalnivelacija artN : this.artikalnivelacijas) {
            vred = vred.add(artN.getVrednost());
        }
        this.novaVrednost = vred;
    }
}

