/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Dtaksa;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.TaksaTrosak;
import rs.pezar.db.entity.Taksafaktura;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Tgkonto;
import rs.pezar.db.entity.Usluga;
import rs.pezar.db.entity.Vrstatg;

@Entity
@Table(name="TarifnaGrupa")
public class Tarifnagrupa
implements PzEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false, length=255)
    private String oznTarGr;
    @Column(nullable=false, length=255)
    private String grupaPDV;
    @Column(nullable=false)
    private int porezNaUsluge;
    @Column(nullable=false, length=255)
    private String sfrTarGr;
    @Column(nullable=false)
    private double stopa;
    @Column(nullable=false, length=255)
    private String uplRacun;
    @OneToMany(mappedBy="tarifnagrupa")
    private List<Taksafaktura> taksafakturas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oznVrstaTG", nullable=false)
    private Vrstatg vrstatg;
    @OneToMany(mappedBy="tarifnagrupa", cascade={CascadeType.ALL})
    private List<Tgkonto> tgkontos;
    @ManyToMany(mappedBy="tarifnagrupas", fetch=FetchType.LAZY)
    private List<Artikal> artikals;
    @ManyToMany(mappedBy="tarifnagrupas", fetch=FetchType.LAZY)
    private List<Usluga> uslugas;
    @OneToMany(mappedBy="tarifnagrupa", fetch=FetchType.LAZY)
    private List<Dtaksa> dtaksas;
    @OneToMany(mappedBy="tarifnagrupa", fetch=FetchType.LAZY)
    private List<Taksakalkulacija> pdvkalkulacijas;
    @OneToMany(mappedBy="tarifnaGrupa")
    private List<TaksaTrosak> taksaTrosaks;

    public Tarifnagrupa() {
    }

    public Tarifnagrupa(String oznTarGr, Vrstatg vrstatg, String grupaPDV, short porezNaUsluge, String sfrTarGr, double stopa, String uplRacun, Konto kontoMaloprodaja, Konto kontoDobZemlja, Konto kontoDobIno, Konto kontoProdaja, Konto kontoDatiAvansi, Konto kontoPrimAvansi, Konto kontoKupiZaSebe) {
        this.oznTarGr = oznTarGr;
        this.grupaPDV = grupaPDV;
        this.porezNaUsluge = porezNaUsluge;
        this.sfrTarGr = sfrTarGr;
        this.stopa = stopa;
        this.uplRacun = uplRacun;
        this.vrstatg = vrstatg;
        this.setTgkontos((List<Tgkonto>)new IndirectList());
        this.tgkontos.add(new Tgkonto(kontoMaloprodaja, "maloprodaja", this));
        this.tgkontos.add(new Tgkonto(kontoDobZemlja, "dob_zemlja", this));
        this.tgkontos.add(new Tgkonto(kontoDobIno, "dob_ino", this));
        this.tgkontos.add(new Tgkonto(kontoProdaja, "prodaja", this));
        this.tgkontos.add(new Tgkonto(kontoDatiAvansi, "dati_avansi", this));
        this.tgkontos.add(new Tgkonto(kontoPrimAvansi, "prim_avansi", this));
        this.tgkontos.add(new Tgkonto(kontoKupiZaSebe, "kupi_za_sebe", this));
    }

    public Tarifnagrupa(String oznTarGr, Vrstatg vrstatg, String grupaPDV, short porezNaUsluge, String sfrTarGr, double stopa, String uplRacun) {
        this.oznTarGr = oznTarGr;
        this.grupaPDV = grupaPDV;
        this.porezNaUsluge = porezNaUsluge;
        this.sfrTarGr = sfrTarGr;
        this.stopa = stopa;
        this.uplRacun = uplRacun;
        this.vrstatg = vrstatg;
    }

    public String getOznTarGr() {
        return this.oznTarGr;
    }

    public void setOznTarGr(String oznTarGr) {
        this.oznTarGr = oznTarGr;
    }

    public String getGrupaPDV() {
        return this.grupaPDV;
    }

    public void setGrupaPDV(String grupaPDV) {
        this.grupaPDV = grupaPDV;
    }

    public int getPorezNaUsluge() {
        return this.porezNaUsluge;
    }

    public void setPorezNaUsluge(int porezNaUsluge) {
        this.porezNaUsluge = porezNaUsluge;
    }

    public String getSfrTarGr() {
        return this.sfrTarGr;
    }

    public void setSfrTarGr(String sfrTarGr) {
        this.sfrTarGr = sfrTarGr;
    }

    public double getStopa() {
        return this.stopa;
    }

    public void setStopa(double stopa) {
        this.stopa = stopa;
    }

    public String getUplRacun() {
        return this.uplRacun;
    }

    public void setUplRacun(String uplRacun) {
        this.uplRacun = uplRacun;
    }

    public List<Taksafaktura> getTaksafakturas() {
        return this.taksafakturas;
    }

    public void setTaksafakturas(List<Taksafaktura> taksafakturas) {
        this.taksafakturas = taksafakturas;
    }

    public Vrstatg getVrstatg() {
        return this.vrstatg;
    }

    public void setVrstatg(Vrstatg vrstatg) {
        this.vrstatg = vrstatg;
    }

    public List<Tgkonto> getTgkontos() {
        return this.tgkontos;
    }

    public void setTgkontos(List<Tgkonto> tgkontos) {
        this.tgkontos = tgkontos;
    }

    public List<Artikal> getArtikals() {
        return this.artikals;
    }

    public void setArtikals(List<Artikal> artikals) {
        this.artikals = artikals;
    }

    public List<Usluga> getUslugas() {
        return this.uslugas;
    }

    public void setUslugas(List<Usluga> uslugas) {
        this.uslugas = uslugas;
    }

    public List<Dtaksa> getDtaksas() {
        return this.dtaksas;
    }

    public void setDtaksas(List<Dtaksa> dtaksas) {
        this.dtaksas = dtaksas;
    }

    public List<Taksakalkulacija> getPdvkalkulacijas() {
        return this.pdvkalkulacijas;
    }

    public void setPdvkalkulacijas(List<Taksakalkulacija> pdvkalkulacijas) {
        this.pdvkalkulacijas = pdvkalkulacijas;
    }

    public void setTaksaTrosaks(List<TaksaTrosak> taksaTrosaks) {
        this.taksaTrosaks = taksaTrosaks;
    }

    public List<TaksaTrosak> getTaksaTrosaks() {
        return this.taksaTrosaks;
    }

    public Konto getKonto(String tip) {
        Konto result = null;
        for (Tgkonto tk : this.tgkontos) {
            if (!tk.getId().getVrsta().equals(tip)) continue;
            result = tk.getKonto();
            break;
        }
        return result;
    }

    public Tgkonto getTgKonto(String tip) {
        Tgkonto result = null;
        for (Tgkonto tk : this.tgkontos) {
            if (!tk.getId().getVrsta().equals(tip)) continue;
            result = tk;
            break;
        }
        return result;
    }

    private String getOznKonto(String tip) {
        String result = null;
        for (Tgkonto tk : this.tgkontos) {
            if (!tk.getId().getVrsta().equals(tip)) continue;
            result = tk.getKonto().getId().getOznKonto();
            break;
        }
        return result;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Oznaka", "Stopa", "Upl. ra\u010dun", "\u0160ifra"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.oznTarGr, this.stopa, this.uplRacun, this.sfrTarGr};
    }

    public void addOrUpdateKonto(Tgkonto tgkonto) {
        boolean found = false;
        for (Tgkonto tk : this.tgkontos) {
            if (!tk.getId().equals(tgkonto.getId())) continue;
            tk.setKonto(tgkonto.getKonto());
            found = true;
        }
        if (!found) {
            this.tgkontos.add(tgkonto);
        }
    }
}

