/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Taksakalkulacija;

@Entity
@DiscriminatorValue(value="TROSAK")
public class Trosak
extends Kalkulacija
implements Serializable {
    public static String TIP_INTERNI = "INTERNI";
    public static String TIP_EKSTERNI = "EKSTERNI";
    public static String TIP_CARINA = "CARINA";
    public static String TIP_EKO_TAKSA = "EKO";
    private static final long serialVersionUID = 1L;
    @Column(nullable=false)
    private BigDecimal bezPrava = new BigDecimal(0);
    @Column(nullable=false)
    private BigDecimal oslobodjeno = new BigDecimal(0);
    @Column(nullable=false)
    private BigDecimal osnovica = new BigDecimal(0);
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Dokument dokument;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idKalkulacija", nullable=false)
    private Kalkulacija kalkulacija;

    public BigDecimal getBezPrava() {
        return this.bezPrava;
    }

    public void setBezPrava(BigDecimal bezPrava) {
        this.bezPrava = bezPrava;
    }

    public BigDecimal getOslobodjeno() {
        return this.oslobodjeno;
    }

    public void setOslobodjeno(BigDecimal oslobodjeno) {
        this.oslobodjeno = oslobodjeno;
    }

    public BigDecimal getOsnovica() {
        return this.osnovica;
    }

    public void setOsnovica(BigDecimal osnovica) {
        this.osnovica = osnovica;
    }

    @Override
    public Dokument getDokument() {
        return this.dokument;
    }

    @Override
    public void setDokument(Dokument dokument) {
        this.dokument = dokument;
    }

    public Kalkulacija getKalkulacija() {
        return this.kalkulacija;
    }

    public void setKalkulacija(Kalkulacija kalkulacija) {
        this.kalkulacija = kalkulacija;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Tip", "Ozn. dokumenta", "\u0160if. dobavlja\u010da", "Osnovica", "PDV", "Bez prava", "Oslobo\u0111eno", "Dat. dokumenta", "Dat. DPO", "Dat. valute"};
    }

    @Override
    public Object[] getValues() {
        BigDecimal suma = new BigDecimal("0");
        if (this.getTaksakalkulacijas() != null) {
            for (Taksakalkulacija tk : this.getTaksakalkulacijas()) {
                if (this.getIdDok() != tk.getId().getIdDok()) continue;
                suma = suma.add(tk.getIznos());
            }
        }
        return new Object[]{this.getPodTip(), this.getOznDokumenta(), this.getKomitent() != null ? this.getKomitent().getSfrKomitent() : null, this.getOsnovica(), suma, this.getBezPrava(), this.getOslobodjeno(), this.getDatFakture(), this.getDatDPO(), this.getDatValute()};
    }

    @Override
    public String[] getDokColumnNames() {
        return null;
    }

    @Override
    public Object[] getDokValues() {
        return null;
    }

    @Override
    public void setrBroj(int rBroj) {
    }

    @Override
    public int getrBroj() {
        return 0;
    }

    @Override
    public void setRbrDok(int rbrdok) {
    }

    @Override
    public int getRbrDok() {
        return 0;
    }

    @Override
    public void formirajOznaku() {
    }

    @Override
    public void setStorno(int storno) {
        super.setStorno(storno);
    }

    @Override
    public String getOpis() {
        return "Troskovi " + this.getPodTip() + " uz kalkulaciju " + this.getKalkulacija().getrBroj() + " iz RJ [" + this.kalkulacija.getRadnajedinica().getId().getOznRj() + "] " + this.kalkulacija.getRadnajedinica().getNaziv();
    }

    @Override
    public void setOpis(String opis) {
    }

    @Override
    public List<? extends PzArtikalDokument> getArtikalDocuments() {
        return null;
    }

    @Override
    public void setVrsta(String vrsta) {
    }

    @Override
    public String getVrsta() {
        return "U";
    }

    @Override
    public PzTaksaDokument createEmptyTaksaDokument(String oznTarGr, String tip) {
        return new Taksakalkulacija();
    }

    @Override
    public BigDecimal getDug() {
        return this.getIznos().subtract(this.getStornoIznos()).subtract(this.getUplata());
    }
}

