/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.UdtaksaPK;
import rs.pezar.db.entity.Uslugadokument;

@Entity
@Table(name="UDTaksa")
public class Udtaksa
extends PzADTaksa
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private UdtaksaPK id;
    @Column(nullable=false, length=255)
    private String opis;
    @Column(nullable=false, length=20)
    private String oznVrstaTG;
    @Column(nullable=false)
    private double stopa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="idDok", referencedColumnName="IDDOK", nullable=false, insertable=false, updatable=false), @JoinColumn(name="rBroj", referencedColumnName="RBROJ", nullable=false, insertable=false, updatable=false)})
    private Uslugadokument uslugadokument;

    public Udtaksa() {
    }

    public Udtaksa(Uslugadokument uslugadokument, Tarifnagrupa tgr) {
        this.id = new UdtaksaPK(uslugadokument.getId().getIdDok(), tgr.getOznTarGr(), uslugadokument.getId().getrBroj());
        this.uslugadokument = uslugadokument;
        this.opis = tgr.getVrstatg().getOpis();
        this.stopa = tgr.getStopa();
        this.oznVrstaTG = tgr.getVrstatg().getOznVrstaTG();
    }

    public Udtaksa(Uslugadokument artikaldokument, PzADTaksa taksa) {
        this.id = new UdtaksaPK(artikaldokument.getId().getIdDok(), taksa.getOznTarGr(), artikaldokument.getId().getrBroj());
        this.uslugadokument = artikaldokument;
        this.opis = taksa.getOpis();
        this.oznVrstaTG = taksa.getOznVrstaTG();
        this.stopa = taksa.getStopa();
    }

    public UdtaksaPK getId() {
        return this.id;
    }

    public void setId(UdtaksaPK id) {
        this.id = id;
    }

    @Override
    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    @Override
    public String getOznVrstaTG() {
        return this.oznVrstaTG;
    }

    public void setOznVrstaTG(String oznvrstatg) {
        this.oznVrstaTG = oznvrstatg;
    }

    @Override
    public double getStopa() {
        return this.stopa;
    }

    public void setStopa(double stopa) {
        this.stopa = stopa;
    }

    public Uslugadokument getUslugadokument() {
        return this.uslugadokument;
    }

    public void setUslugadokument(Uslugadokument uslugadokument) {
        this.uslugadokument = uslugadokument;
    }

    @Override
    public String getOznTarGr() {
        return this.id.getOznTarGr();
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Oznaka TG", "Vrsta TG", "Stopa", "Opis"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.id.getOznTarGr(), this.oznVrstaTG, this.stopa, this.opis};
    }
}

