/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.TableModel;
import org.cheffo.jeplite.ParseException;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import rs.pezar.core.PzApplication;
import rs.pezar.core.log.PzLogger;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.data.models.PzAbstractTableModel;
import rs.pezar.swing.data.models.PzScrollableTableModel;
import rs.pezar.swing.event.PzTableAncestorListener;
import rs.pezar.swing.event.PzTableColumnModelListener;
import rs.pezar.swing.fields.PzCalculatedField;
import rs.pezar.swing.renderers.PzTableCellRenderer;
import rs.pezar.swing.util.PzFileUtility;
import rs.pezar.swing.util.TableExportUtil;

public abstract class PzAbstractTable
extends JXTable {
    PzCalculatedField calculatedField;
    private Vector<PzCalculatedField> cfVector;
    private String id;
    private int[] visibleColumns;
    private int[] columnWidths;
    private PzBusyPainterUI lockableUi;
    private JXLayer<PzAbstractTable> layer;
    private JPopupMenu popup;
    private boolean recalculateFieldsParam;
    protected boolean stateRestored;
    private MouseListener mouseAction;
    private PzTableColumnModelListener tableColumnModelListener;
    private static final long serialVersionUID = 1L;

    public PzAbstractTable(TableModel model) {
        super(model);
        this.initGUI();
    }

    public PzAbstractTable() {
        this.initGUI();
        this.recalculateFieldsParam = true;
        new Vector();
        this.cfVector = new Vector();
    }

    protected void initGUI() {
        try {
            this.setHorizontalScrollEnabled(true);
            this.setShowHorizontalLines(false);
            this.setColumnControlVisible(true);
            this.getTableHeader().setFont(this.getTableHeader().getFont().deriveFont(1, 12.0f));
            this.getTableHeader().setSize(this.getWidth(), 25);
            this.setSelectionMode(0);
            this.addHighlighter(HighlighterFactory.createSimpleStriping());
            this.setDefaultRenderer(Object.class, new PzTableCellRenderer(this.getDefaultRenderer(Object.class)));
            this.selectRow(0);
            this.removeMnemonics();
            this.setHomeEndAction();
            final PzAbstractTable a = this;
            this.getRowSorter().addRowSorterListener(new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent e) {
                    if (e.getType().equals((Object)RowSorterEvent.Type.SORTED)) {
                        e.getSource();
                        System.out.println(((RowSorter)e.getSource()).convertRowIndexToView(a.getSelectedRow()));
                    }
                }
            });
            this.addPopup();
            this.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
            this.addAncestorListener(new PzTableAncestorListener(this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        this.setSorting();
    }

    protected void setSorting() {
        if (this.dataModel.getRowCount() == 0 || this.getVisibleColumnCount() == 0) {
            return;
        }
        int i = 0;
        while (i < this.getColumnCount()) {
            if (this.getValueAt(0, i) instanceof Double || this.getValueAt(0, i) instanceof BigDecimal || this.getValueAt(0, i) instanceof Integer) {
                this.getColumnExt(i).setComparator((Comparator)new Comparator<Number>(){

                    @Override
                    public int compare(Number o1, Number o2) {
                        return ((Comparable)((Object)o1)).compareTo(o2);
                    }
                });
            }
            ++i;
        }
    }

    public void packColumns() {
        if (this.getModel() != null && this.getModel().getRowCount() > 0 && this.getModel().getColumnCount() > 0) {
            final PzAbstractTable instance = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    instance.packAll();
                }
            });
        }
    }

    public int[] getVisibleColumns() {
        int[] columns = new int[this.getColumnCount()];
        int j = 0;
        int i = 0;
        while (i < this.getColumnCount(true)) {
            if (this.convertColumnIndexToView(i) != -1) {
                columns[j] = i;
                ++j;
            }
            ++i;
        }
        return columns;
    }

    public void setAutoSaveTableStateEnabled(boolean arg) {
        if (this.tableColumnModelListener == null) {
            this.tableColumnModelListener = new PzTableColumnModelListener(this);
        }
        if (arg) {
            this.getTableHeader().getColumnModel().removeColumnModelListener(this.tableColumnModelListener);
            this.getTableHeader().getColumnModel().addColumnModelListener(this.tableColumnModelListener);
        } else {
            this.getTableHeader().getColumnModel().removeColumnModelListener(this.tableColumnModelListener);
        }
    }

    public void restoreState() {
        if (SwingUtilities.getRoot((Component)((Object)this)) != null && !this.stateRestored && this.getColumnCount() > 0) {
            try {
                this.setName(String.valueOf(SwingUtilities.getRoot((Component)((Object)this)).getClass().getName()) + "." + this.getId());
                String fName = String.valueOf(SwingUtilities.getRoot((Component)((Object)this)).getClass().getName()) + "." + this.getId() + ".xml";
                if (PzApplication.getApplication() != null && PzApplication.getApplication().getSession() != null && PzApplication.getApplication().getSession().getSessionStorage() != null) {
                    PzApplication.getApplication().getSession().getSessionStorage().restore((Component)((Object)this), fName);
                    System.out.println("STATE RESTORED " + fName);
                    this.setAutoSaveTableStateEnabled(true);
                    this.stateRestored = true;
                }
            }
            catch (IOException e) {
                PzLogger.getInstance().logException(e);
            }
        }
    }

    public void saveState() {
        if (SwingUtilities.getRoot((Component)((Object)this)) != null) {
            String fName = String.valueOf(SwingUtilities.getRoot((Component)((Object)this)).getClass().getName()) + "." + this.getId() + ".xml";
            if (PzApplication.getApplication() != null && PzApplication.getApplication().getSession() != null && PzApplication.getApplication().getSession().getSessionStorage() != null) {
                try {
                    PzApplication.getApplication().getSession().getSessionStorage().save((Component)((Object)this), fName);
                    System.out.println("STATE SAVED " + fName);
                }
                catch (IOException e) {
                    PzLogger.getInstance().logException(e);
                }
            }
        }
    }

    public void setVisibleColumns(int[] columns) {
        this.visibleColumns = columns;
    }

    private void removeMnemonics() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(119, 0, false), "F8");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "ENTER");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(113, 0, false), "F2");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(113, 512, false), null);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(113, 128, false), null);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0, false), "F3");
    }

    public void setEnterAction(AbstractAction action) {
        this.getActionMap().put("ENTER", action);
        this.setMouseAction(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PzAbstractTable.this.getActionMap().get("ENTER").actionPerformed(new ActionEvent((Object)PzAbstractTable.this, 123, null));
                }
            }
        });
    }

    public void setMouseAction(MouseAdapter mouseAdapter) {
        if (this.mouseAction != null) {
            this.removeMouseListener(this.mouseAction);
        }
        this.mouseAction = mouseAdapter;
        this.addMouseListener(mouseAdapter);
    }

    private MouseListener getMouseAction() {
        return this.mouseAction;
    }

    public void setHomeEndAction() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(35, 0, false), "END");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(36, 0, false), "HOME");
        this.getActionMap().put("END", new AbstractAction(){
            private static final long serialVersionUID = -1161631096221201874L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzAbstractTable.this.selectRow(PzAbstractTable.this.getRowCount() - 1);
                Rectangle rect = PzAbstractTable.this.getCellRect(PzAbstractTable.this.getRowCount() - 1, 0, true);
                PzAbstractTable.this.scrollRectToVisible(rect);
            }
        });
        this.getActionMap().put("HOME", new AbstractAction(){
            private static final long serialVersionUID = 4488746214844788476L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PzAbstractTable.this.selectRow(0);
                Rectangle rect = PzAbstractTable.this.getCellRect(0, 0, true);
                PzAbstractTable.this.scrollRectToVisible(rect);
            }
        });
    }

    private void addPopup() {
        this.popup = new JPopupMenu();
        JMenuItem xlsExportItem = new JMenuItem("Eksport u xls format");
        xlsExportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PzAbstractTable.this.export();
            }
        });
        this.popup.add(xlsExportItem);
        JMenuItem copyCellItem = new JMenuItem("Kopiraj sadr\u017eaj polja");
        copyCellItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String str = PzAbstractTable.this.getValueAt(PzAbstractTable.this.getSelectedRow(), PzAbstractTable.this.getSelectedColumn()).toString();
                PzAbstractTable.this.setClipboardContents(str);
            }
        });
        this.popup.add(copyCellItem);
        MouseAdapter popupListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PzAbstractTable.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.addMouseListener(popupListener);
    }

    protected void selectRow(int index) {
        try {
            this.setRowSelectionInterval(index, index);
            this.editCellAt(0, 0);
        }
        catch (Exception exception) {}
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        this.onSelectionChanged();
    }

    protected void onSelectionChanged() {
    }

    public void closeDialog() {
        ((JDialog)SwingUtilities.getRoot((Component)((Object)this))).dispose();
    }

    public double calculateExpression(String expression, int row) {
        double value = 0.0;
        String expression1 = expression;
        int row1 = row;
        try {
            value = ((PzAbstractTableModel)this.getModel()).calculateExpression(expression1, row1);
        }
        catch (ParseException e) {
            e.getErrorInfo();
        }
        return value;
    }

    public double sumAll(String expression) {
        if (!(this.getModel() instanceof PzAbstractTableModel) && !(this.getModel() instanceof PzScrollableTableModel)) {
            return 0.0;
        }
        double value = 0.0;
        try {
            value = ((PzAbstractTableModel)this.getModel()).sumAll(expression);
        }
        catch (ParseException e) {
            e.getErrorInfo();
        }
        return value;
    }

    public BigDecimal[] sumAll(String[] expressions) {
        if (!(this.getModel() instanceof PzAbstractTableModel) && !(this.getModel() instanceof PzScrollableTableModel)) {
            throw new IllegalArgumentException("Nepodr\u017eani tip TableModel-a");
        }
        BigDecimal[] values = new BigDecimal[expressions.length];
        try {
            values = ((PzAbstractTableModel)this.getModel()).sumAll(expressions);
        }
        catch (ParseException e) {
            e.getErrorInfo();
        }
        return values;
    }

    public double sum(int startRow, int endRow, String expression) {
        double value = 0.0;
        try {
            value = ((PzAbstractTableModel)this.getModel()).sum(startRow, endRow, expression);
        }
        catch (ParseException e) {
            e.getErrorInfo();
        }
        return value;
    }

    public PzCalculatedField createExpresionField(String expression) {
        this.calculatedField = new PzCalculatedField();
        this.calculatedField.setExpression(expression);
        this.cfVector.add(this.calculatedField);
        return this.calculatedField;
    }

    public void calculateFields() {
        String[] expressions = new String[this.cfVector.size()];
        int i = 0;
        while (i < this.cfVector.size()) {
            PzCalculatedField calculatedField = this.cfVector.get(i);
            expressions[i] = calculatedField.getExpression();
            ++i;
        }
        BigDecimal[] values = this.sumAll(expressions);
        int i2 = 0;
        while (i2 < this.cfVector.size()) {
            final PzCalculatedField calculatedField = this.cfVector.get(i2);
            final BigDecimal value = values[i2];
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    calculatedField.setVal(value);
                }
            });
            ++i2;
        }
    }

    public void autoRecalculateFields() {
        if (this.recalculateFieldsParam) {
            this.calculateFields();
        }
    }

    public void setRecalculateFieldParam(boolean param) {
        this.recalculateFieldsParam = param;
    }

    @Deprecated
    public void restoreColumns() {
        Component root = SwingUtilities.getRoot((Component)((Object)this));
        if (root != null && root instanceof PzDialog) {
            ((PzDialog)root).restoreTable(this);
        }
    }

    private boolean isIndexVisible(int index, int[] columns) {
        boolean found = false;
        int i = 0;
        while (i < columns.length) {
            if (index == columns[i]) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id != null ? this.id : "TABLE";
    }

    public void setColumnWidths(int[] widths) {
        this.columnWidths = widths;
    }

    public int[] getColumnWidths() {
        int[] widths = new int[this.getColumnCount(false)];
        int i = 0;
        while (i < this.getColumnCount(false)) {
            widths[i] = this.getColumnExt(i).getWidth();
            ++i;
        }
        return widths;
    }

    public void hideColumnByName(String name) {
        int column;
        if (this.getModel() instanceof PzAbstractTableModel && this.convertColumnIndexToView(column = ((PzAbstractTableModel)this.getModel()).getColumnIndexByName(name)) != -1) {
            this.getColumnExt(this.convertColumnIndexToView(column)).setVisible(false);
        }
    }

    public TableColumnExt getColumnByName(String name) {
        int column = ((PzAbstractTableModel)this.getModel()).getColumnIndexByName(name);
        return column != -1 ? (TableColumnExt)this.getColumns(true).get(column) : null;
    }

    public void export() {
        TableExportUtil.exportToXls((JTable)((Object)this), PzFileUtility.selectFile(new String[]{"xls"}, "Izaberite fajl za eksport podataka", (PzDialog)SwingUtilities.getRoot((Component)((Object)this)), 1), 1);
    }

    public void setClipboardContents(String aString) {
        StringSelection stringSelection = new StringSelection(aString);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
    }

    public int getRealSelectedRowIndex() {
        return this.convertRowIndexToModel(this.getSelectedRow());
    }
}

