/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.event.PzButtonPanelSelectionListener;

public class PzButtonPanel
extends PzPanel {
    private static final long serialVersionUID = 1L;
    private boolean isCyclic;
    private boolean isGroupSelectionFollowFocus;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private FocusListener fListener;
    private PzButtonPanelSelectionListener sListener;

    public PzButtonPanel() {
        this.init();
    }

    public PzButtonPanel(LayoutManager layout) {
        super(layout);
        this.init();
    }

    public PzButtonPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init();
    }

    public PzButtonPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.init();
    }

    private void addFocusListener() {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                PzButtonPanel.this.getSelectedButton().requestFocus();
            }
        });
    }

    private FocusListener getFocusListener() {
        if (this.fListener == null) {
            this.fListener = new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                }

                @Override
                public void focusGained(FocusEvent e) {
                    ((AbstractButton)e.getSource()).setSelected(true);
                    if (PzButtonPanel.this.sListener != null) {
                        PzButtonPanel.this.sListener.buttonSelected((AbstractButton)e.getSource());
                    }
                }
            };
        }
        return this.fListener;
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof AbstractButton) {
            this.buttonGroup.add((AbstractButton)comp);
            comp.addFocusListener(this.getFocusListener());
        }
        return super.add(comp);
    }

    @Override
    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        if (comp instanceof AbstractButton) {
            this.buttonGroup.add((AbstractButton)comp);
            comp.addFocusListener(this.getFocusListener());
        }
    }

    @Override
    public Component add(Component comp, int index) {
        if (comp instanceof AbstractButton) {
            this.buttonGroup.add((AbstractButton)comp);
            comp.addFocusListener(this.getFocusListener());
        }
        return super.add(comp, index);
    }

    private void init() {
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new PzButtonPanelFocusTraversalPolicy());
        ActionHandler actionHandler = new ActionHandler();
        this.registerKeyboardAction(actionHandler, "moveSelectionForward", KeyStroke.getKeyStroke(39, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionForward", KeyStroke.getKeyStroke(40, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionBackward", KeyStroke.getKeyStroke(37, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionBackward", KeyStroke.getKeyStroke(38, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionSkip", KeyStroke.getKeyStroke(9, 0), 1);
        this.setGroupSelectionFollowFocus(true);
        this.addFocusListener();
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
    }

    public boolean isGroupSelectionFollowFocus() {
        return this.isGroupSelectionFollowFocus;
    }

    public void setGroupSelectionFollowFocus(boolean groupSelectionFollowFocus) {
        this.isGroupSelectionFollowFocus = groupSelectionFollowFocus;
    }

    private static ButtonGroup getButtonGroup(AbstractButton button) {
        ButtonModel model = button.getModel();
        if (model instanceof DefaultButtonModel) {
            return ((DefaultButtonModel)model).getGroup();
        }
        return null;
    }

    public void setButtonGroup(ButtonGroup buttonGroup) {
        this.buttonGroup = buttonGroup;
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public void setSelectionListener(PzButtonPanelSelectionListener sListener) {
        this.sListener = sListener;
    }

    public PzButtonPanelSelectionListener getSelectionListener() {
        return this.sListener;
    }

    public AbstractButton getSelectedButton() {
        Component[] components = this.getComponents();
        AbstractButton result = null;
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof AbstractButton && ((AbstractButton)components[i]).isSelected()) {
                result = (AbstractButton)components[i];
            }
            ++i;
        }
        return result;
    }

    public String getSelectedButtonActionCommand() {
        Component[] components = this.getComponents();
        String result = null;
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof AbstractButton && ((AbstractButton)components[i]).isSelected()) {
                result = ((AbstractButton)components[i]).getActionCommand();
            }
            ++i;
        }
        return result;
    }

    private class ActionHandler
    implements ActionListener {
        private static final String FORWARD = "moveSelectionForward";
        private static final String BACKWARD = "moveSelectionBackward";
        private static final String SKIP = "moveSelectionSkip";

        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FocusTraversalPolicy ftp = PzButtonPanel.this.getFocusTraversalPolicy();
            if (ftp instanceof PzButtonPanelFocusTraversalPolicy) {
                Component next;
                PzButtonPanelFocusTraversalPolicy xftp = (PzButtonPanelFocusTraversalPolicy)ftp;
                String actionCommand = e.getActionCommand();
                Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                xftp.setAlternativeFocusMode(true);
                if (FORWARD.equals(actionCommand)) {
                    next = xftp.getComponentAfter(PzButtonPanel.this, fo);
                    ((AbstractButton)next).getModel().setPressed(true);
                } else if (BACKWARD.equals(actionCommand)) {
                    next = xftp.getComponentBefore(PzButtonPanel.this, fo);
                    ((AbstractButton)next).getModel().setPressed(true);
                } else if (SKIP.equals(actionCommand)) {
                    PzButtonPanel.this.requestFocus(false);
                    next = null;
                } else {
                    throw new AssertionError((Object)("Unexpected action command: " + actionCommand));
                }
                xftp.setAlternativeFocusMode(false);
                if (fo instanceof AbstractButton) {
                    AbstractButton b = (AbstractButton)fo;
                    b.getModel().setPressed(false);
                }
                if (next != null && fo instanceof AbstractButton && next instanceof AbstractButton) {
                    AbstractButton nextButton;
                    ButtonGroup group = PzButtonPanel.getButtonGroup((AbstractButton)fo);
                    if (group != PzButtonPanel.getButtonGroup(nextButton = (AbstractButton)next)) {
                        return;
                    }
                    if (PzButtonPanel.this.isGroupSelectionFollowFocus() && group != null && group.getSelection() != null && !nextButton.isSelected()) {
                        nextButton.setSelected(true);
                    }
                    next.requestFocusInWindow();
                }
            }
        }
    }

    private class PzButtonPanelFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private static final long serialVersionUID = 1L;
        private boolean isAlternativeFocusMode;

        private PzButtonPanelFocusTraversalPolicy() {
        }

        public boolean isAlternativeFocusMode() {
            return this.isAlternativeFocusMode;
        }

        public void setAlternativeFocusMode(boolean alternativeFocusMode) {
            this.isAlternativeFocusMode = alternativeFocusMode;
        }

        @Override
        protected boolean accept(Component c) {
            AbstractButton button;
            ButtonGroup group;
            if (!this.isAlternativeFocusMode() && c instanceof AbstractButton && (group = PzButtonPanel.getButtonGroup(button = (AbstractButton)c)) != null && group.getSelection() != null && !button.isSelected()) {
                return false;
            }
            return super.accept(c);
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            Component componentAfter = super.getComponentAfter(aContainer, aComponent);
            if (!this.isAlternativeFocusMode()) {
                return componentAfter;
            }
            return componentAfter == null ? this.getFirstComponent(aContainer) : componentAfter;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            Component componentBefore = super.getComponentBefore(aContainer, aComponent);
            if (!this.isAlternativeFocusMode()) {
                return componentBefore;
            }
            return componentBefore == null ? this.getLastComponent(aContainer) : componentBefore;
        }
    }
}

