/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class PzCheckBoxList
extends JList {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public PzCheckBoxList() {
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = PzCheckBoxList.this.locationToIndex(e.getPoint());
                if (index != -1) {
                    JCheckBox checkbox;
                    checkbox.setSelected(!(checkbox = (JCheckBox)PzCheckBoxList.this.getModel().getElementAt(index)).isSelected());
                    PzCheckBoxList.this.repaint();
                }
            }
        });
        this.setSelectionMode(0);
    }

    public void setSelectedAll() {
        int i = 0;
        while (i < this.getModel().getSize()) {
            JCheckBox cb = (JCheckBox)this.getModel().getElementAt(i);
            cb.setSelected(true);
            this.repaint();
            ++i;
        }
    }

    public void setDeselectAll() {
        int i = 0;
        while (i < this.getModel().getSize()) {
            JCheckBox cb = (JCheckBox)this.getModel().getElementAt(i);
            cb.setSelected(false);
            this.repaint();
            ++i;
        }
    }

    protected class CellRenderer
    implements ListCellRenderer {
        protected CellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JCheckBox checkbox = (JCheckBox)value;
            checkbox.setBackground(isSelected ? PzCheckBoxList.this.getSelectionBackground() : PzCheckBoxList.this.getBackground());
            checkbox.setForeground(isSelected ? PzCheckBoxList.this.getSelectionForeground() : PzCheckBoxList.this.getForeground());
            checkbox.setEnabled(PzCheckBoxList.this.isEnabled());
            checkbox.setFont(PzCheckBoxList.this.getFont());
            checkbox.setFocusPainted(false);
            checkbox.setBorderPainted(true);
            checkbox.setBorder(isSelected ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return checkbox;
        }
    }
}

