/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import rs.pezar.swing.PzDialog;

public class PzMenuItem
extends JMenuItem
implements Comparable {
    private static final long serialVersionUID = -6219243646022500751L;
    private ImageIcon icon;
    private String text;
    private Class<PzDialog> dialogClass;
    private Class<Action> actionClass;
    private Integer id;
    private String name;
    private String permission;

    public PzMenuItem() {
    }

    public PzMenuItem(Node node, ClassLoader loader) throws DOMException, ClassNotFoundException {
        if (node.getAttributes().getNamedItem("icon") != null) {
            this.setIcon(new ImageIcon(loader.getResource(node.getAttributes().getNamedItem("icon").getNodeValue())));
        }
        if (node.getAttributes().getNamedItem("accelerator") != null) {
            this.setMnemonicFromAction(node.getAttributes().getNamedItem("accelerator").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("text") != null) {
            this.setText(node.getAttributes().getNamedItem("text").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("id") != null) {
            this.setId(node.getAttributes().getNamedItem("id").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("permission") != null) {
            this.setPermission(node.getAttributes().getNamedItem("permission").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("class") != null) {
            this.setDialogClass(this.getDialogClass(node.getAttributes().getNamedItem("class").getNodeValue(), loader));
        } else if (node.getAttributes().getNamedItem("action") != null) {
            this.setActionClass(this.getActionClass(node.getAttributes().getNamedItem("action").getNodeValue(), loader));
        } else {
            this.setEnabled(false);
        }
    }

    private void setMnemonicFromAction(String nodeValue) {
        KeyStroke stroke = KeyStroke.getKeyStroke(nodeValue);
        this.setAccelerator(stroke);
    }

    private Class<PzDialog> getDialogClass(String nodeValue, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(nodeValue, true, loader);
    }

    private Class<Action> getActionClass(String nodeValue, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(nodeValue, true, loader);
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        super.setIcon(icon);
        this.icon = icon;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String label) {
        super.setText(label);
        this.text = label;
    }

    public Class<PzDialog> getDialogClass() {
        return this.dialogClass;
    }

    public void setDialogClass(Class<PzDialog> actionClass) {
        this.dialogClass = actionClass;
    }

    public Class<Action> getActionClass() {
        return this.actionClass;
    }

    public void setActionClass(Class<Action> actionClass) {
        this.actionClass = actionClass;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = Integer.parseInt(id);
    }

    public int compareTo(Object arg0) {
        return this.getId().compareTo(((PzMenuItem)arg0).getId());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }
}

