/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.custom;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.custom.PzDialogPorez;
import rs.pezar.swing.fields.PzDoubleField;

public class PzDialogPorezFiskal
extends PzDialogPorez {
    private static final long serialVersionUID = 3754714125154376114L;
    private PzPanelHeader header;
    private PzPanel panel;
    private PzButton btnOK;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzDoubleField iznos;
    private PzDoubleField osnovica;

    public PzDialogPorezFiskal() {
        this.initGUI();
    }

    public PzDialogPorezFiskal(JFrame frame) {
        this.initGUI();
    }

    @Override
    public void passSelectedPorez(PzTaksaDokument porez) throws Exception {
        super.passSelectedPorez(porez);
        this.iznos.setVal(porez.getIznos());
        this.osnovica.setVal(porez.getOsnovica());
    }

    @Override
    public void modifyPorez() {
        this.getSelectedPorez().setIznos(this.iznos.getBigDecimal());
        this.getSelectedPorez().setOsnovica(this.osnovica.getBigDecimal());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.confirmChanges();
    }

    protected void initGUI() {
        try {
            this.setResizable(false);
            this.header = new PzPanelHeader();
            this.header.setTitle("Unos poreza");
            this.header.setText("Napomena! Kod fiskalnog racuna se prvo unosi porez, a program na osnovu njega preracunava osnovicu");
            this.getContentPane().add((Component)this.header, "North");
            this.panel = new PzPanel();
            AnchorLayout panelLayout = new AnchorLayout();
            this.panel.setLayout(panelLayout);
            this.getContentPane().add((Component)this.panel, "Center");
            this.panel.setPreferredSize(new Dimension(349, 161));
            this.btnOK = new PzButton();
            this.panel.add((Component)this.btnOK, new AnchorConstraint(644, 792, 852, 491, 1, 1, 1, 1));
            this.btnOK.setText("Potvrdi");
            this.btnOK.setPreferredSize(new Dimension(105, 33));
            this.btnOK.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/check.png")));
            this.btnOK.addActionListener(this);
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, new AnchorConstraint(220, 379, 321, 216, 1, 1, 1, 1));
            this.jLabel2.setText("Porez:");
            this.jLabel2.setPreferredSize(new Dimension(57, 18));
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, new AnchorConstraint(432, 391, 539, 216, 1, 1, 1, 1));
            this.jLabel1.setText("Osnovica:");
            this.jLabel1.setPreferredSize(new Dimension(61, 19));
            this.iznos = new PzDoubleField();
            this.panel.add((Component)this.iznos, new AnchorConstraint(198, 792, 377, 491, 1, 1, 1, 1));
            this.iznos.setPreferredSize(new Dimension(105, 32));
            this.osnovica = new PzDoubleField();
            this.panel.add((Component)this.osnovica, new AnchorConstraint(410, 792, 578, 491, 1, 1, 1, 1));
            this.osnovica.setPreferredSize(new Dimension(105, 30));
            this.osnovica.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    PzDialogPorezFiskal.this.osnovicaFocusGained(evt);
                }
            });
            this.pack();
            this.setSize(365, 247);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void osnovicaFocusGained(FocusEvent evt) {
        Double izn = this.iznos.getVal();
        Double stopa = this.getSelectedPorez().getTarifnagrupa().getStopa();
        this.osnovica.setVal(izn * (100.0 + stopa) / stopa - izn);
    }

    @Override
    protected void thisWindowClosing(WindowEvent evt) {
    }
}

