/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.custom;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXStatusBar;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Komitent;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.fields.PzTextField;

public class PzDialogPretragaKomitenta
extends PzDialog {
    private static final long serialVersionUID = -6682949082704560509L;
    private PzPanel pnlContent;
    private PzTextField txtNaziv;
    private JXStatusBar status;
    private JScrollPane scp;
    private PzTable table;
    private PzButton btnTrazi;
    private JLabel lblNaziv;
    private JLabel lblBrPogodaka;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogPretragaKomitenta inst = new PzDialogPretragaKomitenta(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogPretragaKomitenta(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogPretragaKomitenta(PzDialog parent) {
        super(parent);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Prona\u0111i komitenta kome se pridru\u017euje email");
            this.pnlContent = new PzPanel();
            GridBagLayout pnlContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlContent, "Center");
            pnlContentLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
            pnlContentLayout.rowHeights = new int[]{7, 7, 7};
            pnlContentLayout.columnWeights = new double[]{0.0, 0.1, 0.0};
            pnlContentLayout.columnWidths = new int[]{7, 7, 20};
            this.pnlContent.setLayout(pnlContentLayout);
            this.pnlContent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.txtNaziv = new PzTextField();
            this.txtNaziv.removeEnterBehaviour();
            this.pnlContent.add((Component)this.txtNaziv, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.lblNaziv = new JLabel("Naziv komitenta: ");
            this.pnlContent.add((Component)this.lblNaziv, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.status = new JXStatusBar();
            this.status.add((Component)new JLabel("Broj pogodaka:"));
            this.lblBrPogodaka = new JLabel("0");
            this.status.add((Component)this.lblBrPogodaka);
            this.pnlContent.add((Component)this.status, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnTrazi = new PzButton("Tra\u017ei");
            this.getRootPane().setDefaultButton(this.btnTrazi);
            this.btnTrazi.addActionListener(this);
            this.pnlContent.add((Component)this.btnTrazi, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 5, 0), 0, 0));
            this.scp = new JScrollPane();
            this.pnlContent.add((Component)this.scp, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.table = new PzTable();
            this.table.setFilter(new PzEntityFilter(){

                @Override
                public Object[] getValues(PzEntity entity) {
                    Komitent e = (Komitent)entity;
                    return new Object[]{e.getNaziv(), String.valueOf(e.getPostBroj()) + " " + e.getGrad()};
                }

                @Override
                public String[] getColumnNames() {
                    return new String[]{"Naziv komitenta", "Mesto"};
                }
            });
            this.table.setEnterAction(new AbstractAction(){
                private static final long serialVersionUID = -5099097683364262821L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (PzDialogPretragaKomitenta.this.table.getRowCount() != 0) {
                        PzDialogPretragaKomitenta.this.getSession().putParameter("email_komitent", PzDialogPretragaKomitenta.this.table.getSelectedEntity());
                        PzDialogPretragaKomitenta.this.dispose();
                    }
                }
            });
            this.scp.setViewportView((Component)((Object)this.table));
            this.setSize(503, 444);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void trazi() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        String naziv = "'%" + this.txtNaziv.getVal().replace(" ", "%") + "%'";
        Query q = em.createQuery("SELECT k FROM Komitent k WHERE UPPER(k.naziv) LIKE :naziv".replace(":naziv", naziv.toUpperCase()));
        List komitents = q.getResultList();
        em.close();
        this.table.requestFocusInWindow();
        this.table.setData(komitents, Komitent.class);
        this.lblBrPogodaka.setText(String.valueOf(this.table.getRowCount()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.trazi();
    }
}

