/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.data.models;

import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.swing.data.models.TreeModelSupport;

public class PzTreeModelRG
extends TreeModelSupport
implements TreeModel {
    private Vector<Robnagrupa> data;

    public void setData(Vector<Robnagrupa> data) {
        this.data = data;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof Vector) {
            return ((Vector)parent).elementAt(index);
        }
        Robnagrupa rgr = (Robnagrupa)parent;
        return ((Vector)rgr.getPodGrupe()).elementAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof Vector) {
            return ((Vector)parent).size();
        }
        Robnagrupa rgr = (Robnagrupa)parent;
        return ((Vector)rgr.getPodGrupe()).size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof Vector) {
            return ((Vector)parent).indexOf(child);
        }
        Robnagrupa rgr = (Robnagrupa)parent;
        return ((Vector)rgr.getPodGrupe()).indexOf(child);
    }

    @Override
    public Object getRoot() {
        return this.data;
    }

    @Override
    public boolean isLeaf(Object arg0) {
        if (arg0 instanceof Vector) {
            return false;
        }
        return ((Robnagrupa)arg0).getPodGrupe() == null || ((Robnagrupa)arg0).getPodGrupe().size() == 0;
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    public void insertNode(Robnagrupa parent, Robnagrupa child) throws Exception {
        if (parent == null) {
            this.data.addElement(child);
            PzEntityManager.insert(child);
        } else {
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            Long brArt = (Long)em.createQuery("SELECT COUNT(a) FROM Artikal a WHERE a.robnagrupa=:rg").setParameter("rg", (Object)parent).getSingleResult();
            em.close();
            if (brArt > 0L) {
                throw new PzInfoException("Ne mo\u017eete dodati podgrupu grupi [ " + parent.getOznRobGr() + " ] " + parent.getNaziv() + " jer u njoj postoje artikli.\nRobna grupa koja sadr\u017ei artikle ne mo\u017ee imati podgrupe!");
            }
            if (parent.getPodGrupe() == null) {
                parent.setPodGrupe(new Vector<Robnagrupa>());
            }
            parent.getPodGrupe().add(parent.getPodGrupe().size(), child);
            child.setNadGrupa(parent);
            PzEntityManager.update(parent);
        }
    }

    public void removeNode(Robnagrupa parent, Robnagrupa child) throws Exception {
        if (parent == null) {
            this.data.remove(child);
        } else {
            child.setNadGrupa(null);
            parent.getPodGrupe().remove(child);
            PzEntityManager.update(parent);
        }
        PzEntityManager.delete(Robnagrupa.class, child.getOznRobGr());
    }

    public void updateNode(Robnagrupa oldRgr, Robnagrupa newRgr) throws Exception {
        oldRgr.setNaziv(newRgr.getNaziv());
        PzEntityManager.update(oldRgr);
    }
}

