/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.fields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import rs.pezar.swing.fields.PzFieldImpl;

public class PzDoubleField
extends PzFieldImpl {
    private static final long serialVersionUID = 654852381957120718L;
    private DefaultFormatterFactory formatterFactory;
    private NumberFormatter numberFormatter;
    private DecimalFormat decimalFormat = this.createDecimalFormat("###,###.00");

    public PzDoubleField() {
        this.numberFormatter = new NumberFormatter(this.decimalFormat);
        this.numberFormatter.setAllowsInvalid(false);
        this.numberFormatter.setMaximum(new Double(9.9999999999E10));
        this.formatterFactory = new DefaultFormatterFactory(this.numberFormatter, this.numberFormatter, this.numberFormatter);
        this.setFormatterFactory(this.formatterFactory);
        this.setValue(new Double(0.0));
        this.setHorizontalAlignment(11);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                if (arg0.getPropertyName().equals("value")) {
                    PzDoubleField.this.firePropertyChange("val", arg0.getOldValue(), arg0.getNewValue());
                }
            }
        });
    }

    @Override
    public Double getVal() {
        double res = 0.0;
        try {
            res = this.decimalFormat.parse(this.getText()).doubleValue();
        }
        catch (ParseException parseException) {}
        return res;
    }

    private Double getValStr(String s) {
        double res = 0.0;
        try {
            res = this.decimalFormat.parse(s).doubleValue();
        }
        catch (ParseException parseException) {}
        return res;
    }

    public BigDecimal getBigDecimal() {
        try {
            return (BigDecimal)this.decimalFormat.parse(this.getText());
        }
        catch (ParseException parseException) {
            return new BigDecimal(0);
        }
    }

    @Override
    public void setVal(Object value) {
        if (value == null) {
            return;
        }
        this.setValue(value);
    }

    @Deprecated
    public void setLimit(int intLen, int fractLen) {
    }

    @Override
    public void setFKField(Class c1, Class c2, boolean showDialog, String errorMessage) {
        throw new IllegalArgumentException("PzDoubleField ne podrzava metod setFKField()");
    }

    @Override
    public void setPKField(Class entityClass, String errorMessage) {
        throw new IllegalArgumentException("PzDoubleField ne podrzava metod setPKField()");
    }

    @Override
    public boolean isValueValid() {
        return this.getVal() != 0.0;
    }

    public void setDecimalFormat(DecimalFormat f) {
        this.numberFormatter.setFormat(f);
        this.decimalFormat = f;
        this.setValue(this.getVal());
    }

    private DecimalFormat createDecimalFormat(String pattern) {
        DecimalFormat df = new DecimalFormat(pattern);
        df.setDecimalFormatSymbols(new DecimalFormatSymbols(new Locale("sr")));
        df.setRoundingMode(RoundingMode.HALF_UP);
        df.setParseBigDecimal(true);
        return df;
    }
}

