/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.test;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Model;
import rs.pezar.swing.PzScrollableTableEntity;

public class SwingTest
extends JFrame {
    private JScrollPane scp;
    private JButton btnAzuriraj;
    private JButton btnDodaj;
    private JButton brnOsvezi;
    private JButton button;
    private PzScrollableTableEntity table;
    private EntityManager em;
    private ScrollableCursor cursor;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingTest inst = new SwingTest();
                inst.setLocationRelativeTo(null);
                inst.setVisible(true);
            }
        });
    }

    public SwingTest() {
        this.initGUI();
        this.loadData();
    }

    private void loadData() {
        if (this.em == null) {
            this.em = PzEntityManager.getEm();
        }
        Query q = this.em.createQuery("SELECT m FROM Model m ORDER BY m.oznModel");
        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
        q.setHint("eclipselink.read-only", (Object)"True");
        if (this.cursor != null && !this.cursor.isClosed()) {
            this.cursor.close();
        }
        this.cursor = (ScrollableCursor)q.getSingleResult();
        this.table.read(this.cursor);
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(3);
            this.getContentPane().setLayout(null);
            this.setPreferredSize(new Dimension(527, 408));
            this.scp = new JScrollPane();
            this.getContentPane().add(this.scp);
            this.scp.setBounds(12, 12, 495, 305);
            this.table = new PzScrollableTableEntity(Model.class);
            this.scp.setViewportView((Component)((Object)this.table));
            this.button = new JButton();
            this.getContentPane().add(this.button);
            this.button.setText("Brishi");
            this.button.setBounds(12, 323, 90, 28);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SwingTest.this.buttonActionPerformed(evt);
                }
            });
            this.brnOsvezi = new JButton();
            this.getContentPane().add(this.brnOsvezi);
            this.brnOsvezi.setText("Osvezi");
            this.brnOsvezi.setBounds(107, 323, 91, 28);
            this.brnOsvezi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SwingTest.this.brnOsveziActionPerformed(evt);
                }
            });
            this.btnDodaj = new JButton();
            this.getContentPane().add(this.btnDodaj);
            this.btnDodaj.setText("Dodaj");
            this.btnDodaj.setBounds(203, 323, 96, 28);
            this.btnDodaj.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SwingTest.this.btnDodajActionPerformed(evt);
                }
            });
            this.btnAzuriraj = new JButton();
            this.getContentPane().add(this.btnAzuriraj);
            this.btnAzuriraj.setText("Azuriraj");
            this.btnAzuriraj.setBounds(304, 323, 91, 28);
            this.btnAzuriraj.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SwingTest.this.btnAzurirajActionPerformed(evt);
                }
            });
            this.setSize(527, 408);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    SwingTest.this.cursor.close();
                    SwingTest.this.em.close();
                    PzEntityManagerFactory.getInstance().close();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buttonActionPerformed(ActionEvent evt) {
        this.table.removeSelectedEntity(true, true);
    }

    private void brnOsveziActionPerformed(ActionEvent evt) {
        this.loadData();
    }

    private void btnDodajActionPerformed(ActionEvent evt) {
        Model model1 = new Model();
        model1.setOznModel(String.valueOf(((Model)this.table.getSelectedEntity()).getOznModel()) + "+");
        model1.setNaziv(String.valueOf(((Model)this.table.getSelectedEntity()).getNaziv()) + "+");
        this.table.insert((PzEntity)model1, true);
    }

    private void btnAzurirajActionPerformed(ActionEvent evt) {
        Model model = (Model)this.table.getSelectedEntity();
        model.setNaziv(String.valueOf(model.getNaziv()) + "+");
        this.table.updateSelectedEntity((PzEntity)model, true);
    }
}

