/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.util;

import java.io.File;
import javax.persistence.EntityManager;
import rs.pezar.db.PzDokument;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Firma;
import rs.pezar.util.PzFileUtility;

public class PzCacheUtility {
    public static File getReportCacheDir(EntityManager em, PzDokument dok) throws Exception {
        File f;
        File firDir;
        String deljeniDir = PzParameter.getParameterValue("DELJENI_DIR", em);
        if (deljeniDir == null || deljeniDir.equals("")) {
            return null;
        }
        Firma fir = PzFirma.getFirma();
        if (fir == null) {
            fir = new Firma();
            fir.setNaziv("firma");
        }
        if (!(firDir = new File(String.valueOf(deljeniDir) + File.separator + fir.getNaziv().replaceAll("\\W", ""))).exists()) {
            firDir.mkdir();
        }
        if (!(f = new File(String.valueOf(firDir.getPath()) + File.separator + "cache")).exists()) {
            f.mkdir();
        }
        if (!(f = new File(String.valueOf(f.getPath()) + File.separator + (dok.getDatum() != null ? dok.getDatum().toString() : "no-date"))).exists()) {
            f.mkdir();
        }
        return f;
    }

    public static File getReportCacheDir(PzDokument dok) throws Exception {
        File f;
        File firDir;
        String deljeniDir = PzParameter.getParameterValue("DELJENI_DIR");
        if (deljeniDir == null || deljeniDir.equals("")) {
            return null;
        }
        Firma fir = PzFirma.getFirma();
        if (fir == null) {
            fir = new Firma();
            fir.setNaziv("firma");
        }
        if (!(firDir = new File(String.valueOf(deljeniDir) + File.separator + fir.getNaziv().replaceAll("\\W", ""))).exists()) {
            firDir.mkdir();
        }
        if (!(f = new File(String.valueOf(firDir.getPath()) + File.separator + "cache")).exists()) {
            f.mkdir();
        }
        if (!(f = new File(String.valueOf(f.getPath()) + File.separator + (dok.getDatum() != null ? dok.getDatum().toString() : "no-date"))).exists()) {
            f.mkdir();
        }
        return f;
    }

    public static File getJournalDir(String date) throws Exception {
        File f;
        File firDir;
        Firma fir;
        String deljeniDir = PzParameter.getParameterValue("DELJENI_DIR");
        if (deljeniDir == null || deljeniDir.equals("")) {
            deljeniDir = ".." + File.separator + "shared";
        }
        if ((fir = PzFirma.getFirma()) == null) {
            fir = new Firma();
            fir.setNaziv("firma");
        }
        if (!(firDir = new File(String.valueOf(deljeniDir) + File.separator + fir.getNaziv().replaceAll("\\W", ""))).exists()) {
            firDir.mkdir();
        }
        if (!(f = new File(String.valueOf(firDir.getPath()) + File.separator + "journal")).exists()) {
            f.mkdir();
        }
        if (!(f = new File(String.valueOf(f.getPath()) + File.separator + date)).exists()) {
            f.mkdir();
        }
        return f;
    }

    public static void clearReportCacheDir(EntityManager em) throws Exception {
        File f;
        String deljeniDir = PzParameter.getParameterValue("DELJENI_DIR", em);
        if (deljeniDir == null || deljeniDir.equals("")) {
            return;
        }
        Firma fir = PzFirma.getFirma();
        if (fir == null) {
            fir = new Firma();
            fir.setNaziv("firma");
        }
        if ((f = new File(String.valueOf(deljeniDir) + File.separator + fir.getNaziv().replaceAll("\\W", "") + File.separator + "cache")).exists()) {
            PzFileUtility.removeDirectory(f);
        }
    }

    public static void removeReportFromCache(PzDokument dok) throws Exception {
        File f;
        String deljeniDir = PzParameter.getParameterValue("DELJENI_DIR");
        if (deljeniDir == null || deljeniDir.equals("")) {
            return;
        }
        Firma fir = PzFirma.getFirma();
        if (fir == null) {
            fir = new Firma();
            fir.setNaziv("firma");
        }
        if ((f = new File(String.valueOf(deljeniDir) + File.separator + fir.getNaziv().replaceAll("\\W", "") + File.separator + "cache" + File.separator + (dok.getDatum() != null ? dok.getDatum().toString() : "no-date") + File.separator + dok.getIdDok() + ".jrprint")).exists()) {
            f.delete();
        }
    }
}

